/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.notification.plugin;

import java.util.List;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.transaction.FundsRequest;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;

public class FundsRequestNotificationPlugin
extends BaseNotificationPlugin {
    public FundsRequestNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return "FundsRequestNotificationPlugin";
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        Wallet requestSenderDetail = (Wallet)ctx.value(WalletUtils.FUNDS_REQUEST_SENDER_DETAIL_PARAMETER);
        Wallet requestSenderAccountDetail = (Wallet)ctx.value(WalletUtils.SENDER_ACCOUNT_DETAIL_PARAMETER);
        Wallet requestReceiverAccountDetail = (Wallet)ctx.value(WalletUtils.RECEIVER_ACCOUNT_DETAIL_PARAMETER);
        FundsRequest fundsRequest = (FundsRequest)ctx.value(WalletUtils.FUNDS_REQUEST_PARAMETER);
        List toList = WalletUtils.getNotificationReceiversUsers((Wallet)requestReceiverAccountDetail, (String)requestSenderDetail.getId());
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        String walletLink = WalletUtils.getWalletLink((String)fundsRequest.getReceipientType(), (String)fundsRequest.getReceipient());
        String requestAcceptURL = walletLink + "?receiver=" + requestSenderAccountDetail.getId() + "&receiver_type=" + requestSenderAccountDetail.getType() + "&amount=" + fundsRequest.getAmount();
        ContractDetail contractDetail = WalletUtils.getContractDetail();
        String symbol = contractDetail == null ? null : contractDetail.getSymbol();
        return NotificationInfo.instance().to(toList).with("amount", String.valueOf(fundsRequest.getAmount())).with("account_type", requestSenderAccountDetail.getType()).with("avatar", CommonsUtils.getCurrentDomain() + requestSenderAccountDetail.getAvatar()).with("senderUrl", WalletUtils.getPermanentLink((Wallet)requestSenderAccountDetail)).with("receiverUrl", WalletUtils.getPermanentLink((Wallet)requestReceiverAccountDetail)).with("fundsAcceptUrl", requestAcceptURL).with("userFullname", requestSenderDetail.getName()).with("userUrl", WalletUtils.getPermanentLink((Wallet)requestSenderDetail)).with("sender", requestSenderAccountDetail.getName()).with("receiver", requestReceiverAccountDetail.getName()).with("symbol", symbol).with("message", fundsRequest.getMessage() == null ? "" : fundsRequest.getMessage()).key(this.getKey()).end();
    }
}

