/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.idm.PicketLinkIDMCacheService;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.hibernate.Session;
import org.hibernate.jdbc.ReturningWork;

public class EnableUserUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(EnableUserUpgradePlugin.class);
    private HibernateService hibernateService;
    private PicketLinkIDMCacheService picketLinkIDMCacheService;
    private OrganizationService organizationService;
    private final String SELECT_COUNT_ENABLE_ATTRIBUTE = "select count(*) from jbid_io_attr  inner join jbid_io_attr_text_values  on jbid_io_attr.ATTRIBUTE_ID =jbid_io_attr_text_values.TEXT_ATTR_VALUE_ID where NAME='enabled' and ATTR_VALUE='true'";
    private final String SELECT_ENABLE_ATTRIBUTE = "select ATTRIBUTE_ID from jbid_io_attr  inner join jbid_io_attr_text_values  on jbid_io_attr.ATTRIBUTE_ID =jbid_io_attr_text_values.TEXT_ATTR_VALUE_ID where NAME='enabled' and ATTR_VALUE='true'";
    private final String REMOVE_ENABLE_ATTRIBUTE = "delete from jbid_io_attr where ATTRIBUTE_ID IN ( ";
    private final String REMOVE_ENABLE_ATTRIBUTE_VALUE = "delete from jbid_io_attr_text_values where TEXT_ATTR_VALUE_ID IN (";
    private final String COLUMN_ID = "ATTRIBUTE_ID";
    private PreparedStatement findItemsStatement = null;
    private PreparedStatement countItemsStatement = null;
    private PreparedStatement removeItemStatement = null;
    private PreparedStatement removeValueStatement = null;

    public EnableUserUpgradePlugin(InitParams initParams, HibernateService hibernateService, OrganizationService organizationService, PicketLinkIDMCacheService picketLinkIDMCacheService) {
        super(initParams);
        this.hibernateService = hibernateService;
        this.picketLinkIDMCacheService = picketLinkIDMCacheService;
        this.organizationService = organizationService;
    }

    public boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        long started;
        int nb;
        boolean success;
        boolean auto;
        Connection connection;
        ResultSet count;
        ResultSet rs;
        Session session;
        block82: {
            session = this.hibernateService.openNewSession();
            rs = null;
            count = null;
            connection = null;
            auto = false;
            success = false;
            nb = 0;
            started = System.currentTimeMillis();
            try {
                connection = (Connection)session.doReturningWork((ReturningWork)new ReturningWork<Connection>(){

                    public Connection execute(Connection conn) throws SQLException {
                        return conn;
                    }
                });
                if (connection != null) {
                    auto = connection.getAutoCommit();
                    connection.setAutoCommit(false);
                    this.countItemsStatement = connection.prepareStatement("select count(*) from jbid_io_attr  inner join jbid_io_attr_text_values  on jbid_io_attr.ATTRIBUTE_ID =jbid_io_attr_text_values.TEXT_ATTR_VALUE_ID where NAME='enabled' and ATTR_VALUE='true'");
                    count = this.countItemsStatement.executeQuery();
                    if (count.next() && count.getInt(1) > 0) {
                        nb = count.getInt(1);
                        this.findItemsStatement = connection.prepareStatement("select ATTRIBUTE_ID from jbid_io_attr  inner join jbid_io_attr_text_values  on jbid_io_attr.ATTRIBUTE_ID =jbid_io_attr_text_values.TEXT_ATTR_VALUE_ID where NAME='enabled' and ATTR_VALUE='true'");
                        this.findItemsStatement.setFetchSize(1000);
                        LOG.info((Object)"Start Select items NAME=enabled and ATTR_VALUE=true");
                        rs = this.findItemsStatement.executeQuery();
                        StringBuilder temp = new StringBuilder();
                        int i = 0;
                        while (rs.next()) {
                            temp.append(rs.getString("ATTRIBUTE_ID"));
                            if (++i % 1000 == 0) {
                                this.removeBatch(connection, temp.toString());
                                connection.commit();
                                LOG.info("Clean in progress : {}/{}", new Object[]{i, nb});
                                temp = new StringBuilder();
                                continue;
                            }
                            temp.append(",");
                        }
                        if (i % 1000 != 0) {
                            this.removeBatch(connection, temp.substring(0, temp.lastIndexOf(",")));
                            connection.commit();
                            LOG.info("Clean in progress : {}/{}", new Object[]{i, nb});
                        }
                    }
                    success = true;
                }
                if (this.picketLinkIDMCacheService == null) break block82;
            }
            catch (SQLException e) {
                block83: {
                    try {
                        LOG.error((Object)"Error while Clean items", (Throwable)e);
                        if (this.picketLinkIDMCacheService == null) break block83;
                    }
                    catch (Throwable throwable) {
                        if (this.picketLinkIDMCacheService != null) {
                            this.picketLinkIDMCacheService.invalidateAll();
                        }
                        if (this.organizationService != null && this.organizationService instanceof PicketLinkIDMOrganizationServiceImpl) {
                            ((PicketLinkIDMOrganizationServiceImpl)this.organizationService).clearCaches();
                        }
                        if (connection != null) {
                            try {
                                connection.setAutoCommit(auto);
                            }
                            catch (SQLException e2) {
                                LOG.error((Object)"Can't change auto commit", (Throwable)e2);
                            }
                        }
                        if (count != null) {
                            try {
                                count.close();
                            }
                            catch (SQLException e3) {
                                LOG.error((Object)("Can't close the ResultSet: " + e3.getMessage()));
                            }
                        }
                        if (rs != null) {
                            try {
                                count.close();
                            }
                            catch (SQLException e4) {
                                LOG.error((Object)("Can't close the ResultSet: " + e4.getMessage()));
                            }
                        }
                        if (this.countItemsStatement != null) {
                            try {
                                this.countItemsStatement.close();
                            }
                            catch (SQLException e5) {
                                LOG.error((Object)"Can't close statement", (Throwable)e5);
                            }
                        }
                        if (this.findItemsStatement != null) {
                            try {
                                this.findItemsStatement.close();
                            }
                            catch (SQLException e6) {
                                LOG.error((Object)"Can't close statement", (Throwable)e6);
                            }
                        }
                        if (this.removeItemStatement != null) {
                            try {
                                this.removeItemStatement.close();
                            }
                            catch (SQLException e7) {
                                LOG.error((Object)"Can't close statement", (Throwable)e7);
                            }
                        }
                        if (this.removeValueStatement != null) {
                            try {
                                this.removeValueStatement.close();
                            }
                            catch (SQLException e8) {
                                LOG.error((Object)"Can't close statement", (Throwable)e8);
                            }
                        }
                        if (session != null) {
                            session.close();
                        }
                        if (!success) {
                            LOG.error((Object)"An unexpected error occurs when migrating");
                            throw new RuntimeException("Error during remove enable attribute");
                        }
                        LOG.info("Finished successfully  on {} milliseconds, Clean {} items", new Object[]{System.currentTimeMillis() - started, nb});
                        throw throwable;
                    }
                    this.picketLinkIDMCacheService.invalidateAll();
                }
                if (this.organizationService != null && this.organizationService instanceof PicketLinkIDMOrganizationServiceImpl) {
                    ((PicketLinkIDMOrganizationServiceImpl)this.organizationService).clearCaches();
                }
                if (connection != null) {
                    try {
                        connection.setAutoCommit(auto);
                    }
                    catch (SQLException e9) {
                        LOG.error((Object)"Can't change auto commit", (Throwable)e9);
                    }
                }
                if (count != null) {
                    try {
                        count.close();
                    }
                    catch (SQLException e10) {
                        LOG.error((Object)("Can't close the ResultSet: " + e10.getMessage()));
                    }
                }
                if (rs != null) {
                    try {
                        count.close();
                    }
                    catch (SQLException e11) {
                        LOG.error((Object)("Can't close the ResultSet: " + e11.getMessage()));
                    }
                }
                if (this.countItemsStatement != null) {
                    try {
                        this.countItemsStatement.close();
                    }
                    catch (SQLException e12) {
                        LOG.error((Object)"Can't close statement", (Throwable)e12);
                    }
                }
                if (this.findItemsStatement != null) {
                    try {
                        this.findItemsStatement.close();
                    }
                    catch (SQLException e13) {
                        LOG.error((Object)"Can't close statement", (Throwable)e13);
                    }
                }
                if (this.removeItemStatement != null) {
                    try {
                        this.removeItemStatement.close();
                    }
                    catch (SQLException e14) {
                        LOG.error((Object)"Can't close statement", (Throwable)e14);
                    }
                }
                if (this.removeValueStatement != null) {
                    try {
                        this.removeValueStatement.close();
                    }
                    catch (SQLException e15) {
                        LOG.error((Object)"Can't close statement", (Throwable)e15);
                    }
                }
                if (session != null) {
                    session.close();
                }
                if (success) {
                    LOG.info("Finished successfully  on {} milliseconds, Clean {} items", new Object[]{System.currentTimeMillis() - started, nb});
                    return;
                }
                LOG.error((Object)"An unexpected error occurs when migrating");
                throw new RuntimeException("Error during remove enable attribute");
            }
            this.picketLinkIDMCacheService.invalidateAll();
        }
        if (this.organizationService != null && this.organizationService instanceof PicketLinkIDMOrganizationServiceImpl) {
            ((PicketLinkIDMOrganizationServiceImpl)this.organizationService).clearCaches();
        }
        if (connection != null) {
            try {
                connection.setAutoCommit(auto);
            }
            catch (SQLException e) {
                LOG.error((Object)"Can't change auto commit", (Throwable)e);
            }
        }
        if (count != null) {
            try {
                count.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
            }
        }
        if (rs != null) {
            try {
                count.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
            }
        }
        if (this.countItemsStatement != null) {
            try {
                this.countItemsStatement.close();
            }
            catch (SQLException e) {
                LOG.error((Object)"Can't close statement", (Throwable)e);
            }
        }
        if (this.findItemsStatement != null) {
            try {
                this.findItemsStatement.close();
            }
            catch (SQLException e) {
                LOG.error((Object)"Can't close statement", (Throwable)e);
            }
        }
        if (this.removeItemStatement != null) {
            try {
                this.removeItemStatement.close();
            }
            catch (SQLException e) {
                LOG.error((Object)"Can't close statement", (Throwable)e);
            }
        }
        if (this.removeValueStatement != null) {
            try {
                this.removeValueStatement.close();
            }
            catch (SQLException e) {
                LOG.error((Object)"Can't close statement", (Throwable)e);
            }
        }
        if (session != null) {
            session.close();
        }
        if (success) {
            LOG.info("Finished successfully  on {} milliseconds, Clean {} items", new Object[]{System.currentTimeMillis() - started, nb});
            return;
        }
        LOG.error((Object)"An unexpected error occurs when migrating");
        throw new RuntimeException("Error during remove enable attribute");
    }

    private void removeBatch(Connection connection, String temp) throws SQLException {
        String query2 = "delete from jbid_io_attr_text_values where TEXT_ATTR_VALUE_ID IN (" + temp + ")";
        this.removeValueStatement = connection.prepareStatement(query2);
        this.removeValueStatement.execute();
        String query1 = "delete from jbid_io_attr where ATTRIBUTE_ID IN ( " + temp + ")";
        this.removeItemStatement = connection.prepareStatement(query1);
        this.removeItemStatement.execute();
    }
}

