/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.kudos.service;

import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addon.kudos.model.AccountSettings;
import org.exoplatform.addon.kudos.model.GlobalSettings;
import org.exoplatform.addon.kudos.model.Kudos;
import org.exoplatform.addon.kudos.model.KudosPeriod;
import org.exoplatform.addon.kudos.service.KudosStorage;
import org.exoplatform.addon.kudos.service.utils.Utils;
import org.exoplatform.addon.kudos.statistic.ExoKudosStatistic;
import org.exoplatform.addon.kudos.statistic.ExoKudosStatisticAspect;
import org.exoplatform.addon.kudos.statistic.ExoKudosStatisticService;
import org.exoplatform.addon.kudos.statistic.StatisticUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class KudosService
implements ExoKudosStatisticService,
Startable {
    private static final Log LOG;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private KudosStorage kudosStorage;
    private SettingService settingService;
    private GlobalSettings globalSettings;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public KudosService(KudosStorage kudosStorage, SettingService settingService, SpaceService spaceService, IdentityManager identityManager, ListenerService listenerService, InitParams params) {
        this.kudosStorage = kudosStorage;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.settingService = settingService;
        this.listenerService = listenerService;
        if (params != null) {
            this.globalSettings = new GlobalSettings();
            if (params.containsKey((Object)"defaultAccessPermission")) {
                String defaultAccessPermission = params.getValueParam("defaultAccessPermission").getValue();
                this.globalSettings.setAccessPermission(defaultAccessPermission);
            }
            if (params.containsKey((Object)"defaultKudosPerPeriod")) {
                String defaultKudosPerPeriod = params.getValueParam("defaultKudosPerPeriod").getValue();
                this.globalSettings.setKudosPerPeriod(Long.parseLong(defaultKudosPerPeriod));
            }
        }
    }

    public void start() {
        GlobalSettings loadedGlobalSettings = this.loadGlobalSettings();
        if (loadedGlobalSettings != null) {
            this.globalSettings = loadedGlobalSettings;
        }
    }

    public void stop() {
    }

    public AccountSettings getAccountSettings(String username) {
        AccountSettings accountSettings = new AccountSettings();
        if (!this.isAuthorized(username)) {
            accountSettings.setDisabled(true);
            return accountSettings;
        }
        long sentKudos = this.countKudosBySenderInCurrentPeriod(username);
        accountSettings.setRemainingKudos(this.getKudosPerPeriod() - sentKudos);
        return accountSettings;
    }

    public void saveKudosActivity(long kudosId, long activityId) throws Exception {
        this.kudosStorage.saveKudosActivityId(kudosId, activityId);
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        this.listenerService.broadcast("exo.addons.kudos.activity", (Object)this, (Object)kudos);
    }

    @ExoKudosStatistic(local=true, service="kudos", operation="create_kudos")
    public Kudos sendKudos(Kudos kudos, String senderId) throws Exception {
        Kudos kudos2 = kudos;
        String string = senderId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)kudos2, (Object)string);
        return (Kudos)KudosService.sendKudos_aroundBody1$advice(this, kudos2, string, joinPoint, ExoKudosStatisticAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public List<Kudos> getAllKudosByPeriod(long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod period = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.getAllKudosByPeriod(period);
    }

    public List<Kudos> getAllKudosByPeriodOfDate(long dateInSeconds) {
        KudosPeriod period = this.getKudosPeriodOfTime(dateInSeconds);
        return this.kudosStorage.getAllKudosByPeriod(period);
    }

    public List<Kudos> getAllKudosByEntity(String entityType, String entityId) {
        return this.kudosStorage.getAllKudosByEntity(entityType, entityId);
    }

    public List<Kudos> getAllKudosByEntityTypeInCurrentPeriod(String entityType) {
        return this.kudosStorage.getAllKudosByPeriodAndEntityType(this.getCurrentKudosPeriod(), entityType);
    }

    public List<Kudos> getAllKudosBySenderInCurrentPeriod(String identityId) {
        List<Kudos> kudosBySender = this.kudosStorage.getKudosByPeriodAndSender(this.getCurrentKudosPeriod(), identityId);
        if (kudosBySender != null) {
            Collections.sort(kudosBySender);
        }
        return kudosBySender;
    }

    public long countKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        Identity identity = this.identityManager.getIdentity(String.valueOf(identityId), true);
        if (identity == null) {
            return 0L;
        }
        return this.kudosStorage.countKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId());
    }

    public List<Kudos> getKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        Identity identity = this.identityManager.getIdentity(String.valueOf(identityId), true);
        if (identity == null) {
            return Collections.emptyList();
        }
        return this.kudosStorage.getKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId());
    }

    public List<Kudos> getKudosByReceiverInCurrentPeriod(String receiverType, String receiverId) {
        List<Kudos> kudosList = this.kudosStorage.getKudosByPeriodAndReceiver(this.getCurrentKudosPeriod(), receiverType, receiverId);
        if (kudosList != null) {
            Collections.sort(kudosList);
        }
        return kudosList;
    }

    public long countKudosBySenderInCurrentPeriod(String senderId) {
        return this.kudosStorage.countKudosByPeriodAndSender(this.getCurrentKudosPeriod(), senderId);
    }

    public void saveGlobalSettings(GlobalSettings settings) {
        this.settingService.set(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS", SettingValue.create((String)settings.toStringToPersist()));
        this.globalSettings = null;
    }

    public GlobalSettings getGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = this.loadGlobalSettings();
        }
        return this.globalSettings;
    }

    public long getKudosPerPeriod() {
        GlobalSettings storedGlobalSettings = this.getGlobalSettings();
        return storedGlobalSettings == null ? 0L : storedGlobalSettings.getKudosPerPeriod();
    }

    public String getAccessPermission() {
        GlobalSettings storedGlobalSettings = this.getGlobalSettings();
        return storedGlobalSettings == null ? null : storedGlobalSettings.getAccessPermission();
    }

    public boolean isAuthorized(String username) {
        if (StringUtils.isBlank((String)username)) {
            return false;
        }
        String accessPermission = this.getAccessPermission();
        if (StringUtils.isBlank((String)accessPermission)) {
            return true;
        }
        Space space = Utils.getSpace(accessPermission);
        return this.spaceService.isSuperManager(username) || space != null && this.spaceService.isMember(space, username);
    }

    @Override
    public Map<String, Object> getStatisticParameters(String operation, Object result, Object ... methodArgs) {
        if (result == null) {
            return null;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Kudos savedKudos = (Kudos)result;
        parameters.put("kudos_id", savedKudos.getTechnicalId());
        parameters.put("sender_identity_id", savedKudos.getSenderIdentityId());
        parameters.put("receiver_identity_id", savedKudos.getReceiverIdentityId());
        parameters.put("kudos_entity_type", savedKudos.getEntityType());
        parameters.put("kudos_entity_id", savedKudos.getEntityId());
        String issuer = (String)methodArgs[methodArgs.length - 1];
        if (StringUtils.isNotBlank((String)issuer)) {
            Identity identity = Utils.getIdentityByTypeAndId("organization", issuer);
            if (identity == null) {
                LOG.debug((Object)("Can't find identity with remote id: {}" + issuer));
            } else {
                parameters.put("user_social_id", identity.getId());
            }
        }
        return parameters;
    }

    private KudosPeriod getCurrentKudosPeriod() {
        return Utils.getCurrentPeriod(this.getGlobalSettings());
    }

    private KudosPeriod getKudosPeriodOfTime(long dateInSeconds) {
        return Utils.getPeriodOfTime(this.getGlobalSettings(), Utils.timeFromSeconds(dateInSeconds));
    }

    private Object checkStatusAndGetReceiver(String type, String id) {
        if ("user".equals(type) || "organization".equals(type)) {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", id, true);
            if (identity == null || !identity.isEnable() || identity.isDeleted()) {
                throw new IllegalStateException("User '" + id + "' doesn't have a valid and enabled social identity");
            }
            if (!this.isAuthorized(id)) {
                throw new IllegalStateException("User '" + id + "' isn't member of authorized group to send/receive kudos: " + this.getAccessPermission());
            }
            return identity;
        }
        Space space = Utils.getSpace(id);
        if (space == null) {
            throw new IllegalStateException("Space '" + id + "' wasn't found, thus it can't receive/send kudos");
        }
        return space;
    }

    private GlobalSettings loadGlobalSettings() {
        SettingValue globalSettingsValue = this.settingService.get(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS");
        if (globalSettingsValue == null || StringUtils.isBlank((String)globalSettingsValue.getValue().toString())) {
            return null;
        }
        return GlobalSettings.parseStringToObject(globalSettingsValue.getValue().toString());
    }

    static {
        KudosService.ajc$preClinit();
        LOG = ExoLogger.getLogger(KudosService.class);
    }

    private static /* synthetic */ Kudos sendKudos_aroundBody0(KudosService ajc$this, Kudos kudos, String senderId, JoinPoint joinPoint) {
        if (!StringUtils.equals((String)senderId, (String)kudos.getSenderId())) {
            throw new IllegalAccessException("User with id '" + senderId + "' is not authorized to send kudos on behalf of " + kudos.getSenderId());
        }
        if (StringUtils.equals((String)senderId, (String)kudos.getReceiverId())) {
            throw new IllegalAccessException("User with username '" + senderId + "' is not authorized to send kudos to himseld!");
        }
        KudosPeriod currentPeriod = ajc$this.getCurrentKudosPeriod();
        if (ajc$this.kudosStorage.countKudosByPeriodAndSender(currentPeriod, senderId) >= ajc$this.getKudosPerPeriod()) {
            throw new IllegalAccessException("User having username'" + senderId + "' is not authorized to send more kudos");
        }
        Identity senderIdentity = (Identity)ajc$this.checkStatusAndGetReceiver("organization", senderId);
        if (kudos.getSenderIdentityId() == null) {
            kudos.setSenderIdentityId(senderIdentity.getId());
        }
        Object receiverObject = ajc$this.checkStatusAndGetReceiver(kudos.getReceiverType(), kudos.getReceiverId());
        if (kudos.getReceiverIdentityId() == null) {
            if (receiverObject instanceof Identity) {
                kudos.setReceiverIdentityId(((Identity)receiverObject).getId());
            } else if (receiverObject instanceof Space) {
                kudos.setReceiverIdentityId(((Space)receiverObject).getId());
            }
        }
        kudos.setTime(LocalDateTime.now());
        kudos = ajc$this.kudosStorage.createKudos(kudos);
        ajc$this.listenerService.broadcast("exo.addons.kudos.sent", (Object)ajc$this, (Object)kudos);
        return kudos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object sendKudos_aroundBody1$advice(KudosService ajc$this, Kudos kudos, String senderId, JoinPoint thisJoinPoint, ExoKudosStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        Kudos kudos2;
        ExoKudosStatisticService statisticService = (ExoKudosStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoKudosStatistic annotation = method.getAnnotation(ExoKudosStatistic.class);
        boolean local = annotation.local();
        String service = annotation.service();
        String operation = annotation.operation();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        Kudos result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            kudos2 = result = KudosService.sendKudos_aroundBody0(ajc$this, kudos, senderId, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
                    if (parameters == null) throw throwable;
                    if (local) {
                        parameters.put("local_service", service);
                    } else {
                        parameters.put("remote_service", service);
                    }
                    if (!parameters.containsKey("operation")) {
                        parameters.put("operation", operation);
                    }
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry(parameters);
                    throw throwable;
                }
                catch (Throwable e2) {
                    ExoKudosStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_kudos_statistic_ExoKudosStatisticAspect$org_exoplatform_addon_kudos_statistic_ExoKudosStatisticAspect$LOG().warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
            if (parameters == null) return kudos2;
            if (local) {
                parameters.put("local_service", service);
            } else {
                parameters.put("remote_service", service);
            }
            if (!parameters.containsKey("operation")) {
                parameters.put("operation", operation);
            }
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry(parameters);
            return kudos2;
        }
        catch (Throwable e) {
            ExoKudosStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_addon_kudos_statistic_ExoKudosStatisticAspect$org_exoplatform_addon_kudos_statistic_ExoKudosStatisticAspect$LOG().warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e});
        }
        return kudos2;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("KudosService.java", KudosService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sendKudos", "org.exoplatform.addon.kudos.service.KudosService", "org.exoplatform.addon.kudos.model.Kudos:java.lang.String", "kudos:senderId", "java.lang.Exception", "org.exoplatform.addon.kudos.model.Kudos"), 122);
    }
}

