/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.ActiveIdentityFilter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.IdentityWithRelationship;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.IdentityStorageException;

public interface IdentityStorage {
    public static final Sorting DEFAULT_SORTING = new Sorting(Sorting.SortBy.FULLNAME, Sorting.OrderBy.ASC);
    public static final char EMPTY_CHARACTER = '\u0000';

    public void saveIdentity(Identity var1) throws IdentityStorageException;

    public Identity updateIdentity(Identity var1) throws IdentityStorageException;

    public void updateIdentityMembership(String var1) throws IdentityStorageException;

    public Identity findIdentityById(String var1) throws IdentityStorageException;

    public void deleteIdentity(Identity var1) throws IdentityStorageException;

    public void hardDeleteIdentity(Identity var1) throws IdentityStorageException;

    public Profile loadProfile(Profile var1) throws IdentityStorageException;

    public Identity findIdentity(String var1, String var2) throws IdentityStorageException;

    public void saveProfile(Profile var1) throws IdentityStorageException;

    public void updateProfile(Profile var1) throws IdentityStorageException;

    public int getIdentitiesCount(String var1) throws IdentityStorageException;

    public List<Identity> getIdentitiesByProfileFilter(String var1, ProfileFilter var2, long var3, long var5, boolean var7) throws IdentityStorageException;

    public List<Identity> getIdentitiesForMentions(String var1, ProfileFilter var2, Relationship.Type var3, long var4, long var6, boolean var8) throws IdentityStorageException;

    public int getIdentitiesForMentionsCount(String var1, ProfileFilter var2, Relationship.Type var3) throws IdentityStorageException;

    public List<Identity> getIdentitiesForUnifiedSearch(String var1, ProfileFilter var2, long var3, long var5) throws IdentityStorageException;

    public int getIdentitiesByProfileFilterCount(String var1, ProfileFilter var2) throws IdentityStorageException;

    public int getIdentitiesByFirstCharacterOfNameCount(String var1, ProfileFilter var2) throws IdentityStorageException;

    @Deprecated
    public List<Identity> getIdentitiesByFirstCharacterOfName(String var1, ProfileFilter var2, long var3, long var5, boolean var7) throws IdentityStorageException;

    public String getType(String var1, String var2);

    public void addOrModifyProfileProperties(Profile var1) throws IdentityStorageException;

    public List<Identity> getSpaceMemberIdentitiesByProfileFilter(Space var1, ProfileFilter var2, SpaceMemberFilterListAccess.Type var3, long var4, long var6) throws IdentityStorageException;

    public void updateProfileActivityId(Identity var1, String var2, Profile.AttachedActivityType var3);

    public String getProfileActivityId(Profile var1, Profile.AttachedActivityType var2);

    public Set<String> getActiveUsers(ActiveIdentityFilter var1);

    public void processEnabledIdentity(Identity var1, boolean var2);

    public List<IdentityWithRelationship> getIdentitiesWithRelationships(String var1, int var2, int var3);

    default public List<IdentityWithRelationship> getIdentitiesWithRelationships(String identityId, String firstCharFieldName, char firstChar, String sortFieldName, String sortDirection, int offset, int limit) {
        throw new UnsupportedOperationException("This operation is not supported using current implementation of service IdentityStorage");
    }

    public int countIdentitiesWithRelationships(String var1) throws Exception;

    public InputStream getAvatarInputStreamById(Identity var1) throws IOException;

    public InputStream getBannerInputStreamById(Identity var1) throws IOException;

    public int countSpaceMemberIdentitiesByProfileFilter(Space var1, ProfileFilter var2, SpaceMemberFilterListAccess.Type var3);

    default public List<Identity> getIdentities(String providerId, long offset, long limit) {
        throw new UnsupportedOperationException("This operation is not supported using current implementation of service IdentityStorage");
    }

    default public List<Identity> getIdentities(String providerId, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection, long offset, long limit) {
        throw new UnsupportedOperationException("This operation is not supported using current implementation of service IdentityStorage");
    }

    @Deprecated
    default public List<String> sortIdentities(List<String> identityRemoteIds, String sortField) {
        return this.sortIdentities(identityRemoteIds, null, '\u0000', sortField, IdentityStorage.DEFAULT_SORTING.orderBy.name());
    }

    default public List<String> sortIdentities(List<String> identityRemoteIds, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection) {
        return identityRemoteIds;
    }
}

