/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.storage.cache.model.data.CacheData;

public class ProfileData
implements CacheData<Profile> {
    public static final ProfileData NULL_OBJECT = new ProfileData(null);
    private static final long serialVersionUID = 1308337180458451775L;
    private String profileId;
    private String identityId;
    private String providerId;
    private String remoteId;
    private boolean hasChanged;
    private Map<String, Object> data;
    private String url;
    private String avatarUrl;
    private String bannerUrl;
    private Long avatarLastUpdated;
    private Long bannerLastUpdated;
    private Long createdTime;

    public ProfileData(Profile profile) {
        if (profile == null) {
            this.data = Collections.unmodifiableMap(new HashMap());
        } else {
            this.profileId = profile.getId();
            this.identityId = profile.getIdentity().getId();
            this.providerId = profile.getIdentity().getProviderId();
            this.remoteId = profile.getIdentity().getRemoteId();
            this.hasChanged = profile.hasChanged();
            this.data = Collections.unmodifiableMap(profile.getProperties());
            this.url = profile.getUrl();
            this.avatarUrl = profile.getAvatarUrl();
            this.bannerUrl = profile.getBannerUrl();
            this.avatarLastUpdated = profile.getAvatarLastUpdated();
            this.bannerLastUpdated = profile.getBannerLastUpdated();
            this.createdTime = profile.getCreatedTime();
        }
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getIdentityId() {
        return this.identityId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public Profile build() {
        Identity identity = new Identity(this.identityId);
        identity.setProviderId(this.providerId);
        identity.setRemoteId(this.remoteId);
        Profile profile = new Profile(identity);
        profile.setId(this.profileId);
        profile.setUrl(this.url);
        profile.setAvatarUrl(this.avatarUrl);
        profile.setBannerUrl(this.bannerUrl);
        profile.setAvatarLastUpdated(this.avatarLastUpdated);
        profile.setBannerLastUpdated(this.bannerLastUpdated);
        profile.setCreatedTime(this.createdTime);
        for (String key : this.data.keySet()) {
            profile.setProperty(key, this.data.get(key));
        }
        identity.setProfile(profile);
        if (!this.hasChanged) {
            profile.clearHasChanged();
        }
        return profile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileData that = (ProfileData)o;
        return this.hasChanged == that.hasChanged && Objects.equals(this.profileId, that.profileId) && Objects.equals(this.identityId, that.identityId) && Objects.equals(this.providerId, that.providerId) && Objects.equals(this.remoteId, that.remoteId) && Objects.equals(this.data, that.data) && Objects.equals(this.url, that.url) && Objects.equals(this.avatarUrl, that.avatarUrl) && Objects.equals(this.bannerUrl, that.bannerUrl) && Objects.equals(this.avatarLastUpdated, that.avatarLastUpdated) && Objects.equals(this.bannerLastUpdated, that.bannerLastUpdated) && Objects.equals(this.createdTime, that.createdTime);
    }

    public int hashCode() {
        return Objects.hash(this.profileId, this.identityId, this.providerId, this.remoteId, this.hasChanged, this.data, this.url, this.avatarUrl, this.bannerUrl, this.avatarLastUpdated, this.bannerLastUpdated, this.createdTime);
    }
}

