/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.csrf;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.gatein.common.util.UUIDGenerator;

public class CSRFTokenUtil {
    public static final String CSRF_TOKEN = "gtn:csrf";
    protected static Log log = ExoLogger.getExoLogger(CSRFTokenUtil.class);
    protected static final UUIDGenerator generator = new UUIDGenerator();

    public static boolean check(HttpServletRequest request) {
        if (request != null) {
            String sessionToken = CSRFTokenUtil.getToken(request);
            String reqToken = request.getParameter(CSRF_TOKEN);
            return reqToken != null && reqToken.equals(sessionToken);
        }
        log.warn((Object)"No HttpServletRequest found, can't check CSRF");
        return false;
    }

    public static String getToken(HttpServletRequest request) {
        if (request != null) {
            if (request.getRemoteUser() == null) {
                HttpSession session = request.getSession();
                String token = (String)session.getAttribute(CSRF_TOKEN);
                if (token == null) {
                    token = generator.generateKey();
                    session.setAttribute(CSRF_TOKEN, (Object)token);
                }
                return token;
            }
            ConversationState conversationState = ConversationState.getCurrent();
            if (conversationState != null && conversationState.getIdentity() != null) {
                String token = (String)conversationState.getAttribute(CSRF_TOKEN);
                if (token == null) {
                    token = generator.generateKey();
                    conversationState.setAttribute(CSRF_TOKEN, (Object)token);
                }
                return token;
            }
            return null;
        }
        log.warn((Object)"No HttpServletRequest found, can't generate CSRF token");
        return null;
    }
}

