/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.binding.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.management.binding.xml.AbstractMarshaller;
import org.exoplatform.portal.mop.management.binding.xml.Element;
import org.gatein.common.xml.stax.navigator.Exceptions;
import org.gatein.common.xml.stax.navigator.StaxNavUtils;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.StaxWriterUtils;
import org.gatein.common.xml.stax.writer.WritableValueType;
import org.gatein.common.xml.stax.writer.WritableValueTypes;
import org.gatein.common.xml.stax.writer.builder.StaxWriterBuilder;
import org.gatein.management.api.binding.BindingException;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;
import org.staxnav.ValueType;

public class PageMarshaller
extends AbstractMarshaller<Page.PageSet> {
    public void marshal(Page.PageSet pageSet, OutputStream outputStream, boolean pretty) throws BindingException {
        try {
            StaxWriterBuilder builder = StaxWriterUtils.buildDefaultWriter((OutputStream)outputStream);
            if (!pretty) {
                builder.withFormatting(null);
            }
            StaxWriter writer = builder.build(Element.class);
            writer.writeStartElement((Object)Element.PAGE_SET);
            this.writeGateinObjectsNamespace((StaxWriter<Element>)writer);
            for (Page page : pageSet.getPages()) {
                this.marshalPage((StaxWriter<Element>)writer, page);
            }
            writer.finish();
        }
        catch (StaxNavException e) {
            throw new BindingException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public Page.PageSet unmarshal(InputStream inputStream) throws BindingException {
        try {
            StaxNavigator navigator = StaxNavUtils.createNavigator(Element.class, (Enum)Element.UNKNOWN, (InputStream)inputStream);
            if (navigator.getName() == Element.PAGE_SET) {
                ArrayList<Page> pages = new ArrayList<Page>();
                Element next = (Element)((Object)navigator.child());
                if (next == Element.PAGE) {
                    for (StaxNavigator fork : navigator.fork((Object)Element.PAGE)) {
                        pages.add(this.unmarshalPage((StaxNavigator<Element>)fork));
                    }
                } else if (next != null) {
                    throw Exceptions.unexpectedElement((StaxNavigator)navigator);
                }
                if (navigator.sibling() != null) {
                    throw Exceptions.unexpectedElement((StaxNavigator)navigator);
                }
                Page.PageSet pageSet = new Page.PageSet();
                pageSet.setPages(pages);
                return pageSet;
            }
            throw Exceptions.unknownElement((StaxNavigator)navigator);
        }
        catch (StaxNavException e) {
            throw new BindingException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new BindingException((Throwable)e);
        }
    }

    private void marshalPage(StaxWriter<Element> writer, Page page) throws XMLStreamException {
        writer.writeStartElement((Object)Element.PAGE);
        writer.writeElement((Object)Element.NAME, page.getName());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.TITLE), (String)page.getTitle());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.DESCRIPTION), (String)page.getDescription());
        this.marshalAccessPermissions(writer, page.getAccessPermissions());
        this.marshalEditPermission(writer, page.getEditPermission());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.SHOW_MAX_WINDOW), (WritableValueType)WritableValueTypes.BOOLEAN, (Object)page.isShowMaxWindow());
        this.marshalPermissions(writer, Element.MOVE_APPLICATIONS_PERMISSIONS, page.getMoveAppsPermissions());
        this.marshalPermissions(writer, Element.MOVE_CONTAINERS_PERMISSIONS, page.getMoveContainersPermissions());
        ArrayList<ModelObject> children = page.getChildren();
        for (ModelObject child : children) {
            this.marshalModelObject(writer, child);
        }
        writer.writeEndElement();
    }

    private Page unmarshalPage(StaxNavigator<Element> navigator) throws XMLStreamException {
        StaxNavUtils.requiresChild(navigator, (Object)((Object)Element.NAME));
        String name = StaxNavUtils.getRequiredContent(navigator, (boolean)true);
        Page page = new Page();
        page.setName(name);
        Element current = (Element)((Object)navigator.sibling());
        block12: while (current != null) {
            switch (current) {
                case TITLE: {
                    page.setTitle(StaxNavUtils.getContent(navigator, (boolean)false));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case DESCRIPTION: {
                    page.setDescription(StaxNavUtils.getContent(navigator, (boolean)false));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case ACCESS_PERMISSIONS: {
                    page.setAccessPermissions(this.unmarshalAccessPermissions(navigator, true));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case EDIT_PERMISSION: {
                    page.setEditPermission(this.unmarshalEditPermission(navigator));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case SHOW_MAX_WINDOW: {
                    page.setShowMaxWindow((Boolean)StaxNavUtils.parseRequiredContent(navigator, (ValueType)ValueType.BOOLEAN));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case MOVE_APPLICATIONS_PERMISSIONS: {
                    page.setMoveAppsPermissions(this.unmarshalPermissions(navigator, false));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case MOVE_CONTAINERS_PERMISSIONS: {
                    page.setMoveContainersPermissions(this.unmarshalPermissions(navigator, false));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case CONTAINER: {
                    if (page.getChildren() == null) {
                        page.setChildren(new ArrayList<ModelObject>());
                    }
                    page.getChildren().add(this.unmarshalContainer((StaxNavigator<Element>)navigator.fork()));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case PORTLET_APPLICATION: {
                    if (page.getChildren() == null) {
                        page.setChildren(new ArrayList<ModelObject>());
                    }
                    page.getChildren().add(this.unmarshalPortletApplication((StaxNavigator<Element>)navigator.fork()));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case UNKNOWN: {
                    throw Exceptions.unknownElement(navigator);
                }
            }
            throw Exceptions.unexpectedElement(navigator);
        }
        return page;
    }
}

