/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.exportimport;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.management.exportimport.AbstractImportTask;
import org.exoplatform.portal.mop.management.operations.MOPSiteProvider;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.gatein.mop.api.workspace.Site;

public class PageImportTask
extends AbstractImportTask<Page.PageSet> {
    private final DataStorage dataStorage;
    private final PageService pageService;
    private final MOPSiteProvider siteProvider;
    private Page.PageSet rollbackSaves;
    private Page.PageSet rollbackDeletes;

    public PageImportTask(Page.PageSet data, SiteKey siteKey, DataStorage dataStorage, PageService pageService, MOPSiteProvider siteProvider) {
        super(data, siteKey);
        this.dataStorage = dataStorage;
        this.pageService = pageService;
        this.siteProvider = siteProvider;
    }

    @Override
    public void importData(ImportMode importMode) throws Exception {
        if (this.data == null || ((Page.PageSet)this.data).getPages() == null || ((Page.PageSet)this.data).getPages().isEmpty()) {
            return;
        }
        Site site = this.siteProvider.getSite(this.siteKey);
        if (site == null) {
            throw new Exception("Cannot import pages because site does not exist for " + this.siteKey);
        }
        org.gatein.mop.api.workspace.Page pages = site.getRootPage().getChild("pages");
        int size = pages == null ? 0 : pages.getChildren().size();
        Page.PageSet dst = null;
        switch (importMode) {
            case CONSERVE: {
                if (size == 0) {
                    dst = (Page.PageSet)this.data;
                    this.rollbackDeletes = (Page.PageSet)this.data;
                    break;
                }
                dst = null;
                break;
            }
            case INSERT: {
                if (size == 0) {
                    dst = (Page.PageSet)this.data;
                    this.rollbackDeletes = (Page.PageSet)this.data;
                    break;
                }
                dst = new Page.PageSet();
                this.rollbackDeletes = new Page.PageSet();
                for (Page page : ((Page.PageSet)this.data).getPages()) {
                    if (pages.getChild(page.getName()) != null) continue;
                    dst.getPages().add(page);
                    this.rollbackDeletes.getPages().add(page);
                }
                break;
            }
            case MERGE: {
                if (size == 0) {
                    dst = (Page.PageSet)this.data;
                    this.rollbackDeletes = (Page.PageSet)this.data;
                    break;
                }
                dst = new Page.PageSet();
                this.rollbackSaves = new Page.PageSet();
                this.rollbackDeletes = new Page.PageSet();
                for (Page page : ((Page.PageSet)this.data).getPages()) {
                    dst.getPages().add(page);
                    PageKey pageKey = this.siteKey.page(page.getName());
                    if (pages.getChild(page.getName()) == null) {
                        this.rollbackDeletes.getPages().add(page);
                        continue;
                    }
                    PageContext pageContext = this.pageService.loadPage(pageKey);
                    Page existing = this.dataStorage.getPage(pageKey.format());
                    pageContext.update(existing);
                    this.rollbackSaves.getPages().add(PageUtils.copy(existing));
                }
                break;
            }
            case OVERWRITE: {
                if (size == 0) {
                    dst = (Page.PageSet)this.data;
                    this.rollbackDeletes = (Page.PageSet)this.data;
                    break;
                }
                ArrayList<Page> list = PageUtils.getAllPages(this.dataStorage, this.pageService, this.siteKey).getPages();
                this.rollbackSaves = new Page.PageSet();
                this.rollbackSaves.setPages(new ArrayList<Page>(list.size()));
                this.rollbackDeletes = new Page.PageSet();
                for (Page page : list) {
                    Page copy = PageUtils.copy(page);
                    this.pageService.destroyPage(this.siteKey.page(page.getName()));
                    this.dataStorage.save();
                    this.rollbackSaves.getPages().add(copy);
                }
                for (Page src : ((Page.PageSet)this.data).getPages()) {
                    Page found = PageImportTask.findPage(list, src);
                    if (found != null) continue;
                    this.rollbackDeletes.getPages().add(src);
                }
                dst = (Page.PageSet)this.data;
            }
        }
        if (dst != null) {
            for (Page page : dst.getPages()) {
                this.pageService.savePage(new PageContext(this.siteKey.page(page.getName()), PageUtils.toPageState(page)));
                this.dataStorage.save(page);
                this.dataStorage.save();
            }
        }
    }

    @Override
    public void rollback() throws Exception {
        if (this.rollbackDeletes != null && !this.rollbackDeletes.getPages().isEmpty()) {
            for (Page page : this.rollbackDeletes.getPages()) {
                this.pageService.destroyPage(this.siteKey.page(page.getName()));
                this.dataStorage.save();
            }
        }
        if (this.rollbackSaves != null && !this.rollbackSaves.getPages().isEmpty()) {
            for (Page page : this.rollbackSaves.getPages()) {
                this.pageService.savePage(new PageContext(this.siteKey.page(page.getName()), PageUtils.toPageState(page)));
                this.dataStorage.save(page);
                this.dataStorage.save();
            }
        }
    }

    Page.PageSet getRollbackSaves() {
        return this.rollbackSaves;
    }

    Page.PageSet getRollbackDeletes() {
        return this.rollbackDeletes;
    }

    private static Page findPage(List<Page> pages, Page src) {
        Page found = null;
        for (Page page : pages) {
            if (!src.getName().equals(page.getName())) continue;
            found = page;
        }
        return found;
    }
}

