/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.exportimport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.management.exportimport.AbstractExportTask;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.operation.model.ExportTask;

public class SiteLayoutExportTask
extends AbstractExportTask
implements ExportTask {
    public static final Set<String> FILES;
    private final DataStorage dataStorage;
    private final Marshaller<PortalConfig> marshaller;

    public SiteLayoutExportTask(SiteKey siteKey, DataStorage dataStorage, Marshaller<PortalConfig> marshaller) {
        super(siteKey);
        this.dataStorage = dataStorage;
        this.marshaller = marshaller;
    }

    @Override
    protected String getXmlFileName() {
        if (this.siteKey.getType() == SiteType.PORTAL) {
            return "portal.xml";
        }
        if (this.siteKey.getType() == SiteType.GROUP) {
            return "group.xml";
        }
        if (this.siteKey.getType() == SiteType.USER) {
            return "user.xml";
        }
        throw new RuntimeException("Unknown site type " + (Object)((Object)this.siteKey.getType()));
    }

    public void export(OutputStream outputStream) throws IOException {
        PortalConfig portalConfig;
        try {
            portalConfig = this.dataStorage.getPortalConfig(this.siteKey.getTypeName(), this.siteKey.getName());
        }
        catch (Exception e) {
            throw new IOException("Could not retrieve site " + this.siteKey, e);
        }
        this.marshaller.marshal((Object)portalConfig, outputStream, true);
    }

    static {
        HashSet<String> tmp = new HashSet<String>(3);
        tmp.add("portal.xml");
        tmp.add("group.xml");
        tmp.add("user.xml");
        FILES = tmp;
    }
}

