/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.task;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.services.security.ConversationState;

public abstract class AbstractForumTask {
    private final ConversationState state = ConversationState.getCurrent();

    public ConversationState getState() {
        return this.state;
    }

    protected static JCRDataStorage getJCRDataStorage() {
        return (JCRDataStorage)CommonsUtils.getService(JCRDataStorage.class);
    }

    public abstract void process() throws Exception;

    public static class SendNotificationTask
    extends AbstractForumTask {
        private final Topic topic;
        private final Post post;
        private final String nodePath;
        private final boolean isApprovePost;
        private final MessageBuilder messageBuilder;

        public SendNotificationTask(String nodePath, Topic topic, Post post, MessageBuilder messageBuilder, boolean isApprovePost) {
            this.topic = topic;
            this.post = post;
            this.nodePath = nodePath;
            this.messageBuilder = messageBuilder;
            this.isApprovePost = isApprovePost;
        }

        @Override
        public void process() throws Exception {
            SendNotificationTask.getJCRDataStorage().sendNotification(this.nodePath, this.topic, this.post, this.messageBuilder, this.isApprovePost);
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            if (o instanceof SendNotificationTask) {
                SendNotificationTask that = (SendNotificationTask)o;
                if (this.isApprovePost != that.isApprovePost) {
                    return false;
                }
                if (this.nodePath != null ? !this.nodePath.equals(that.nodePath) : that.nodePath != null) {
                    return false;
                }
                if (this.post != null ? !this.post.getId().equals(that.post == null ? "" : that.post.getId()) : that.post != null) {
                    return false;
                }
                return !(this.topic != null ? !this.topic.getId().equals(that.topic == null ? "" : that.topic.getId()) : that.topic != null);
            }
            return false;
        }

        public int hashCode() {
            int result = this.topic != null ? this.topic.hashCode() : 0;
            result = 31 * result + (this.post != null ? this.post.hashCode() : 0);
            result = 31 * result + (this.nodePath != null ? this.nodePath.hashCode() : 0);
            result = 31 * result + (this.isApprovePost ? 1 : 0);
            return result;
        }
    }

    public static class QueryLastPostTask
    extends AbstractForumTask {
        private final String forumPath;

        public QueryLastPostTask(String forumPath) {
            this.forumPath = forumPath;
        }

        @Override
        public void process() throws Exception {
            QueryLastPostTask.getJCRDataStorage().queryLastPostForum(this.forumPath);
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            if (o instanceof QueryLastPostTask) {
                QueryLastPostTask that = (QueryLastPostTask)o;
                return !(this.forumPath != null ? !this.forumPath.equals(that.forumPath) : that.forumPath != null);
            }
            return false;
        }

        public int hashCode() {
            return this.forumPath != null ? this.forumPath.hashCode() : 0;
        }
    }
}

