/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NumberExpression
extends Expression
implements Cloneable {
    private String originalString;
    private Dimension dimension = Dimension.NUMBER;
    private Double valueAsDouble;
    private String suffix = "";
    private boolean expliciteSign = false;

    public NumberExpression(HiddenTokenAwareTree token) {
        super(token);
    }

    public NumberExpression(HiddenTokenAwareTree token, String originalString) {
        super(token);
        this.originalString = originalString;
    }

    public NumberExpression(HiddenTokenAwareTree token, String originalString, Dimension dimension) {
        this(token, originalString);
        this.dimension = dimension;
    }

    public NumberExpression(HiddenTokenAwareTree token, String lowerCaseValue, Dimension repeater, boolean expliciteSign) {
        this(token, lowerCaseValue, repeater);
        this.expliciteSign = expliciteSign;
    }

    public NumberExpression(HiddenTokenAwareTree token, Double valueAsDouble, String suffix, String originalString, Dimension dimension) {
        this(token, originalString, dimension);
        this.valueAsDouble = valueAsDouble;
        this.suffix = suffix;
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public void setOriginalString(String originalString) {
        this.originalString = originalString;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Double getValueAsDouble() {
        return this.valueAsDouble;
    }

    public void setValueAsDouble(Double number) {
        this.valueAsDouble = number;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean hasExpliciteSign() {
        return this.expliciteSign;
    }

    public void setExpliciteSign(boolean expliciteSign) {
        this.expliciteSign = expliciteSign;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void negate() {
        if (this.valueAsDouble == null) {
            return;
        }
        this.valueAsDouble = this.valueAsDouble * -1.0;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return Collections.emptyList();
    }

    public boolean hasOriginalString() {
        return this.getOriginalString() != null;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.NUMBER;
    }

    public NumberExpression convertTo(String targetUnit) {
        HashMap<Dimension, String> conversions = new HashMap<Dimension, String>();
        for (Dimension dim : Dimension.values()) {
            if (!dim.getConversions().containsKey(targetUnit)) continue;
            conversions.put(dim, targetUnit);
        }
        return this.convertTo(conversions);
    }

    public NumberExpression convertTo(Map<Dimension, String> conversions) {
        double value = this.getValueAsDouble();
        String unit = this.getSuffix();
        Dimension dimension = this.getDimension();
        String targetUnit = conversions.get((Object)dimension);
        if (targetUnit == null) {
            return this;
        }
        Map<String, Number> group = dimension.getConversions();
        Number multiplier = group.get(unit);
        Number divisor = group.get(targetUnit);
        if (multiplier != null && divisor != null) {
            return new NumberExpression(this.getUnderlyingStructure(), value * multiplier.doubleValue() / divisor.doubleValue(), targetUnit, null, this.getDimension());
        }
        throw new IllegalArgumentException("Conversion between " + unit + " and " + targetUnit + " is not supported.");
    }

    public String toString() {
        if (this.originalString != null) {
            return this.originalString;
        }
        return "" + this.valueAsDouble + this.suffix;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimension == null ? 0 : this.dimension.hashCode());
        result = 31 * result + (this.expliciteSign ? 1231 : 1237);
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        result = 31 * result + (this.valueAsDouble == null ? 0 : this.valueAsDouble.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberExpression other = (NumberExpression)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.expliciteSign != other.expliciteSign) {
            return false;
        }
        if (this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix)) {
            return false;
        }
        return !(this.valueAsDouble == null ? other.valueAsDouble != null : !this.valueAsDouble.equals(other.valueAsDouble));
    }

    @Override
    public NumberExpression clone() {
        NumberExpression clone = (NumberExpression)super.clone();
        return clone;
    }

    public static enum Dimension {
        NUMBER,
        PERCENTAGE,
        LENGTH,
        EMS,
        EXS,
        ANGLE,
        TIME,
        FREQ,
        REPEATER,
        UNKNOWN;

        private Map<String, Number> conversions;

        public static Dimension forSuffix(String suffix) {
            if (suffix.equals("%")) {
                return PERCENTAGE;
            }
            if (suffix.equals("px") || suffix.equals("cm") || suffix.equals("mm") || suffix.equals("in") || suffix.equals("pt") || suffix.equals("pc")) {
                return LENGTH;
            }
            if (suffix.equals("em")) {
                return EMS;
            }
            if (suffix.equals("ex")) {
                return EXS;
            }
            if (suffix.equals("deg") || suffix.equals("rad") || suffix.equals("grad")) {
                return ANGLE;
            }
            if (suffix.equals("ms") || suffix.equals("s")) {
                return TIME;
            }
            if (suffix.equals("khz") || suffix.equals("hz")) {
                return FREQ;
            }
            return UNKNOWN;
        }

        public Map<String, Number> getConversions() {
            if (this.conversions != null) {
                return this.conversions;
            }
            HashMap<String, Number> result = new HashMap<String, Number>();
            switch (this) {
                case LENGTH: {
                    result.put("m", 1);
                    result.put("cm", 0.01);
                    result.put("mm", 0.001);
                    result.put("in", 0.0254);
                    result.put("pt", 3.5277777777777776E-4);
                    result.put("pc", 0.004233333333333333);
                    break;
                }
                case TIME: {
                    result.put("s", 1);
                    result.put("ms", 0.001);
                    break;
                }
                case ANGLE: {
                    result.put("rad", 0.15915494309189535);
                    result.put("deg", 0.002777777777777778);
                    result.put("grad", 0.0025);
                    result.put("turn", 1);
                    break;
                }
            }
            this.conversions = result;
            return result;
        }
    }
}

