/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiBottomArea;
import org.exoplatform.wiki.webui.UIWikiPageVersionsList;
import org.exoplatform.wiki.webui.UIWikiPermalinkForm;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.UIAttachmentContainer;
import org.exoplatform.wiki.webui.core.UIWikiContainer;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/UIWikiPageInfoArea.gtmpl", events={@EventConfig(listeners={PermalinkActionListener.class}), @EventConfig(listeners={CompareRevisionActionListener.class}), @EventConfig(listeners={ShowRevisionActionListener.class}), @EventConfig(listeners={ToggleAttachmentsActionListener.class})})
public class UIWikiPageInfoArea
extends UIWikiContainer {
    private static final Log log = ExoLogger.getLogger((String)"wiki:UIWikiPageInfoArea");
    public static String TOGGLE_ATTACHMENTS_ACTION = "ToggleAttachments";
    public static String SHOW_REVISION = "ShowRevision";
    public static String COMPARE_REVISION = "CompareRevision";
    public static final String PERMALINK_ACTION = "Permalink";
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public UIWikiPageInfoArea() {
        this.accept_Modes = Arrays.asList(WikiMode.VIEW);
    }

    protected Page getCurrentWikiPage() {
        Page currentPage = null;
        try {
            currentPage = Utils.getCurrentWikiPage();
        }
        catch (Exception e) {
            log.warn((Object)"An error happened when getting current wiki page", (Throwable)e);
        }
        return currentPage;
    }

    protected int getNumberOfAttachments(Page page) {
        int nbOfAttachments = 0;
        try {
            nbOfAttachments = this.wikiService.getNbOfAttachmentsOfPage(page);
        }
        catch (WikiException e) {
            log.error((Object)("Cannot get number of attachments of " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
        }
        return nbOfAttachments;
    }

    protected int getNumberOfVersions(Page page) {
        int nbOfversions = 0;
        try {
            List versions = this.wikiService.getVersionsOfPage(page);
            if (versions != null && !versions.isEmpty()) {
                nbOfversions = versions.size();
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot get versions of page " + page.getWikiType() + ":" + page.getWikiOwner() + ":" + page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
        }
        return nbOfversions;
    }

    protected boolean isPagePublic(Page page) throws Exception {
        return Utils.isPagePublic(page);
    }

    public static class CompareRevisionActionListener
    extends org.exoplatform.wiki.webui.control.action.CompareRevisionActionListener {
        @Override
        public void execute(Event<UIComponent> event) throws Exception {
            WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
            List lstVersion = wikiService.getVersionsOfPage(Utils.getCurrentWikiPage());
            this.setVersionToCompare(lstVersion);
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            String verName = pageParams.getParameter("verName");
            if (!StringUtils.isEmpty((String)verName)) {
                for (int i = 0; i < lstVersion.size(); ++i) {
                    PageVersion ver = (PageVersion)lstVersion.get(i);
                    if (!ver.getName().equals(verName) || i >= lstVersion.size() + 1) continue;
                    this.setFrom(i);
                    this.setTo(i + 1);
                    break;
                }
            }
            super.execute(event);
        }
    }

    public static class ShowRevisionActionListener
    extends EventListener<UIWikiPageInfoArea> {
        public void execute(Event<UIWikiPageInfoArea> event) throws Exception {
            UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)((UIWikiPageInfoArea)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiBottomArea bottomArea = (UIWikiBottomArea)uiWikiPortlet.findFirstComponentOfType(UIWikiBottomArea.class);
            UIWikiPageVersionsList pageVersions = (UIWikiPageVersionsList)bottomArea.getChild(UIWikiPageVersionsList.class);
            if (pageVersions.isRendered()) {
                pageVersions.setRendered(false);
            } else {
                UIAttachmentContainer attachform = (UIAttachmentContainer)bottomArea.getChild(UIAttachmentContainer.class);
                if (attachform.isRendered()) {
                    attachform.setRendered(false);
                }
                pageVersions.setRendered(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(bottomArea.getParent());
        }
    }

    public static class ToggleAttachmentsActionListener
    extends EventListener<UIWikiPageInfoArea> {
        public void execute(Event<UIWikiPageInfoArea> event) throws Exception {
            UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)((UIWikiPageInfoArea)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiBottomArea bottomArea = (UIWikiBottomArea)uiWikiPortlet.findFirstComponentOfType(UIWikiBottomArea.class);
            UIAttachmentContainer attachform = (UIAttachmentContainer)bottomArea.findFirstComponentOfType(UIAttachmentContainer.class);
            if (attachform.isRendered()) {
                attachform.setRendered(false);
            } else {
                attachform.setRendered(true);
                UIWikiPageVersionsList pageVersions = (UIWikiPageVersionsList)bottomArea.findFirstComponentOfType(UIWikiPageVersionsList.class);
                if (pageVersions.isRendered()) {
                    pageVersions.setRendered(false);
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(bottomArea.getParent());
        }
    }

    public static class PermalinkActionListener
    extends EventListener<UIWikiPageInfoArea> {
        public void execute(Event<UIWikiPageInfoArea> event) throws Exception {
            UIWikiPortlet uiWikiPortlet = (UIWikiPortlet)((UIWikiPageInfoArea)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer uiPopupContainer = uiWikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            uiPopupContainer.activate(UIWikiPermalinkForm.class, 800);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }
}

