/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.util.Vector;

class Grid
extends Panel {
    private Dimension dMinimum;
    protected Font fFont;
    private FontMetrics fMetrics;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iRowHeight;
    private int iFirstRow;
    private int iGridWidth;
    private int iGridHeight;
    private int iX;
    private int iY;
    protected String[] sColHead = new String[0];
    protected Vector vData = new Vector();
    private int[] iColWidth;
    private int iColCount;
    protected int iRowCount;
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;
    private boolean bDrag;
    private int iXDrag;
    private int iColDrag;

    public Grid() {
        this.fFont = new Font("Dialog", 0, 12);
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
    }

    String[] getHead() {
        return this.sColHead;
    }

    Vector getData() {
        return this.vData;
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        this.dMinimum = dimension;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = n4 - this.iSbHeight;
        this.iWidth = n3 - this.iSbWidth;
        this.sbHoriz.setBounds(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.setBounds(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.repaint();
    }

    public void setHead(String[] stringArray) {
        this.iColCount = stringArray.length;
        this.sColHead = new String[this.iColCount];
        this.iColWidth = new int[this.iColCount];
        for (int i = 0; i < this.iColCount; ++i) {
            this.sColHead[i] = stringArray[i];
            this.iColWidth[i] = 100;
        }
        this.iRowCount = 0;
        this.iRowHeight = 0;
        this.vData = new Vector();
    }

    public void addRow(String[] stringArray) {
        if (stringArray.length != this.iColCount) {
            return;
        }
        String[] stringArray2 = new String[this.iColCount];
        for (int i = 0; i < this.iColCount; ++i) {
            stringArray2[i] = stringArray[i];
            if (stringArray2[i] != null) continue;
            stringArray2[i] = "(null)";
        }
        this.vData.addElement(stringArray2);
        ++this.iRowCount;
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    void adjustScroll() {
        int n;
        if (this.iRowHeight == 0) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.iColCount; ++n) {
            n2 += this.iColWidth[n];
        }
        this.iGridWidth = n2;
        this.iGridHeight = this.iRowHeight * (this.iRowCount + 1);
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iGridWidth);
        n = this.iY / this.iRowHeight;
        int n3 = this.iHeight / this.iRowHeight;
        this.sbVert.setValues(n, n3, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
    }

    @Override
    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = this.iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (graphics == null) {
            return;
        }
        if (this.sColHead.length == 0) {
            super.paint(graphics);
            return;
        }
        if (this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        graphics.setColor(SystemColor.control);
        graphics.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.gImage.setFont(this.fFont);
            if (this.fMetrics == null) {
                this.fMetrics = this.gImage.getFontMetrics();
            }
        }
        if (this.iRowHeight == 0) {
            this.iRowHeight = Grid.getMaxHeight(this.fMetrics);
            for (n3 = 0; n3 < this.iColCount; ++n3) {
                this.calcAutoWidth(n3);
            }
            this.adjustScroll();
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, this.iRowHeight, this.iWidth, this.iRowHeight);
        n3 = -this.iX;
        for (n2 = 0; n2 < this.iColCount; ++n2) {
            n = this.iColWidth[n2];
            this.gImage.setColor(SystemColor.control);
            this.gImage.fillRect(n3 + 1, 0, n - 2, this.iRowHeight);
            this.gImage.setColor(Color.black);
            this.gImage.drawString(this.sColHead[n2], n3 + 2, this.iRowHeight - 5);
            this.gImage.setColor(Color.darkGray);
            this.gImage.drawLine(n3 + n - 1, 0, n3 + n - 1, this.iRowHeight - 1);
            this.gImage.setColor(Color.white);
            this.gImage.drawLine(n3 + n, 0, n3 + n, this.iRowHeight - 1);
            n3 += n;
        }
        this.gImage.setColor(SystemColor.control);
        this.gImage.fillRect(0, 0, 1, this.iRowHeight);
        this.gImage.fillRect(n3 + 1, 0, this.iWidth - n3, this.iRowHeight);
        this.gImage.drawLine(0, 0, 0, this.iRowHeight - 1);
        n = 0;
        for (n2 = this.iRowHeight + 1 - this.iY; n2 < this.iRowHeight + 1; n2 += this.iRowHeight) {
            ++n;
        }
        this.iFirstRow = n;
        for (n2 = this.iRowHeight + 1; n2 < this.iHeight && n < this.iRowCount; ++n, n2 += this.iRowHeight) {
            n3 = -this.iX;
            for (int i = 0; i < this.iColCount; ++i) {
                int n4 = this.iColWidth[i];
                Color color = Color.white;
                Color color2 = Color.black;
                this.gImage.setColor(color);
                this.gImage.fillRect(n3, n2, n4 - 1, this.iRowHeight - 1);
                this.gImage.setColor(color2);
                this.gImage.drawString(this.getDisplay(i, n), n3 + 2, n2 + this.iRowHeight - 5);
                this.gImage.setColor(Color.lightGray);
                this.gImage.drawLine(n3 + n4 - 1, n2, n3 + n4 - 1, n2 + this.iRowHeight - 1);
                this.gImage.drawLine(n3, n2 + this.iRowHeight - 1, n3 + n4 - 1, n2 + this.iRowHeight - 1);
                n3 += n4;
            }
            this.gImage.setColor(Color.white);
            this.gImage.fillRect(n3, n2, this.iWidth - n3, this.iRowHeight - 1);
        }
        graphics.drawImage(this.iImage, 0, 0, this);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public boolean mouseMove(Event event, int n, int n2) {
        if (n2 <= this.iRowHeight) {
            int n3;
            int n4 = n;
            n += this.iX - this.iGridWidth;
            for (n3 = this.iColCount - 1; n3 >= 0 && (n <= -7 || n >= 7); n += this.iColWidth[n3], --n3) {
            }
            if (n3 >= 0) {
                if (!this.bDrag) {
                    this.setCursor(new Cursor(11));
                    this.bDrag = true;
                    this.iXDrag = n4 - this.iColWidth[n3];
                    this.iColDrag = n3;
                }
                return true;
            }
        }
        return this.mouseExit(event, n, n2);
    }

    @Override
    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.bDrag && n < this.iWidth) {
            int n3 = n - this.iXDrag;
            if (n3 < 0) {
                n3 = 0;
            }
            this.iColWidth[this.iColDrag] = n3;
            this.adjustScroll();
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean mouseExit(Event event, int n, int n2) {
        if (this.bDrag) {
            this.setCursor(new Cursor(0));
            this.bDrag = false;
        }
        return true;
    }

    @Override
    public Dimension preferredSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension minimumSize() {
        return this.dMinimum;
    }

    private void calcAutoWidth(int n) {
        int n2 = 10;
        n2 = Math.max(n2, this.fMetrics.stringWidth(this.sColHead[n]));
        for (int i = 0; i < this.iRowCount; ++i) {
            String[] stringArray = (String[])this.vData.elementAt(i);
            n2 = Math.max(n2, this.fMetrics.stringWidth(stringArray[n]));
        }
        this.iColWidth[n] = n2 + 6;
    }

    private String getDisplay(int n, int n2) {
        return ((String[])this.vData.elementAt(n2))[n];
    }

    private String get(int n, int n2) {
        return ((String[])this.vData.elementAt(n2))[n];
    }

    private static int getMaxHeight(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() + 4;
    }
}

