/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.AbstractActivitiesDisplay;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.activity.UIActivitiesLoader;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/social/webui/space/UISpaceActivitiesDisplay.gtmpl", events={@EventConfig(listeners={RefreshStreamActionListener.class})})
public class UISpaceActivitiesDisplay
extends AbstractActivitiesDisplay {
    private static final Log LOG = ExoLogger.getLogger(UISpaceActivitiesDisplay.class);
    private static final String ACTIVITIES_PER_PAGE_KEY = "social.activities.per.page";
    private static int ACTIVITY_PER_PAGE = 10;
    private Space space;
    private UIActivitiesLoader activitiesLoader;

    public UISpaceActivitiesDisplay() throws Exception {
        ACTIVITY_PER_PAGE = Integer.valueOf(PrivilegedSystemHelper.getProperty((String)ACTIVITIES_PER_PAGE_KEY, (String)"10").trim());
    }

    public void setSpace(Space space) throws Exception {
        this.space = space;
        this.init();
    }

    public Space getSpace() {
        return this.space;
    }

    public UIActivitiesLoader getActivitiesLoader() {
        return this.activitiesLoader;
    }

    public boolean isSingleContext() {
        return this.getActivitiesLoader().getPostContext() == UIComposer.PostContext.SINGLE;
    }

    @Override
    public void init() throws Exception {
        if (this.space == null) {
            LOG.warn((Object)"space is null! Can not display spaceActivites");
            return;
        }
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", this.space.getPrettyName(), false);
        this.removeChild(UIActivitiesLoader.class);
        this.activitiesLoader = (UIActivitiesLoader)this.addChild(UIActivitiesLoader.class, null, "UIActivitiesLoader");
        this.activitiesLoader.setSpace(this.space);
        this.activitiesLoader.setPostContext(UIComposer.PostContext.SPACE);
        this.activitiesLoader.setLoadingCapacity(ACTIVITY_PER_PAGE);
        this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)Utils.getActivityManager().getActivitiesOfSpaceWithListAccess(spaceIdentity));
        this.activitiesLoader.init();
        ((UIActivitiesContainer)this.activitiesLoader.getChild(UIActivitiesContainer.class)).setRenderFull(this.isRenderFull(), true);
    }

    public static class RefreshStreamActionListener
    extends EventListener<UISpaceActivitiesDisplay> {
        public void execute(Event<UISpaceActivitiesDisplay> event) throws Exception {
            UISpaceActivitiesDisplay uiSpaceActivities = (UISpaceActivitiesDisplay)((Object)event.getSource());
            uiSpaceActivities.init();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceActivities);
        }
    }
}

