/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;
import org.picocontainer.Startable;

public class DefaultLocalePolicyService
implements LocalePolicy,
Startable {
    public Locale determineLocale(LocaleContextInfo context) {
        if (context.getRequestLocale() != null) {
            return context.getRequestLocale();
        }
        Locale locale = null;
        locale = context.getRemoteUser() == null ? this.getLocaleConfigForAnonymous(context) : this.getLocaleConfigForRegistered(context);
        if (locale == null) {
            locale = context.getPortalLocale();
        }
        return locale;
    }

    protected Locale getLocaleConfigForRegistered(LocaleContextInfo context) {
        Locale locale = context.getLocaleIfLangSupported(context.getUserProfileLocale());
        if (locale == null) {
            locale = this.getLocaleConfigFromCookie(context);
        }
        if (locale == null) {
            locale = this.getLocaleConfigFromSession(context);
        }
        if (locale == null) {
            locale = this.getLocaleConfigFromBrowser(context);
        }
        return locale;
    }

    protected Locale getLocaleConfigFromBrowser(LocaleContextInfo context) {
        Iterator iterator;
        List locales = context.getBrowserLocales();
        if (locales != null && (iterator = locales.iterator()).hasNext()) {
            Locale loc = (Locale)iterator.next();
            return context.getLocaleIfLangSupported(loc);
        }
        return null;
    }

    protected Locale getLocaleConfigForAnonymous(LocaleContextInfo context) {
        Locale locale = this.getLocaleConfigFromCookie(context);
        if (locale == null) {
            locale = this.getLocaleConfigFromSession(context);
        }
        if (locale == null) {
            locale = this.getLocaleConfigFromBrowser(context);
        }
        return locale;
    }

    protected Locale getLocaleConfigFromSession(LocaleContextInfo context) {
        return context.getSessionLocale();
    }

    protected Locale getLocaleConfigFromCookie(LocaleContextInfo context) {
        Iterator iterator;
        List locales = context.getCookieLocales();
        if (locales != null && (iterator = locales.iterator()).hasNext()) {
            Locale locale = (Locale)iterator.next();
            return context.getLocaleIfLangSupported(locale);
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }
}

