/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;

public class QPathEntry
extends InternalQName
implements Comparable<QPathEntry> {
    private final int index;
    private String cachedToString;
    private String cachedToStringShowIndex;
    private String id;

    public QPathEntry(InternalQName qName, int index) {
        this(qName, index, null);
    }

    public QPathEntry(InternalQName qName, int index, String id) {
        super(qName.getNamespace(), qName.getName());
        this.index = index > 0 ? index : 1;
        this.id = id;
    }

    public QPathEntry(String namespace, String name, int index) {
        this(namespace, name, index, null);
    }

    public QPathEntry(String namespace, String name, int index, String id) {
        super(namespace, name);
        this.index = index > 0 ? index : 1;
        this.id = id;
    }

    public static QPathEntry parse(String qEntry) throws IllegalNameException, NumberFormatException {
        int delimIndex = qEntry.lastIndexOf(":");
        String qnameString = qEntry.substring(0, delimIndex);
        String indexString = qEntry.substring(delimIndex + 1);
        InternalQName qname = InternalQName.parse(qnameString);
        return new QPathEntry(qname, Integer.valueOf(indexString));
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSame(QPathEntry obj) {
        if (super.equals(obj)) {
            return this.index == obj.getIndex();
        }
        return false;
    }

    public String getAsString() {
        return this.getAsString(false);
    }

    public String getAsString(boolean showIndex) {
        if (showIndex) {
            if (this.cachedToStringShowIndex != null) {
                return this.cachedToStringShowIndex;
            }
        } else if (this.cachedToString != null) {
            return this.cachedToString;
        }
        String res = showIndex ? super.getAsString() + ":" + this.getIndex() : super.getAsString();
        if (showIndex) {
            this.cachedToStringShowIndex = res;
        } else {
            this.cachedToString = res;
        }
        return res;
    }

    @Override
    public int compareTo(QPathEntry compare) {
        int result = 0;
        if (this.isSame(compare)) {
            return result;
        }
        result = this.namespace.compareTo(compare.namespace);
        if (result == 0 && (result = this.name.compareTo(compare.name)) == 0) {
            result = this.index - compare.index;
        }
        return result;
    }

    protected String asString() {
        return this.getAsString(true);
    }

    @Override
    public boolean equals(Object o) {
        boolean result = super.equals(o);
        if (result && o instanceof QPathEntry) {
            return result && this.getIndex() == ((QPathEntry)o).getIndex();
        }
        return result;
    }
}

