/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms.scripts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.DBCleaningScripts;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;

public class SybaseCleaningScipts
extends DBCleaningScripts {
    public SybaseCleaningScipts(String dialect, RepositoryEntry rEntry) throws DBCleanException {
        super(dialect, rEntry);
        this.prepareRenamingApproachScripts();
    }

    public SybaseCleaningScipts(String dialect, WorkspaceEntry wEntry) throws DBCleanException {
        super(dialect, wEntry);
        if (this.multiDb) {
            this.prepareRenamingApproachScripts();
        } else {
            this.prepareSimpleCleaningApproachScripts();
        }
    }

    @Override
    protected Collection<String> getConstraintsAddingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        String constraintName = "JCR_PK_" + this.itemTableSuffix + " PRIMARY KEY(ID)";
        scripts.add("ALTER TABLE " + this.itemTableName + " ADD CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.valueTableSuffix + " PRIMARY KEY(ID)";
        scripts.add("ALTER TABLE " + this.valueTableName + " ADD CONSTRAINT " + constraintName);
        constraintName = "JCR_FK_" + this.valueTableSuffix + "_PROPERTY FOREIGN KEY(PROPERTY_ID) REFERENCES " + this.itemTableName + "(ID)";
        scripts.add("ALTER TABLE " + this.valueTableName + " ADD CONSTRAINT " + constraintName);
        return scripts;
    }

    @Override
    protected Collection<String> getConstraintsRemovingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        String constraintName = "JCR_FK_" + this.valueTableSuffix + "_PROPERTY";
        scripts.add("ALTER TABLE  " + this.valueTableName + " DROP CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.itemTableSuffix;
        scripts.add("ALTER TABLE  " + this.itemTableName + " DROP CONSTRAINT " + constraintName);
        constraintName = "JCR_PK_" + this.valueTableSuffix;
        scripts.add("ALTER TABLE  " + this.valueTableName + " DROP CONSTRAINT " + constraintName);
        return scripts;
    }

    @Override
    protected Collection<String> getIndexesDroppingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("DROP INDEX " + this.itemTableName + ".JCR_IDX_" + this.itemTableSuffix + "_PARENT");
        scripts.add("DROP INDEX " + this.itemTableName + ".JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME");
        scripts.add("DROP INDEX " + this.itemTableName + ".JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID");
        scripts.add("DROP INDEX " + this.itemTableName + ".JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM");
        scripts.add("DROP INDEX " + this.itemTableName + ".JCR_IDX_" + this.itemTableSuffix + "_NAME");
        scripts.add("DROP INDEX " + this.valueTableName + ".JCR_IDX_" + this.valueTableSuffix + "_PROPERTY");
        scripts.add("DROP INDEX " + this.refTableName + ".JCR_IDX_" + this.refTableSuffix + "_PROPERTY");
        return scripts;
    }

    @Override
    protected Collection<String> getIndexesAddingScripts() throws DBCleanException {
        ArrayList<String> scripts = new ArrayList<String>();
        try {
            scripts.add(DBInitializerHelper.getObjectScript("INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_NAME ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("INDEX JCR_IDX_" + this.itemTableSuffix + "_PARENT_ID ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("INDEX JCR_IDX_" + this.itemTableSuffix + "_N_ORDER_NUM ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("INDEX JCR_IDX_" + this.itemTableSuffix + "_NAME ON " + this.itemTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("INDEX JCR_IDX_" + this.valueTableSuffix + "_PROPERTY ON " + this.valueTableName, this.multiDb, this.dialect, this.wsEntry));
            scripts.add(DBInitializerHelper.getObjectScript("JCR_IDX_" + this.refTableSuffix + "_PROPERTY ON " + this.refTableName, this.multiDb, this.dialect, this.wsEntry));
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanException(e);
        }
        catch (IOException e) {
            throw new DBCleanException(e);
        }
        return scripts;
    }

    @Override
    protected Collection<String> getTablesRenamingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("sp_rename " + this.valueTableName + ", " + this.valueTableName + "_OLD");
        scripts.add("sp_rename " + this.itemTableName + ", " + this.itemTableName + "_OLD");
        scripts.add("sp_rename " + this.refTableName + ", " + this.refTableName + "_OLD");
        scripts.add("sp_rename JCR_FK_" + this.valueTableSuffix + "_PROPERTY, JCR_FK_" + this.valueTableSuffix + "_PROPERTY_OLD");
        scripts.add("sp_rename JCR_FK_" + this.itemTableSuffix + "_PARENT, JCR_FK_" + this.itemTableSuffix + "_PARENT_OLD");
        return scripts;
    }

    @Override
    protected Collection<String> getOldTablesRenamingScripts() throws DBCleanException {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("sp_rename " + this.valueTableName + "_OLD, " + this.valueTableName);
        scripts.add("sp_rename " + this.itemTableName + "_OLD, " + this.itemTableName);
        scripts.add("sp_rename " + this.refTableName + "_OLD, " + this.refTableName);
        scripts.add("sp_rename JCR_FK_" + this.valueTableSuffix + "_PROPERTY_OLD, JCR_FK_" + this.valueTableSuffix + "_PROPERTY");
        scripts.add("sp_rename JCR_FK_" + this.itemTableSuffix + "_PARENT_OLD, JCR_FK_" + this.itemTableSuffix + "_PARENT");
        return scripts;
    }
}

