/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeDefinitionAccessProvider;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.UpdateNodeTypeObserver;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JCRNodeTypeDataPersister
implements NodeTypeDataPersister {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JCRNodeTypeDataPersister");
    private final DataManager dataManager;
    private NodeData nodeTypeStorageRoot;
    private final NodeTypeDefinitionAccessProvider definitionAccessProvider;
    private final boolean addACL;
    private boolean started = false;

    public JCRNodeTypeDataPersister(DataManager dataManager, boolean addACL) throws RepositoryException {
        this.dataManager = dataManager;
        this.addACL = addACL;
        this.definitionAccessProvider = new NodeTypeDefinitionAccessProvider(dataManager);
    }

    public JCRNodeTypeDataPersister(DataManager dataManager, NodeData nodeTypeStorageRoot) throws RepositoryException {
        this.dataManager = dataManager;
        this.nodeTypeStorageRoot = nodeTypeStorageRoot;
        this.definitionAccessProvider = new NodeTypeDefinitionAccessProvider(dataManager);
        this.addACL = true;
    }

    public JCRNodeTypeDataPersister(DataManager dataManager, RepositoryEntry repConfig) throws RepositoryException {
        this(dataManager, !repConfig.getAccessControl().equals("disable"));
    }

    @Override
    public void addNodeType(NodeTypeData nodeType) throws RepositoryException {
        if (!this.started) {
            LOG.warn((Object)("Unable save nodetype " + nodeType.getName().getAsString() + " in to the storage. Storage not initialized"));
            return;
        }
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        this.definitionAccessProvider.write(changesLog, this.nodeTypeStorageRoot, nodeType);
        this.dataManager.save(new TransactionChangesLog(changesLog));
    }

    @Override
    public boolean hasNodeType(InternalQName nodeTypeName) throws RepositoryException {
        if (!this.validatate()) {
            return false;
        }
        NodeData nodeTypeData = (NodeData)this.dataManager.getItemData(this.nodeTypeStorageRoot, new QPathEntry(nodeTypeName, 1), ItemType.NODE);
        return nodeTypeData != null;
    }

    public NodeData initNodetypesRoot(NodeData nsSystem, boolean addACL) throws RepositoryException {
        TransientNodeData jcrNodetypes;
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        if (addACL) {
            InternalQName[] mixins = new InternalQName[]{Constants.EXO_OWNEABLE, Constants.EXO_PRIVILEGEABLE};
            jcrNodetypes = TransientNodeData.createNodeData(nsSystem, Constants.JCR_NODETYPES, Constants.NT_UNSTRUCTURED, mixins, "00exo0jcr0node0types0root0uuid00");
            AccessControlList acl = jcrNodetypes.getACL();
            TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)jcrNodetypes, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(jcrNodetypes.getPrimaryTypeName()));
            changesLog.add(ItemState.createAddedState(jcrNodetypes)).add(ItemState.createAddedState(primaryType));
            ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
            for (InternalQName mixin : mixins) {
                mixValues.add(new TransientValueData(mixin));
            }
            TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)jcrNodetypes, Constants.JCR_MIXINTYPES, 7, true, mixValues);
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)jcrNodetypes, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = acl.getPermissionEntries().get(i);
                permsValues.add(new TransientValueData(entry));
            }
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)jcrNodetypes, Constants.EXO_PERMISSIONS, 100, true, permsValues);
            changesLog.add(ItemState.createAddedState(exoMixinTypes)).add(ItemState.createAddedState(exoOwner)).add(ItemState.createAddedState(exoPerms));
            changesLog.add(new ItemState(jcrNodetypes, 16, false, null));
        } else {
            jcrNodetypes = TransientNodeData.createNodeData(nsSystem, Constants.JCR_NODETYPES, Constants.NT_UNSTRUCTURED, "00exo0jcr0node0types0root0uuid00");
            TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)jcrNodetypes, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(jcrNodetypes.getPrimaryTypeName()));
            changesLog.add(ItemState.createAddedState(jcrNodetypes)).add(ItemState.createAddedState(primaryType));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("/jcr:system/jcr:nodetypes is created, creation time: " + (System.currentTimeMillis() - start) + " ms"));
        }
        this.dataManager.save(new TransactionChangesLog(changesLog));
        return jcrNodetypes;
    }

    @Override
    public boolean isStorageFilled() {
        if (this.nodeTypeStorageRoot == null) {
            LOG.warn((Object)" Storage not initialized");
            return false;
        }
        try {
            List<NodeData> storageContent = this.dataManager.getChildNodesData(this.nodeTypeStorageRoot);
            return storageContent.size() > 0;
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void addNodeTypes(List<NodeTypeData> nodeTypes) throws RepositoryException {
        if (!this.validatate()) {
            return;
        }
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        for (NodeTypeData nodeTypeData : nodeTypes) {
            this.definitionAccessProvider.write(changesLog, this.nodeTypeStorageRoot, nodeTypeData);
        }
        this.dataManager.save(new TransactionChangesLog(changesLog));
    }

    @Override
    public void removeNodeType(NodeTypeData nodeType) throws RepositoryException {
        if (!this.validatate()) {
            return;
        }
        this.validatate();
        NodeData nodeTypeData = (NodeData)this.dataManager.getItemData(this.nodeTypeStorageRoot, new QPathEntry(nodeType.getName(), 1), ItemType.NODE);
        ItemDataRemoveVisitor removeVisitor = new ItemDataRemoveVisitor((ItemDataConsumer)this.dataManager, this.nodeTypeStorageRoot.getQPath());
        nodeTypeData.accept(removeVisitor);
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        changesLog.addAll(removeVisitor.getRemovedStates());
        this.dataManager.save(new TransactionChangesLog(changesLog));
    }

    public void start() {
        if (!this.started) {
            block4: {
                try {
                    NodeData jcrSystem = (NodeData)this.dataManager.getItemData("00exo0jcr0system0uuid00000000000");
                    if (jcrSystem != null) {
                        NodeData jcrNodetypes = (NodeData)this.dataManager.getItemData(jcrSystem, new QPathEntry(Constants.JCR_NODETYPES, 1), ItemType.NODE);
                        this.nodeTypeStorageRoot = jcrNodetypes == null ? this.initNodetypesRoot(jcrSystem, this.addACL) : jcrNodetypes;
                        break block4;
                    }
                    throw new RuntimeException("Nodetypes storage (/jcr:systemnode) is not initialized.");
                }
                catch (RepositoryException e) {
                    throw new RuntimeException(e.getLocalizedMessage(), e);
                }
            }
            this.started = true;
        }
    }

    public void stop() {
    }

    @Override
    public NodeTypeData getNodeType(InternalQName nodeTypeName) throws RepositoryException, NoSuchNodeTypeException {
        if (this.nodeTypeStorageRoot == null) {
            LOG.warn((Object)" Storage not initialized");
            return null;
        }
        ItemData nodeType = this.dataManager.getItemData(this.nodeTypeStorageRoot, new QPathEntry(nodeTypeName, 1), ItemType.NODE);
        if (nodeType == null) {
            throw new NoSuchNodeTypeException("Node type definition " + nodeTypeName.getAsString() + "not found");
        }
        if (!nodeType.isNode()) {
            throw new RepositoryException("Unexpected property found " + nodeType.getQPath().getAsString() + ". Should be node.");
        }
        NodeData nodeTypeRoot = (NodeData)nodeType;
        if (!Constants.NT_NODETYPE.equals((Object)nodeTypeRoot.getPrimaryTypeName())) {
            throw new RepositoryException("Unexpected node type of NodeData found " + nodeTypeRoot.getPrimaryTypeName().getAsString() + ". Should be " + Constants.NT_NODETYPE.getAsString());
        }
        return this.definitionAccessProvider.read(nodeTypeRoot);
    }

    @Override
    public List<NodeTypeData> getAllNodeTypes() throws RepositoryException {
        if (!this.validatate()) {
            return new ArrayList<NodeTypeData>();
        }
        this.validatate();
        List<NodeData> nodeTypes = this.dataManager.getChildNodesData(this.nodeTypeStorageRoot);
        ArrayList<NodeTypeData> result = new ArrayList<NodeTypeData>();
        for (NodeData nodeData : nodeTypes) {
            if (!Constants.NT_NODETYPE.equals((Object)nodeData.getPrimaryTypeName())) continue;
            result.add(this.definitionAccessProvider.read(nodeData));
        }
        return result;
    }

    @Override
    public void update(List<NodeTypeData> nodeTypes, UpdateNodeTypeObserver observer) throws RepositoryException {
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        for (NodeTypeData nodeTypeData : nodeTypes) {
            if (observer != null) {
                if (observer.shouldSkip(nodeTypeData, changesLog)) continue;
                observer.beforeUpdate(nodeTypeData, changesLog);
            }
            if (!this.validatate()) continue;
            NodeData removeNodeTypeData = (NodeData)this.dataManager.getItemData(this.nodeTypeStorageRoot, new QPathEntry(nodeTypeData.getName(), 1), ItemType.NODE);
            if (removeNodeTypeData != null) {
                ItemDataRemoveVisitor removeVisitor = new ItemDataRemoveVisitor((ItemDataConsumer)this.dataManager, this.nodeTypeStorageRoot.getQPath());
                removeNodeTypeData.accept(removeVisitor);
                changesLog.addAll(removeVisitor.getRemovedStates());
            }
            this.definitionAccessProvider.write(changesLog, this.nodeTypeStorageRoot, nodeTypeData);
            if (observer == null) continue;
            observer.afterUpdate(nodeTypeData, changesLog);
        }
        if (changesLog.getSize() > 0) {
            this.dataManager.save(new TransactionChangesLog(changesLog));
        }
    }

    private boolean validatate() {
        if (this.nodeTypeStorageRoot == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)" Storage not initialized");
            }
            return false;
        }
        return true;
    }
}

