/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractWeight;

public class JcrTermQuery
extends TermQuery {
    private static final long serialVersionUID = 4244799812287335957L;

    public JcrTermQuery(Term t) {
        super(t);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new JackrabbitTermWeight(searcher, super.createWeight(searcher));
    }

    protected class JackrabbitTermWeight
    extends AbstractWeight {
        private static final long serialVersionUID = -2070964510010945854L;
        private final Weight weight;

        public JackrabbitTermWeight(Searcher searcher, Weight weight) {
            super(searcher);
            this.weight = weight;
        }

        @Override
        protected Scorer createScorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return this.weight.scorer(reader, scoreDocsInOrder, topScorer);
        }

        public Query getQuery() {
            return JcrTermQuery.this;
        }

        public float getValue() {
            return this.weight.getValue();
        }

        public float sumOfSquaredWeights() throws IOException {
            return this.weight.sumOfSquaredWeights();
        }

        public void normalize(float norm) {
            this.weight.normalize(norm);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return this.weight.explain(reader, doc);
        }
    }
}

