/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.util.Map;
import java.util.Set;
import org.exoplatform.services.jcr.impl.quota.CalculateNodeDataSizeTool;
import org.exoplatform.services.jcr.impl.quota.ChangesItem;
import org.exoplatform.services.jcr.impl.quota.QuotaManagerException;
import org.exoplatform.services.jcr.impl.quota.QuotaPersister;
import org.exoplatform.services.jcr.impl.quota.UnknownDataSizeException;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ApplyPersistedChangesTask
implements Runnable {
    protected final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ApplyPersistedChangesTask");
    protected final ChangesItem changesItem;
    protected final String wsName;
    protected final String rName;
    protected final QuotaPersister quotaPersister;
    protected final WorkspaceQuotaContext context;
    protected final CalculateNodeDataSizeTool calculateNodeDataSizeTool;

    ApplyPersistedChangesTask(WorkspaceQuotaContext context, ChangesItem changesItem) {
        this.changesItem = changesItem;
        this.context = context;
        this.wsName = context.wsName;
        this.rName = context.rName;
        this.quotaPersister = context.quotaPersister;
        this.calculateNodeDataSizeTool = new CalculateNodeDataSizeTool(context);
    }

    @Override
    public void run() {
        try {
            long delta = this.changesItem.getWorkspaceChangedSize();
            this.accumulatePersistedWorkspaceChanges(delta);
            this.accumulatePersistedRepositoryChanges(delta);
            this.accumulatePersistedGlobalChanges(delta);
            this.removeNodeDataSizeFor(this.changesItem.getAllNodesUnknownChangedSize());
            this.accumulatePersistedNodesChanges(this.changesItem.getAllNodesCalculatedChangedSize());
        }
        catch (QuotaManagerException e) {
            this.LOG.error((Object)"Can't apply persisted changes", (Throwable)e);
        }
    }

    private void removeNodeDataSizeFor(Set<String> paths) {
        Set<String> trackedNodes = this.quotaPersister.getAllTrackedNodes(this.rName, this.wsName);
        for (String nodePath : paths) {
            for (String trackedPath : trackedNodes) {
                if (!trackedPath.startsWith(nodePath)) continue;
                this.quotaPersister.removeNodeDataSize(this.rName, this.wsName, trackedPath);
            }
        }
    }

    protected void accumulatePersistedNodesChanges(Map<String, Long> calculatedChangedNodesSize) throws QuotaManagerException {
        for (Map.Entry<String, Long> entry : calculatedChangedNodesSize.entrySet()) {
            String nodePath = entry.getKey();
            long delta = entry.getValue();
            try {
                long dataSize = delta + this.quotaPersister.getNodeDataSize(this.rName, this.wsName, nodePath);
                this.quotaPersister.setNodeDataSizeIfQuotaExists(this.rName, this.wsName, nodePath, dataSize);
            }
            catch (UnknownDataSizeException e) {
                this.calculateNodeDataSizeTool.getAndSetNodeDataSize(nodePath);
            }
        }
    }

    protected void accumulatePersistedWorkspaceChanges(long delta) throws QuotaManagerException {
        long dataSize;
        block2: {
            dataSize = 0L;
            try {
                dataSize = this.quotaPersister.getWorkspaceDataSize(this.rName, this.wsName);
            }
            catch (UnknownDataSizeException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        long newDataSize = Math.max(dataSize + delta, 0L);
        this.quotaPersister.setWorkspaceDataSize(this.rName, this.wsName, newDataSize);
    }

    protected void accumulatePersistedRepositoryChanges(long delta) {
        long dataSize;
        block2: {
            dataSize = 0L;
            try {
                dataSize = this.quotaPersister.getRepositoryDataSize(this.rName);
            }
            catch (UnknownDataSizeException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        long newDataSize = Math.max(dataSize + delta, 0L);
        this.quotaPersister.setRepositoryDataSize(this.rName, newDataSize);
    }

    private void accumulatePersistedGlobalChanges(long delta) {
        long dataSize;
        block2: {
            dataSize = 0L;
            try {
                dataSize = this.quotaPersister.getGlobalDataSize();
            }
            catch (UnknownDataSizeException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        long newDataSize = Math.max(dataSize + delta, 0L);
        this.quotaPersister.setGlobalDataSize(newDataSize);
    }
}

