/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.exoplatform.services.jcr.impl.quota.ChangesItem;

class ChangesLog
extends ConcurrentLinkedQueue<ChangesItem> {
    ChangesLog() {
    }

    public long getWorkspaceChangedSize() {
        long wsDelta = 0L;
        Iterator changes = this.iterator();
        while (changes.hasNext()) {
            wsDelta += ((ChangesItem)changes.next()).getWorkspaceChangedSize();
        }
        return wsDelta;
    }

    public long getNodeChangedSize(String nodePath) {
        long nodeDelta = 0L;
        Iterator changes = this.iterator();
        while (changes.hasNext()) {
            nodeDelta += ((ChangesItem)changes.next()).getNodeChangedSize(nodePath);
        }
        return nodeDelta;
    }

    public ChangesItem pollAndMergeAll() {
        ChangesItem totalChanges = new ChangesItem();
        ChangesItem particularChanges = (ChangesItem)this.poll();
        while (particularChanges != null) {
            totalChanges.merge(particularChanges);
            particularChanges = (ChangesItem)this.poll();
        }
        return totalChanges;
    }
}

