/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalACLException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ACLHolder;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ChangedSizeHandler;
import org.exoplatform.services.jcr.impl.dataflow.persistent.SimplePersistedSize;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class CQJDBCStorageConnection
extends JDBCStorageConnection {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.CQJDBCStorageConnection");
    protected static final String PATTERN_ESCAPE_STRING = "\\";
    protected static final String SINGLE_QUOTE_ESCAPE_PATTERN = "'";
    protected String FIND_NODES_BY_PARENTID_CQ;
    protected String FIND_PROPERTIES_BY_PARENTID_CQ;
    protected String FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ;
    protected String FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE;
    protected String FIND_NODES_BY_PARENTID_LAZILY_CQ;
    protected String FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE;
    protected String FIND_ITEM_QPATH_BY_ID_CQ;
    protected String FIND_PROPERTY_BY_ID;
    protected String DELETE_VALUE_BY_ORDER_NUM;
    protected String DELETE_REFERENCE_BY_ORDER_NUM;
    protected String UPDATE_VALUE;
    protected String UPDATE_REFERENCE;
    protected String FIND_LAST_ORDER_NUMBER;
    protected String FIND_ACL_HOLDERS;
    protected PreparedStatement findACLHolders;
    protected PreparedStatement findNodesByParentIdCQ;
    protected PreparedStatement findPropertiesByParentIdCQ;
    protected PreparedStatement findNodeMainPropertiesByParentIdentifierCQ;
    protected PreparedStatement findItemQPathByIdentifierCQ;
    protected PreparedStatement findPropertyById;
    protected PreparedStatement findNodesByParentIdLazilyCQ;
    protected PreparedStatement findLastOrderNumber;
    protected PreparedStatement deleteValueDataByOrderNum;
    protected PreparedStatement deleteReferenceByOrderNum;
    protected PreparedStatement updateReference;
    protected PreparedStatement updateValue;
    protected Statement findPropertiesByParentIdAndComplexPatternCQ;
    protected Statement findNodesByParentIdAndComplexPatternCQ;
    private int changeStatus;
    private int changeCount;
    private static final NodeData FAKE_NODE;
    private static final PropertyData FAKE_PROPERTY;
    private static final int TYPE_ADD = 1;
    private static final int TYPE_UPDATE = 2;
    private static final int TYPE_DELETE = 4;
    private static final int TYPE_RENAME = 8;
    protected static final int TYPE_DELETE_LOCK = 16;
    protected static final int TYPE_INSERT_NODE = 32;
    protected static final int TYPE_INSERT_PROPERTY = 64;
    protected static final int TYPE_INSERT_REFERENCE = 128;
    protected static final int TYPE_INSERT_VALUE = 256;
    protected static final int TYPE_UPDATE_NODE = 512;
    protected static final int TYPE_UPDATE_PROPERTY = 1024;
    protected static final int TYPE_UPDATE_VALUE = 2048;
    protected static final int TYPE_UPDATE_REFERENCE = 4096;
    protected static final int TYPE_DELETE_ITEM = 8192;
    protected static final int TYPE_DELETE_REFERENCE = 16384;
    protected static final int TYPE_DELETE_VALUE = 32768;
    protected static final int TYPE_DELETE_VALUE_BY_ORDER_NUM = 65536;
    protected static final int TYPE_DELETE_REFERENCE_BY_ORDER_NUM = 131072;
    protected static final int TYPE_RENAME_NODE = 262144;
    private ItemData currentItem;
    private Map<Integer, List<ItemData>> currentItems;
    private int localMaxOrderNumber;
    private Set<String> addedNodeIds;
    private boolean updateSequence;

    protected CQJDBCStorageConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    @Override
    public List<ACLHolder> getACLHolders() throws RepositoryException, IllegalStateException, UnsupportedOperationException {
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            resultSet = this.findACLHolders();
            HashMap<String, ACLHolder> mHolders = new HashMap<String, ACLHolder>();
            while (resultSet.next()) {
                int cptype;
                String cpid = this.getIdentifier(resultSet.getString("PARENT_ID"));
                ACLHolder holder = (ACLHolder)mHolders.get(cpid);
                if (holder == null) {
                    holder = new ACLHolder(cpid);
                    mHolders.put(cpid, holder);
                }
                if ((cptype = resultSet.getInt("P_TYPE")) == 100) {
                    holder.setPermissions(true);
                    continue;
                }
                holder.setOwner(true);
            }
            ArrayList<ACLHolder> arrayList = new ArrayList<ACLHolder>(mHolders.values());
            return arrayList;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            PersistedNodeData nodeData;
            resultSet = this.findChildNodesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()));
            JDBCStorageConnection.TempNodeData data = null;
            ArrayList<NodeData> childNodes = new ArrayList<NodeData>();
            while (resultSet.next()) {
                if (data == null) {
                    data = new JDBCStorageConnection.TempNodeData(resultSet);
                } else if (!resultSet.getString("ID").equals(data.cid)) {
                    nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                    childNodes.add(nodeData);
                    data = new JDBCStorageConnection.TempNodeData(resultSet);
                }
                Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties = data.properties;
                String key = resultSet.getString("PROP_NAME");
                SortedSet<JDBCStorageConnection.TempPropertyData> values = properties.get(key);
                if (values == null) {
                    values = new TreeSet<JDBCStorageConnection.TempPropertyData>();
                    properties.put(key, values);
                }
                values.add(new JDBCStorageConnection.TempPropertyData(resultSet));
            }
            if (data != null) {
                nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                childNodes.add(nodeData);
            }
            ArrayList<NodeData> arrayList = childNodes;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parent, List<QPathEntryFilter> pattern) throws RepositoryException, IllegalStateException {
        return this.getChildNodesDataInternal(parent, pattern);
    }

    protected List<NodeData> getDirectChildNodesData(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        if (itemDataFilters.isEmpty()) {
            return new ArrayList<NodeData>();
        }
        ArrayList<NodeData> children = new ArrayList<NodeData>();
        Iterator<QPathEntryFilter> it = itemDataFilters.iterator();
        while (it.hasNext()) {
            QPathEntryFilter filter = it.next();
            if (!filter.isExactName()) continue;
            NodeData data = (NodeData)this.getItemData(parent, filter.getQPathEntry(), ItemType.NODE);
            if (data != null) {
                children.add(data);
            }
            it.remove();
        }
        if (!itemDataFilters.isEmpty()) {
            children.addAll(this.getChildNodesDataInternal(parent, itemDataFilters));
        }
        return children;
    }

    private List<NodeData> getChildNodesDataInternal(NodeData parent, List<QPathEntryFilter> pattern) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        if (pattern.isEmpty()) {
            return new ArrayList<NodeData>();
        }
        ResultSet resultSet = null;
        try {
            PersistedNodeData nodeData;
            resultSet = this.findChildNodesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()), pattern);
            JDBCStorageConnection.TempNodeData data = null;
            ArrayList<NodeData> childNodes = new ArrayList<NodeData>();
            while (resultSet.next()) {
                if (data == null) {
                    data = new JDBCStorageConnection.TempNodeData(resultSet);
                } else if (!resultSet.getString("ID").equals(data.cid)) {
                    nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                    childNodes.add(nodeData);
                    data = new JDBCStorageConnection.TempNodeData(resultSet);
                }
                Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties = data.properties;
                String key = resultSet.getString("PROP_NAME");
                SortedSet<JDBCStorageConnection.TempPropertyData> values = properties.get(key);
                if (values == null) {
                    values = new TreeSet<JDBCStorageConnection.TempPropertyData>();
                    properties.put(key, values);
                }
                values.add(new JDBCStorageConnection.TempPropertyData(resultSet));
            }
            if (data != null) {
                nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                childNodes.add(nodeData);
            }
            ArrayList<NodeData> arrayList = childNodes;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public boolean getChildNodesDataByPage(NodeData parent, int fromOrderNum, int offset, int pageSize, List<NodeData> childNodes) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            PersistedNodeData nodeData;
            resultSet = this.findChildNodesByParentIdentifier(this.getInternalId(parent.getIdentifier()), fromOrderNum, offset, pageSize);
            JDBCStorageConnection.TempNodeData data = null;
            while (resultSet.next()) {
                if (data == null) {
                    data = new JDBCStorageConnection.TempNodeData(resultSet);
                } else if (!resultSet.getString("ID").equals(data.cid)) {
                    nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                    childNodes.add(nodeData);
                    data = new JDBCStorageConnection.TempNodeData(resultSet);
                }
                Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties = data.properties;
                String key = resultSet.getString("PROP_NAME");
                SortedSet<JDBCStorageConnection.TempPropertyData> values = properties.get(key);
                if (values == null) {
                    values = new TreeSet<JDBCStorageConnection.TempPropertyData>();
                    properties.put(key, values);
                }
                values.add(new JDBCStorageConnection.TempPropertyData(resultSet));
            }
            if (data != null) {
                nodeData = this.loadNodeFromTemporaryNodeData(data, parent.getQPath(), parent.getACL());
                childNodes.add(nodeData);
            }
            boolean bl = !childNodes.isEmpty() ? true : super.getLastOrderNumber(parent) > fromOrderNum + pageSize - 1;
            return bl;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(PropertyData data, ChangedSizeHandler sizeHandler) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        ResultSet rs = null;
        this.currentItem = data;
        try {
            this.setOperationType(2);
            String cid = this.getInternalId(data.getIdentifier());
            rs = this.findPropertyById(cid);
            HashSet<String> storageDescs = new HashSet<String>();
            int totalOldValues = 0;
            int prevType = -1;
            while (rs.next()) {
                if (prevType == -1) {
                    prevType = rs.getInt("P_TYPE");
                }
                ++totalOldValues;
                String storageId = rs.getString("STORAGE_DESC");
                if (!rs.wasNull()) {
                    storageDescs.add(storageId);
                    continue;
                }
                sizeHandler.accumulatePrevSize(rs.getLong(1));
            }
            if (this.updatePropertyByIdentifier(data.getPersistedVersion(), data.getType(), cid) <= 0) {
                throw new JCRInvalidItemStateException("(update) Property not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 2);
            }
            try {
                if (prevType == 9 && data.getType() == 9) {
                    this.replaceReference(data, cid, totalOldValues);
                } else if (prevType == 9) {
                    this.deleteReference(cid);
                } else if (data.getType() == 9) {
                    this.addReference(data);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Can't update REFERENCE property (" + data.getQPath() + " " + data.getIdentifier() + ") value: " + e.getMessage(), (Throwable)e);
            }
            this.deleteValues(cid, data, storageDescs, totalOldValues, sizeHandler);
            this.addOrUpdateValues(cid, data, totalOldValues, sizeHandler);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property update. IO error: " + e), (Throwable)e);
            }
            throw new RepositoryException("Error of Property Value update " + e, (Throwable)e);
        }
        catch (SQLException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Property update. Database error: " + e), (Throwable)e);
            }
            this.exceptionHandler.handleUpdateException(e, data);
        }
        finally {
            this.currentItem = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
    }

    private void replaceReference(PropertyData data, String cid, int totalOldValues) throws SQLException, InvalidItemStateException, RepositoryException, IOException {
        List<ValueData> vdata = data.getValues();
        if (vdata.size() < totalOldValues) {
            this.deleteReferenceByOrderNum(cid, data.getValues().size());
        }
        for (int i = 0; i < vdata.size(); ++i) {
            String refNodeIdentifier;
            ValueData vd = vdata.get(i);
            try {
                refNodeIdentifier = ValueDataUtil.getString(vd);
            }
            catch (RepositoryException e) {
                throw new IOException(e.getMessage(), e);
            }
            if (i < totalOldValues) {
                this.updateReference(cid, i, this.getInternalId(refNodeIdentifier));
                continue;
            }
            this.addReference(cid, i, this.getInternalId(refNodeIdentifier));
        }
    }

    @Override
    public void add(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.currentItem = data;
        try {
            this.setOperationType(1);
            if (this.containerConfig.useSequenceForOrderNumber) {
                this.localMaxOrderNumber = Math.max(data.getOrderNumber(), this.localMaxOrderNumber);
                if (!this.updateSequence) {
                    if (this.addedNodeIds == null) {
                        this.addedNodeIds = new HashSet<String>();
                    }
                    this.addedNodeIds.add(data.getIdentifier());
                    String pid = data.getParentIdentifier();
                    boolean bl = this.updateSequence = pid != null && this.addedNodeIds.contains(pid);
                    if (this.updateSequence) {
                        this.addedNodeIds = null;
                    }
                }
            }
            super.add(data);
        }
        finally {
            this.currentItem = null;
        }
    }

    @Override
    public void add(PropertyData data, ChangedSizeHandler sizeHandler) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.currentItem = data;
        try {
            this.setOperationType(1);
            super.add(data, sizeHandler);
        }
        finally {
            this.currentItem = null;
        }
    }

    @Override
    public void rename(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.currentItem = data;
        try {
            this.setOperationType(8);
            super.rename(data);
        }
        finally {
            this.currentItem = null;
        }
    }

    @Override
    public void delete(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.currentItem = data;
        try {
            this.setOperationType(4);
            super.delete(data);
        }
        finally {
            this.currentItem = null;
        }
    }

    @Override
    public void delete(PropertyData data, ChangedSizeHandler sizeHandler) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.currentItem = data;
        try {
            this.setOperationType(4);
            super.delete(data, sizeHandler);
        }
        finally {
            this.currentItem = null;
        }
    }

    @Override
    public void update(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.currentItem = data;
        try {
            this.setOperationType(2);
            super.update(data);
        }
        finally {
            this.currentItem = null;
        }
    }

    @Override
    protected void addValues(String cid, PropertyData data, ChangedSizeHandler sizeHandler) throws IOException, SQLException, RepositoryException {
        this.addOrUpdateValues(cid, data, 0, sizeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOrUpdateValues(String cid, PropertyData data, int totalOldValues, ChangedSizeHandler sizeHandler) throws IOException, RepositoryException, SQLException {
        List<ValueData> vdata = data.getValues();
        for (int i = 0; i < vdata.size(); ++i) {
            String storageId;
            int streamLength;
            InputStream stream;
            ValueData vd = vdata.get(i);
            ValueIOChannel channel = this.containerConfig.valueStorageProvider.getApplicableChannel(data, i);
            if (channel == null) {
                if (vd.isByteArray()) {
                    byte[] dataBytes = vd.getAsByteArray();
                    stream = new ByteArrayInputStream(dataBytes);
                    streamLength = dataBytes.length;
                } else {
                    StreamPersistedValueData streamData;
                    block10: {
                        streamData = (StreamPersistedValueData)vd;
                        SwapFile swapFile = SwapFile.get(this.containerConfig.spoolConfig.tempDirectory, cid + i + "." + data.getPersistedVersion(), this.containerConfig.spoolConfig.fileCleaner);
                        try {
                            long vlen = WRITE_VALUE_HELPER.writeStreamedValue(swapFile, streamData);
                            if (vlen <= Integer.MAX_VALUE) {
                                streamLength = (int)vlen;
                                break block10;
                            }
                            throw new RepositoryException("Value data large of allowed by JDBC (Integer.MAX_VALUE) " + vlen + ". Property " + data.getQPath().getAsString());
                        }
                        finally {
                            swapFile.spoolDone();
                        }
                    }
                    stream = streamData.getAsStream();
                }
                storageId = null;
                sizeHandler.accumulateNewSize(streamLength);
            } else {
                channel.write(data.getIdentifier(), vd, sizeHandler);
                this.valueChanges.add(channel);
                storageId = channel.getStorageId();
                stream = null;
                streamLength = 0;
            }
            if (i < totalOldValues) {
                this.updateValueData(cid, i, stream, streamLength, storageId);
                continue;
            }
            this.addValueData(cid, i, stream, streamLength, storageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteValues(String cid, PropertyData pdata, Set<String> storageDescs, int totalOldValues, ChangedSizeHandler sizeHandler) throws IOException, SQLException, InvalidItemStateException, RepositoryException {
        for (String storageId : storageDescs) {
            try (ValueIOChannel channel = this.containerConfig.valueStorageProvider.getChannel(storageId);){
                sizeHandler.accumulatePrevSize(channel.getValueSize(pdata.getIdentifier()));
                channel.delete(pdata.getIdentifier());
                this.valueChanges.add(channel);
            }
        }
        if (pdata.getValues().size() < totalOldValues) {
            this.deleteValueDataByOrderNum(cid, pdata.getValues().size());
        }
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            resultSet = this.findChildPropertiesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()));
            ArrayList<PropertyData> children = new ArrayList<PropertyData>();
            QPath parentPath = parent.getQPath();
            if (resultSet.next()) {
                boolean isNotLast = true;
                do {
                    QPath qpath;
                    String cid = resultSet.getString("ID");
                    String identifier = this.getIdentifier(cid);
                    String cname = resultSet.getString("NAME");
                    int cversion = resultSet.getInt("VERSION");
                    String cpid = resultSet.getString("PARENT_ID");
                    int cptype = resultSet.getInt("P_TYPE");
                    boolean cpmultivalued = resultSet.getBoolean("P_MULTIVALUED");
                    try {
                        qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, InternalQName.parse(cname));
                    }
                    catch (IllegalNameException e) {
                        throw new RepositoryException(e.getMessage(), (Throwable)e);
                    }
                    ArrayList<ValueData> data = new ArrayList<ValueData>();
                    long size = 0L;
                    do {
                        int orderNum = resultSet.getInt("ORDER_NUM");
                        if (resultSet.wasNull()) continue;
                        String storageId = resultSet.getString("STORAGE_DESC");
                        ValueDataUtil.ValueDataWrapper vdWrapper = resultSet.wasNull() ? ValueDataUtil.readValueData(cid, cptype, orderNum, cversion, resultSet.getBinaryStream("DATA"), this.containerConfig.spoolConfig) : this.readValueData(identifier, orderNum, cptype, storageId);
                        data.add(vdWrapper.value);
                        size += vdWrapper.size;
                    } while ((isNotLast = resultSet.next()) && resultSet.getString("ID").equals(cid));
                    Collections.sort(data, COMPARATOR_VALUE_DATA);
                    PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued, data, new SimplePersistedSize(size));
                    children.add(pdata);
                } while (isNotLast);
            }
            ArrayList<PropertyData> arrayList = children;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
    }

    protected List<PropertyData> getDirectChildPropertiesData(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        ArrayList<PropertyData> children = new ArrayList<PropertyData>();
        Iterator<QPathEntryFilter> it = itemDataFilters.iterator();
        while (it.hasNext()) {
            QPathEntryFilter filter = it.next();
            if (!filter.isExactName()) continue;
            PropertyData data = (PropertyData)this.getItemData(parent, filter.getQPathEntry(), ItemType.PROPERTY);
            if (data != null) {
                children.add(data);
            }
            it.remove();
        }
        if (!itemDataFilters.isEmpty()) {
            children.addAll(this.getChildPropertiesDataInternal(parent, itemDataFilters));
        }
        return children;
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException, IllegalStateException {
        return this.getChildPropertiesDataInternal(parent, itemDataFilters);
    }

    private List<PropertyData> getChildPropertiesDataInternal(NodeData parent, List<QPathEntryFilter> itemDataFilters) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        ResultSet resultSet = null;
        try {
            resultSet = this.findChildPropertiesByParentIdentifierCQ(this.getInternalId(parent.getIdentifier()), itemDataFilters);
            ArrayList<PropertyData> children = new ArrayList<PropertyData>();
            QPath parentPath = parent.getQPath();
            if (resultSet.next()) {
                boolean isNotLast = true;
                do {
                    QPath qpath;
                    String cid = resultSet.getString("ID");
                    String identifier = this.getIdentifier(cid);
                    String cname = resultSet.getString("NAME");
                    int cversion = resultSet.getInt("VERSION");
                    String cpid = resultSet.getString("PARENT_ID");
                    int cptype = resultSet.getInt("P_TYPE");
                    boolean cpmultivalued = resultSet.getBoolean("P_MULTIVALUED");
                    try {
                        qpath = QPath.makeChildPath(parentPath == null ? this.traverseQPath(cpid) : parentPath, InternalQName.parse(cname));
                    }
                    catch (IllegalNameException e) {
                        throw new RepositoryException(e.getMessage(), (Throwable)e);
                    }
                    ArrayList<ValueData> data = new ArrayList<ValueData>();
                    long size = 0L;
                    do {
                        int orderNum = resultSet.getInt("ORDER_NUM");
                        if (resultSet.wasNull()) continue;
                        String storageId = resultSet.getString("STORAGE_DESC");
                        ValueDataUtil.ValueDataWrapper vdDataWrapper = resultSet.wasNull() ? ValueDataUtil.readValueData(cid, cptype, orderNum, cversion, resultSet.getBinaryStream("DATA"), this.containerConfig.spoolConfig) : this.readValueData(identifier, orderNum, cptype, storageId);
                        data.add(vdDataWrapper.value);
                        size += vdDataWrapper.size;
                    } while ((isNotLast = resultSet.next()) && resultSet.getString("ID").equals(cid));
                    Collections.sort(data, COMPARATOR_VALUE_DATA);
                    PersistedPropertyData pdata = new PersistedPropertyData(identifier, qpath, this.getIdentifier(cpid), cversion, cptype, cpmultivalued, data, new SimplePersistedSize(size));
                    children.add(pdata);
                } while (isNotLast);
            }
            ArrayList<PropertyData> arrayList = children;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
    }

    protected List<AccessControlEntry> readACLPermisions(String cid, Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties) throws SQLException, IllegalACLException, IOException {
        ArrayList<AccessControlEntry> naPermissions = new ArrayList<AccessControlEntry>();
        Set permValues = properties.get(Constants.EXO_PERMISSIONS.getAsString());
        if (permValues != null) {
            for (JDBCStorageConnection.TempPropertyData value : permValues) {
                AccessControlEntry ace;
                try {
                    ace = AccessControlEntry.parse(ValueDataUtil.getString(value.getValueData()));
                }
                catch (RepositoryException e) {
                    throw new IOException(e.getMessage(), e);
                }
                naPermissions.add(ace);
            }
            return naPermissions;
        }
        throw new IllegalACLException("Property exo:permissions is not found for node with id: " + this.getIdentifier(cid));
    }

    protected String readACLOwner(String cid, Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties) throws IllegalACLException, IOException {
        SortedSet<JDBCStorageConnection.TempPropertyData> ownerValues = properties.get(Constants.EXO_OWNER.getAsString());
        if (ownerValues != null) {
            try {
                return ValueDataUtil.getString(ownerValues.first().getValueData());
            }
            catch (RepositoryException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        throw new IllegalACLException("Property exo:owner is not found for node with id: " + this.getIdentifier(cid));
    }

    @Override
    protected PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, AccessControlList parentACL) throws RepositoryException, SQLException {
        ResultSet ptProp = this.findNodeMainPropertiesByParentIdentifierCQ(cid);
        try {
            HashMap<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties = new HashMap<String, SortedSet<JDBCStorageConnection.TempPropertyData>>();
            while (ptProp.next()) {
                String key = ptProp.getString("NAME");
                TreeSet<JDBCStorageConnection.TempPropertyData> values = (TreeSet<JDBCStorageConnection.TempPropertyData>)properties.get(key);
                if (values == null) {
                    values = new TreeSet<JDBCStorageConnection.TempPropertyData>();
                    properties.put(key, values);
                }
                values.add(new JDBCStorageConnection.TempPropertyData(ptProp));
            }
            PersistedNodeData persistedNodeData = this.loadNodeRecord(parentPath, cname, cid, cpid, cindex, cversion, cnordernumb, properties, parentACL);
            return persistedNodeData;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            try {
                ptProp.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
            }
        }
    }

    protected PersistedNodeData loadNodeFromTemporaryNodeData(JDBCStorageConnection.TempNodeData tempData, QPath parentPath, AccessControlList parentACL) throws RepositoryException, SQLException, IOException {
        return this.loadNodeRecord(parentPath, tempData.cname, tempData.cid, tempData.cpid, tempData.cindex, tempData.cversion, tempData.cnordernumb, tempData.properties, parentACL);
    }

    private PersistedNodeData loadNodeRecord(QPath parentPath, String cname, String cid, String cpid, int cindex, int cversion, int cnordernumb, Map<String, SortedSet<JDBCStorageConnection.TempPropertyData>> properties, AccessControlList parentACL) throws RepositoryException, SQLException, IOException {
        try {
            InternalQName[] mts;
            String parentCid;
            QPath qpath;
            InternalQName qname = InternalQName.parse(cname);
            if (parentPath != null) {
                qpath = QPath.makeChildPath(parentPath, qname, cindex, this.getIdentifier(cid));
                parentCid = cpid;
            } else if (cpid.equals(Constants.ROOT_PARENT_UUID)) {
                qpath = Constants.ROOT_PATH;
                parentCid = null;
            } else {
                qpath = QPath.makeChildPath(this.traverseQPath(cpid), qname, cindex, this.getIdentifier(cid));
                parentCid = cpid;
            }
            SortedSet<JDBCStorageConnection.TempPropertyData> primaryType = properties.get(Constants.JCR_PRIMARYTYPE.getAsString());
            if (primaryType == null || primaryType.isEmpty()) {
                throw new PrimaryTypeNotFoundException("FATAL ERROR primary type record not found. Node " + qpath.getAsString() + ", id " + this.getIdentifier(cid) + ", container " + this.containerConfig.containerName, null);
            }
            InternalQName ptName = InternalQName.parse(ValueDataUtil.getString(primaryType.first().getValueData()));
            boolean owneable = false;
            boolean privilegeable = false;
            Set mixTypes = properties.get(Constants.JCR_MIXINTYPES.getAsString());
            if (mixTypes != null) {
                ArrayList<InternalQName> mNames = new ArrayList<InternalQName>();
                for (JDBCStorageConnection.TempPropertyData mxnb : mixTypes) {
                    InternalQName mxn = InternalQName.parse(ValueDataUtil.getString(mxnb.getValueData()));
                    mNames.add(mxn);
                    if (!privilegeable && Constants.EXO_PRIVILEGEABLE.equals((Object)mxn)) {
                        privilegeable = true;
                        continue;
                    }
                    if (owneable || !Constants.EXO_OWNEABLE.equals((Object)mxn)) continue;
                    owneable = true;
                }
                mts = new InternalQName[mNames.size()];
                mNames.toArray(mts);
            } else {
                mts = new InternalQName[]{};
            }
            try {
                AccessControlList acl = owneable ? (privilegeable ? new AccessControlList(this.readACLOwner(cid, properties), this.readACLPermisions(cid, properties)) : (parentACL != null ? new AccessControlList(this.readACLOwner(cid, properties), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : new AccessControlList(this.readACLOwner(cid, properties), null))) : (privilegeable ? (owneable ? new AccessControlList(this.readACLOwner(cid, properties), this.readACLPermisions(cid, properties)) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), this.readACLPermisions(cid, properties)) : new AccessControlList(null, this.readACLPermisions(cid, properties)))) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : null));
                return new PersistedNodeData(this.getIdentifier(cid), qpath, this.getIdentifier(parentCid), cversion, cnordernumb, ptName, mts, acl);
            }
            catch (IllegalACLException e) {
                throw new RepositoryException("FATAL ERROR Node " + this.getIdentifier(cid) + " " + qpath.getAsString() + " has wrong formed ACL. ", (Throwable)e);
            }
        }
        catch (IllegalNameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public int getLastOrderNumber(NodeData parent) throws RepositoryException {
        if (!this.containerConfig.useSequenceForOrderNumber) {
            return super.getLastOrderNumber(parent);
        }
        return this.getLastOrderNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getLastOrderNumber() throws RepositoryException {
        this.checkIfOpened();
        try {
            ResultSet count = this.findLastOrderNumber(1, true);
            try {
                if (count.next()) {
                    int n = count.getInt(1) - 1;
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                try {
                    count.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void updateSequence() throws RepositoryException {
        this.checkIfOpened();
        try {
            ResultSet count = this.updateNextOrderNumber(this.localMaxOrderNumber);
            try {
                if (!count.next()) {
                    throw new RepositoryException("Could not update the sequence: the returned value cannot be found");
                }
            }
            finally {
                try {
                    count.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected ResultSet updateNextOrderNumber(int localMaxOrderNumber) throws SQLException {
        return this.findLastOrderNumber(localMaxOrderNumber, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        String id = this.getIdentifier(cpid);
        if (id.equals("00exo0jcr0root0uuid0000000000000")) {
            return Constants.ROOT_PATH;
        }
        ArrayList<QPathEntry> qrpath = new ArrayList<QPathEntry>();
        String caid = cpid;
        boolean isRoot = false;
        do {
            ResultSet result = null;
            try {
                result = this.findItemQPathByIdentifierCQ(caid);
                if (!result.next()) {
                    throw new InvalidItemStateException("Parent not found, uuid: " + this.getIdentifier(caid));
                }
                String cid = result.getString("ID");
                QPathEntry qpe1 = new QPathEntry(InternalQName.parse(result.getString("NAME")), result.getInt("I_INDEX"), this.getIdentifier(cid));
                boolean isChild = caid.equals(cid);
                caid = result.getString("PARENT_ID");
                if (cid.equals(caid)) {
                    throw new InvalidItemStateException("An item with id='" + this.getIdentifier(caid) + "' is its own parent");
                }
                if (result.next()) {
                    QPathEntry qpe2 = new QPathEntry(InternalQName.parse(result.getString("NAME")), result.getInt("I_INDEX"), this.getIdentifier(result.getString("ID")));
                    if (isChild) {
                        qrpath.add(qpe1);
                        qrpath.add(qpe2);
                        caid = result.getString("PARENT_ID");
                    } else {
                        qrpath.add(qpe2);
                        qrpath.add(qpe1);
                    }
                } else {
                    qrpath.add(qpe1);
                }
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException e) {
                        LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                    }
                }
            }
            if (!caid.equals(Constants.ROOT_PARENT_UUID) && !(id = this.getIdentifier(caid)).equals("00exo0jcr0root0uuid0000000000000")) continue;
            if (id.equals("00exo0jcr0root0uuid0000000000000")) {
                qrpath.add(Constants.ROOT_PATH.getEntries()[0]);
            }
            isRoot = true;
        } while (!isRoot);
        QPathEntry[] qentries = new QPathEntry[qrpath.size()];
        int qi = 0;
        for (int i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    private void endChanges() throws InvalidItemStateException, RepositoryException {
        this.addChange(-1, -1);
    }

    protected void addChange(int changeType) throws InvalidItemStateException, RepositoryException {
        this.addChange(this.changeStatus & 0x1F, changeType);
    }

    private void setOperationType(int operationType) throws InvalidItemStateException, RepositoryException {
        this.addChange(operationType, -1);
    }

    private boolean updateBatchingEnabled() {
        return this.containerConfig.batchSize > 1;
    }

    private void addChange(int operationType, int changeType) throws InvalidItemStateException, RepositoryException {
        if (!this.updateBatchingEnabled()) {
            return;
        }
        boolean executeBatch = false;
        int currentChangeStatus = this.changeStatus;
        List<ItemData> pendingChanges = null;
        if (operationType != -1) {
            if (currentChangeStatus == 0) {
                this.changeStatus = operationType;
                return;
            }
            if (operationType == (currentChangeStatus & 0x1F)) {
                if (changeType == -1) {
                    return;
                }
                boolean bl = executeBatch = ++this.changeCount >= this.containerConfig.batchSize;
                if (executeBatch) {
                    this.changeStatus = currentChangeStatus & 0x1F;
                    this.changeCount = 0;
                    currentChangeStatus |= changeType;
                } else {
                    this.changeStatus |= changeType;
                }
            } else {
                executeBatch = true;
                this.changeStatus = operationType;
                this.changeCount = 0;
                pendingChanges = this.currentItems.get(changeType);
            }
        } else {
            boolean bl = executeBatch = this.changeCount > 0;
            if (executeBatch) {
                this.changeStatus = 0;
                this.changeCount = 0;
            }
        }
        if (executeBatch) {
            int currentChange = 0;
            try {
                int i;
                int[] results;
                if ((currentChangeStatus & 0x8000) > 0) {
                    currentChange = 32768;
                    this.deleteValue.executeBatch();
                }
                if ((currentChangeStatus & 0x10000) > 0) {
                    currentChange = 65536;
                    this.deleteValueDataByOrderNum.executeBatch();
                }
                if ((currentChangeStatus & 0x4000) > 0) {
                    currentChange = 16384;
                    this.deleteReference.executeBatch();
                }
                if ((currentChangeStatus & 0x20000) > 0) {
                    currentChange = 131072;
                    this.deleteReferenceByOrderNum.executeBatch();
                }
                if ((currentChangeStatus & 0x2000) > 0) {
                    currentChange = 8192;
                    results = this.deleteItem.executeBatch();
                    for (i = 0; i < results.length; ++i) {
                        if (results[i] != 0) continue;
                        ItemData data = this.getCurrentItem(currentChange, i, FAKE_NODE);
                        if (data == FAKE_NODE) {
                            throw new RepositoryException("Current item cannot be found");
                        }
                        throw new JCRInvalidItemStateException("(delete) " + (data.isNode() ? "Node" : "Property") + " not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 4);
                    }
                }
                if ((currentChangeStatus & 0x1000) > 0) {
                    currentChange = 4096;
                    this.updateReference.executeBatch();
                }
                if ((currentChangeStatus & 0x800) > 0) {
                    currentChange = 2048;
                    this.updateValue.executeBatch();
                }
                if ((currentChangeStatus & 0x400) > 0) {
                    currentChange = 1024;
                    results = this.updateProperty.executeBatch();
                    for (i = 0; i < results.length; ++i) {
                        if (results[i] != 0) continue;
                        ItemData data = this.getCurrentItem(currentChange, i, FAKE_PROPERTY);
                        if (data == FAKE_PROPERTY) {
                            throw new RepositoryException("Current item cannot be found");
                        }
                        throw new JCRInvalidItemStateException("(update) Property not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 2);
                    }
                }
                if ((currentChangeStatus & 0x200) > 0) {
                    currentChange = 512;
                    results = this.updateNode.executeBatch();
                    for (i = 0; i < results.length; ++i) {
                        if (results[i] != 0) continue;
                        ItemData data = this.getCurrentItem(currentChange, i, FAKE_NODE);
                        if (data == FAKE_NODE) {
                            throw new RepositoryException("Current item cannot be found");
                        }
                        throw new JCRInvalidItemStateException("(update) Node not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 2);
                    }
                }
                if ((currentChangeStatus & 0x40000) > 0) {
                    currentChange = 262144;
                    results = this.renameNode.executeBatch();
                    for (i = 0; i < results.length; ++i) {
                        if (results[i] != 0) continue;
                        ItemData data = this.getCurrentItem(currentChange, i, FAKE_NODE);
                        if (data == FAKE_NODE) {
                            throw new RepositoryException("Current item cannot be found");
                        }
                        throw new JCRInvalidItemStateException("(rename) Node not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), 32);
                    }
                }
                if ((currentChangeStatus & 0x20) > 0) {
                    currentChange = 32;
                    this.insertNode.executeBatch();
                }
                if ((currentChangeStatus & 0x40) > 0) {
                    currentChange = 64;
                    this.insertProperty.executeBatch();
                }
                if ((currentChangeStatus & 0x80) > 0) {
                    currentChange = 128;
                    this.insertReference.executeBatch();
                }
                if ((currentChangeStatus & 0x100) > 0) {
                    currentChange = 256;
                    this.insertValue.executeBatch();
                }
            }
            catch (SQLException e) {
                int index = -1;
                if (e instanceof BatchUpdateException) {
                    int[] results = ((BatchUpdateException)e).getUpdateCounts();
                    int length = results.length;
                    for (int i = 0; i < length; ++i) {
                        int res = results[i];
                        if (res != -3) continue;
                        index = i;
                        break;
                    }
                    if (index == -1) {
                        index = results.length - 1;
                    }
                }
                switch (currentChange) {
                    case 32: {
                        this.exceptionHandler.handleAddException(e, this.getCurrentItem(currentChange, index, FAKE_NODE));
                        break;
                    }
                    case 64: {
                        this.exceptionHandler.handleAddException(e, this.getCurrentItem(currentChange, index, FAKE_PROPERTY));
                        break;
                    }
                    case 128: {
                        ItemData data = this.getCurrentItem(currentChange, index, FAKE_PROPERTY);
                        throw new RepositoryException("Can't read REFERENCE property (" + data.getQPath() + " " + data.getIdentifier() + ") value: " + e.getMessage(), (Throwable)e);
                    }
                    case 256: {
                        this.exceptionHandler.handleAddException(e, this.getCurrentItem(currentChange, index, FAKE_PROPERTY));
                        break;
                    }
                    case 32768: {
                        this.exceptionHandler.handleDeleteException(e, this.getCurrentItem(currentChange, index, FAKE_PROPERTY));
                        break;
                    }
                    case 65536: {
                        this.exceptionHandler.handleUpdateException(e, this.getCurrentItem(currentChange, index, FAKE_PROPERTY));
                        break;
                    }
                    case 16384: {
                        this.exceptionHandler.handleDeleteException(e, this.getCurrentItem(currentChange, index, FAKE_PROPERTY));
                        break;
                    }
                    case 131072: {
                        this.exceptionHandler.handleDeleteException(e, this.getCurrentItem(currentChange, index, FAKE_PROPERTY));
                        break;
                    }
                    case 8192: {
                        this.exceptionHandler.handleDeleteException(e, this.getCurrentItem(currentChange, index, FAKE_NODE));
                        break;
                    }
                    case 2048: {
                        this.exceptionHandler.handleUpdateException(e, this.getCurrentItem(currentChange, index, FAKE_PROPERTY));
                        break;
                    }
                    case 1024: {
                        this.exceptionHandler.handleUpdateException(e, this.getCurrentItem(currentChange, index, FAKE_PROPERTY));
                        break;
                    }
                    case 512: {
                        this.exceptionHandler.handleUpdateException(e, this.getCurrentItem(currentChange, index, FAKE_NODE));
                        break;
                    }
                    case 262144: {
                        this.exceptionHandler.handleAddException(e, this.getCurrentItem(currentChange, index, FAKE_NODE));
                    }
                }
                throw new RepositoryException((Throwable)e);
            }
            finally {
                this.currentItems.clear();
                if (pendingChanges != null) {
                    this.currentItems.put(changeType, pendingChanges);
                }
            }
        }
    }

    protected void addCurrentItem(int changeType) {
        if (this.updateBatchingEnabled()) {
            List<ItemData> items;
            if (this.currentItems == null) {
                this.currentItems = new HashMap<Integer, List<ItemData>>();
            }
            if ((items = this.currentItems.get(changeType)) == null) {
                items = new ArrayList<ItemData>();
                this.currentItems.put(changeType, items);
            }
            items.add(this.currentItem);
        }
    }

    protected ItemData getCurrentItem(int operationType, int index, ItemData defaultValue) {
        List<ItemData> items;
        if (this.currentItems != null && !this.currentItems.isEmpty() && index >= 0 && (items = this.currentItems.get(operationType)) != null && !items.isEmpty()) {
            return items.get(index);
        }
        return defaultValue;
    }

    protected int executeUpdate(PreparedStatement ps, int changeType) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.updateBatchingEnabled()) {
            this.addCurrentItem(changeType);
            ps.addBatch();
            this.addChange(changeType);
            return 1;
        }
        return ps.executeUpdate();
    }

    @Override
    public void prepare() throws IllegalStateException, RepositoryException {
        this.endChanges();
        super.prepare();
    }

    @Override
    protected void onPreCommit() throws IllegalStateException, RepositoryException {
        if (this.containerConfig.useSequenceForOrderNumber && this.updateSequence && this.localMaxOrderNumber > 0) {
            this.updateSequence();
        }
    }

    @Override
    protected void closeStatements() {
        super.closeStatements();
        try {
            if (this.findACLHolders != null) {
                this.findACLHolders.close();
            }
            if (this.findNodesByParentIdCQ != null) {
                this.findNodesByParentIdCQ.close();
            }
            if (this.findPropertiesByParentIdCQ != null) {
                this.findPropertiesByParentIdCQ.close();
            }
            if (this.findNodeMainPropertiesByParentIdentifierCQ != null) {
                this.findNodeMainPropertiesByParentIdentifierCQ.close();
            }
            if (this.findItemQPathByIdentifierCQ != null) {
                this.findItemQPathByIdentifierCQ.close();
            }
            if (this.findPropertyById != null) {
                this.findPropertyById.close();
            }
            if (this.deleteValueDataByOrderNum != null) {
                this.deleteValueDataByOrderNum.close();
            }
            if (this.deleteReferenceByOrderNum != null) {
                this.deleteReferenceByOrderNum.close();
            }
            if (this.updateReference != null) {
                this.updateReference.close();
            }
            if (this.updateValue != null) {
                this.updateValue.close();
            }
            if (this.findPropertiesByParentIdAndComplexPatternCQ != null) {
                this.findPropertiesByParentIdAndComplexPatternCQ.close();
            }
            if (this.findNodesByParentIdAndComplexPatternCQ != null) {
                this.findNodesByParentIdAndComplexPatternCQ.close();
            }
            if (this.findNodesByParentIdLazilyCQ != null) {
                this.findNodesByParentIdLazilyCQ.close();
            }
            if (this.findLastOrderNumber != null) {
                this.findLastOrderNumber.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
        }
    }

    protected String escapeSpecialChars(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length + 1);
        block5: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    sb.append('%');
                    continue block5;
                }
                case '\'': {
                    sb.append(this.getSingleQuoteEscapeSymbol());
                    sb.append(chars[i]);
                    continue block5;
                }
                case '%': 
                case '_': {
                    sb.append(this.getWildcardEscapeSymbol());
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    protected String escape(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length + 1);
        for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\'': {
                    sb.append(this.getSingleQuoteEscapeSymbol());
                }
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    protected void appendPattern(StringBuilder sb, QPathEntry entry, boolean indexConstraint) {
        String pattern = entry.getAsString(false);
        sb.append("(I.NAME");
        if (pattern.contains("*")) {
            sb.append(" LIKE '");
            sb.append(this.escapeSpecialChars(pattern));
            sb.append("' ESCAPE '");
            sb.append(this.getLikeExpressionEscape());
            sb.append(SINGLE_QUOTE_ESCAPE_PATTERN);
        } else {
            sb.append("='");
            sb.append(this.escape(pattern));
            sb.append(SINGLE_QUOTE_ESCAPE_PATTERN);
        }
        if (indexConstraint && entry.getIndex() != -1) {
            sb.append(" and I.I_INDEX=");
            sb.append(entry.getIndex());
        }
        sb.append(")");
    }

    protected String getSingleQuoteEscapeSymbol() {
        return SINGLE_QUOTE_ESCAPE_PATTERN;
    }

    protected String getWildcardEscapeSymbol() {
        return PATTERN_ESCAPE_STRING;
    }

    protected String getLikeExpressionEscape() {
        return PATTERN_ESCAPE_STRING;
    }

    protected abstract ResultSet findACLHolders() throws SQLException;

    protected abstract ResultSet findItemQPathByIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildNodesByParentIdentifierCQ(String var1, List<QPathEntryFilter> var2) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentIdentifierCQ(String var1, List<QPathEntryFilter> var2) throws SQLException;

    protected abstract ResultSet findNodeMainPropertiesByParentIdentifierCQ(String var1) throws SQLException;

    protected abstract ResultSet findPropertyById(String var1) throws SQLException;

    protected abstract ResultSet findLastOrderNumber(int var1, boolean var2) throws SQLException;

    protected abstract int deleteValueDataByOrderNum(String var1, int var2) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract int deleteReferenceByOrderNum(String var1, int var2) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract int updateValueData(String var1, int var2, InputStream var3, int var4, String var5) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract int addReference(String var1, int var2, String var3) throws SQLException, InvalidItemStateException, RepositoryException;

    protected abstract int updateReference(String var1, int var2, String var3) throws SQLException, InvalidItemStateException, RepositoryException;

    static {
        try {
            FAKE_NODE = new TransientNodeData(QPath.parse("[]unknown"), "unknown", -1, null, null, -1, "unknwon", null);
        }
        catch (IllegalPathException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        try {
            FAKE_PROPERTY = new TransientPropertyData(QPath.parse("[]unknown"), "unknown", -1, -1, "unknwon", false);
        }
        catch (IllegalPathException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }
}

