/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.picocontainer.Startable;

public class LivePortalManagerServiceImpl
implements LivePortalManagerService,
Startable {
    private final String PORTAL_FOLDER = "exo:portalFolder";
    private static final Log LOG = ExoLogger.getLogger((String)LivePortalManagerServiceImpl.class.getName());
    private ConcurrentHashMap<String, String> livePortalPaths = new ConcurrentHashMap();
    private RepositoryService repositoryService;
    private WCMConfigurationService wcmConfigService;

    public LivePortalManagerServiceImpl(WebSchemaConfigService webSchemaConfigService, WCMConfigurationService wcmConfigurationService, RepositoryService repositoryService) {
        this.wcmConfigService = wcmConfigurationService;
        this.repositoryService = repositoryService;
    }

    @Override
    public final Node getLivePortal(SessionProvider sessionProvider, String portalName) throws Exception {
        String currentRepository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
        return this.getLivePortal(sessionProvider, currentRepository, portalName);
    }

    @Override
    public final List<Node> getLivePortals(SessionProvider sessionProvider) throws Exception {
        String currentRepository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
        return this.getLivePortals(sessionProvider, currentRepository);
    }

    @Override
    public final Node getLiveSharedPortal(SessionProvider sessionProvider) throws Exception {
        String currentRepository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
        return this.getLiveSharedPortal(sessionProvider, currentRepository);
    }

    @Override
    public final Node getLivePortal(SessionProvider sessionProvider, String repository, String portalName) throws Exception {
        Node portalsStorage = this.getLivePortalsStorage(sessionProvider);
        return portalsStorage.getNode(portalName);
    }

    @Override
    public final List<Node> getLivePortals(SessionProvider sessionProvider, String repository) throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        Node portalsStorage = this.getLivePortalsStorage(sessionProvider);
        NodeIterator iterator = portalsStorage.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            if (!node.isNodeType("exo:portalFolder")) continue;
            list.add(node);
        }
        return list;
    }

    @Override
    public final Node getLiveSharedPortal(SessionProvider sessionProvider, String repository) throws Exception {
        Node portalsStorage = this.getLivePortalsStorage(sessionProvider);
        String sharePortalName = this.wcmConfigService.getSharedPortalName();
        try {
            return portalsStorage.getNode(sharePortalName);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private Node getLivePortalsStorage(SessionProvider sessionProvider) throws Exception {
        NodeLocation locationEntry = this.wcmConfigService.getLivePortalsLocation();
        String workspace = locationEntry.getWorkspace();
        String portalsStoragePath = locationEntry.getPath();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        return (Node)session.getItem(portalsStoragePath);
    }

    @Override
    public final void addLivePortal(SessionProvider sessionProvider, PortalConfig portalConfig) throws Exception {
        String portalName;
        Node livePortalsStorage = this.getLivePortalsStorage(sessionProvider);
        if (livePortalsStorage.hasNode(portalName = portalConfig.getName())) {
            return;
        }
        ExtendedNode newPortal = (ExtendedNode)livePortalsStorage.addNode(portalName, "exo:portalFolder");
        if (!newPortal.isNodeType("exo:owneable")) {
            newPortal.addMixin("exo:owneable");
        }
        if (newPortal.canAddMixin("metadata:siteMetadata")) {
            newPortal.addMixin("metadata:siteMetadata");
            newPortal.setProperty("siteTitle", portalName);
            newPortal.setProperty("keywords", portalName);
            newPortal.setProperty("robots", "index,follow");
        }
        if (newPortal.canAddMixin("dc:elementSet")) {
            newPortal.addMixin("dc:elementSet");
        }
        newPortal.getSession().save();
        if (this.livePortalPaths.size() == 0) {
            String sharedPortalName = this.wcmConfigService.getSharedPortalName();
            NodeLocation nodeLocation = this.wcmConfigService.getLivePortalsLocation();
            this.livePortalPaths.put(sharedPortalName, nodeLocation.getPath() + "/" + sharedPortalName);
        }
        this.livePortalPaths.put(portalName, newPortal.getPath());
    }

    @Override
    public void removeLivePortal(SessionProvider sessionProvider, PortalConfig portalConfig) throws Exception {
        Node node = this.getLivePortal(sessionProvider, portalConfig.getName());
        Session session = node.getSession();
        node.remove();
        session.save();
        this.livePortalPaths.remove(portalConfig.getName());
    }

    @Override
    public Collection<String> getLivePortalsPath() throws Exception {
        return this.livePortalPaths.values();
    }

    @Override
    public String getPortalNameByPath(String portalPath) throws Exception {
        Set keys = this.livePortalPaths.keySet();
        for (String portalName : keys.toArray(new String[keys.size()])) {
            if (!this.livePortalPaths.get(portalName).equalsIgnoreCase(portalPath)) continue;
            return portalName;
        }
        return null;
    }

    @Override
    public Node getLivePortalByChild(Node childNode) throws Exception {
        for (String portalPath : this.livePortalPaths.values()) {
            if (!childNode.getPath().startsWith(portalPath)) continue;
            return (Node)childNode.getSession().getItem(portalPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Start LivePortalManagementService....");
        }
        Session session = null;
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            NodeLocation nodeLocation = this.wcmConfigService.getLivePortalsLocation();
            session = sessionProvider.getSession(nodeLocation.getWorkspace(), repository);
            String statement = "select * from exo:portalFolder where jcr:path like '" + nodeLocation.getPath() + "/%'";
            Query query = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            while (iterator.hasNext()) {
                Node portalNode = iterator.nextNode();
                this.livePortalPaths.putIfAbsent(portalNode.getName(), portalNode.getPath());
            }
        }
    }

    public void stop() {
    }

    @Override
    public String getPortalPathByName(String portalName) throws Exception {
        return this.livePortalPaths.get(portalName);
    }
}

