/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.SignatureException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.NonSequentialPDFParser;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageNode;
import org.apache.pdfbox.pdmodel.PDPageable;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandlersManager;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDDocument
implements Pageable,
Closeable {
    private static final Log LOG = LogFactory.getLog(PDDocument.class);
    private COSDocument document;
    private PDDocumentInformation documentInformation;
    private PDDocumentCatalog documentCatalog;
    private PDEncryptionDictionary encParameters = null;
    private SecurityHandler securityHandler = null;
    private Map<String, Integer> pageMap = null;
    private boolean allSecurityToBeRemoved = false;
    private Long documentId;
    private BaseParser parser;

    public PDDocument() {
        this.document = new COSDocument();
        COSDictionary trailer = new COSDictionary();
        this.document.setTrailer(trailer);
        COSDictionary rootDictionary = new COSDictionary();
        trailer.setItem(COSName.ROOT, (COSBase)rootDictionary);
        rootDictionary.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        rootDictionary.setItem(COSName.VERSION, (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        rootDictionary.setItem(COSName.PAGES, (COSBase)pages);
        pages.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.KIDS, (COSBase)kidsArray);
        pages.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
    }

    private void generatePageMap() {
        this.pageMap = new HashMap<String, Integer>();
        this.processListOfPageReferences(this.getDocumentCatalog().getPages().getKids());
    }

    private void processListOfPageReferences(List<Object> pageNodes) {
        int numberOfNodes = pageNodes.size();
        for (int i = 0; i < numberOfNodes; ++i) {
            Object pageOrArray = pageNodes.get(i);
            if (pageOrArray instanceof PDPage) {
                COSArray pageArray = ((COSArrayList)((PDPage)pageOrArray).getParent().getKids()).toList();
                this.parseCatalogObject((COSObject)pageArray.get(i));
                continue;
            }
            if (!(pageOrArray instanceof PDPageNode)) continue;
            this.processListOfPageReferences(((PDPageNode)pageOrArray).getKids());
        }
    }

    private void parseCatalogObject(COSObject thePageOrArrayObject) {
        block6: {
            COSBase kidsBase;
            block7: {
                int kidsCount;
                int arrayCount;
                block5: {
                    COSBase arrayCountBase = thePageOrArrayObject.getItem(COSName.COUNT);
                    arrayCount = -1;
                    if (arrayCountBase instanceof COSInteger) {
                        arrayCount = ((COSInteger)arrayCountBase).intValue();
                    }
                    kidsBase = thePageOrArrayObject.getItem(COSName.KIDS);
                    kidsCount = -1;
                    if (kidsBase instanceof COSArray) {
                        kidsCount = ((COSArray)kidsBase).size();
                    }
                    if (arrayCount != -1 && kidsCount != -1) break block5;
                    String objStr = String.valueOf(thePageOrArrayObject.getObjectNumber().intValue());
                    String genStr = String.valueOf(thePageOrArrayObject.getGenerationNumber().intValue());
                    this.getPageMap().put(objStr + "," + genStr, this.getPageMap().size() + 1);
                    break block6;
                }
                if (arrayCount != kidsCount) break block7;
                COSArray kidsArray = (COSArray)kidsBase;
                for (int i = 0; i < kidsArray.size(); ++i) {
                    COSObject thisObject = (COSObject)kidsArray.get(i);
                    String objStr = String.valueOf(thisObject.getObjectNumber().intValue());
                    String genStr = String.valueOf(thisObject.getGenerationNumber().intValue());
                    this.getPageMap().put(objStr + "," + genStr, this.getPageMap().size() + 1);
                }
                break block6;
            }
            COSArray list = null;
            if (kidsBase instanceof COSArray) {
                list = (COSArray)kidsBase;
            }
            if (list == null) break block6;
            for (int arrayCounter = 0; arrayCounter < list.size(); ++arrayCounter) {
                this.parseCatalogObject((COSObject)list.get(arrayCounter));
            }
        }
    }

    public final Map<String, Integer> getPageMap() {
        if (this.pageMap == null) {
            this.generatePageMap();
        }
        return this.pageMap;
    }

    public void addPage(PDPage page) {
        PDPageNode rootPages = this.getDocumentCatalog().getPages();
        rootPages.getKids().add(page);
        page.setParent(rootPages);
        rootPages.updateCount();
    }

    public void addSignature(PDSignature sigObject, SignatureInterface signatureInterface) throws IOException, SignatureException {
        SignatureOptions defaultOptions = new SignatureOptions();
        defaultOptions.setPage(1);
        this.addSignature(sigObject, signatureInterface, defaultOptions);
    }

    public void addSignature(PDSignature sigObject, SignatureInterface signatureInterface, SignatureOptions options) throws IOException, SignatureException {
        COSDocument visualSignature;
        int preferedSignatureSize = options.getPreferedSignatureSize();
        if (preferedSignatureSize > 0) {
            sigObject.setContents(new byte[preferedSignatureSize]);
        } else {
            sigObject.setContents(new byte[9472]);
        }
        sigObject.setByteRange(new int[]{0, 1000000000, 1000000000, 1000000000});
        this.getDocument().setSignatureInterface(signatureInterface);
        PDDocumentCatalog root = this.getDocumentCatalog();
        PDPageNode rootPages = root.getPages();
        ArrayList kids = new ArrayList();
        rootPages.getAllKids(kids);
        int size = (int)rootPages.getCount();
        if (size == 0) {
            throw new SignatureException(5, "The PDF file has no pages");
        }
        PDPage page = options.getPage() > size ? (PDPage)kids.get(size - 1) : (options.getPage() <= 0 ? (PDPage)kids.get(0) : (PDPage)kids.get(options.getPage() - 1));
        PDAcroForm acroForm = root.getAcroForm();
        root.getCOSObject().setNeedToBeUpdate(true);
        if (acroForm == null) {
            acroForm = new PDAcroForm(this);
            root.setAcroForm(acroForm);
        } else {
            acroForm.getCOSObject().setNeedToBeUpdate(true);
        }
        List<PDAnnotation> annotations = page.getAnnotations();
        ArrayList fields = acroForm.getFields();
        PDSignatureField signatureField = null;
        if (fields == null) {
            fields = new ArrayList();
            acroForm.setFields(fields);
        }
        for (PDField pdField : fields) {
            PDSignature signature;
            if (!(pdField instanceof PDSignatureField) || (signature = ((PDSignatureField)pdField).getSignature()) == null || !signature.getDictionary().equals(sigObject.getDictionary())) continue;
            signatureField = (PDSignatureField)pdField;
        }
        if (signatureField == null) {
            signatureField = new PDSignatureField(acroForm);
            signatureField.setSignature(sigObject);
            signatureField.getWidget().setPage(page);
        }
        List acroFormFields = acroForm.getFields();
        COSDictionary acroFormDict = acroForm.getDictionary();
        acroFormDict.setDirect(true);
        acroFormDict.setInt(COSName.SIG_FLAGS, 3);
        boolean checkFields = false;
        for (PDField field : acroFormFields) {
            if (!(field instanceof PDSignatureField) || !((PDSignatureField)field).getCOSObject().equals(signatureField.getCOSObject())) continue;
            checkFields = true;
            signatureField.getCOSObject().setNeedToBeUpdate(true);
            break;
        }
        if (!checkFields) {
            acroFormFields.add(signatureField);
        }
        if ((visualSignature = options.getVisualSignature()) == null) {
            signatureField.getWidget().setRectangle(new PDRectangle());
            PDAppearanceDictionary ap = new PDAppearanceDictionary();
            COSStream apsStream = this.getDocument().createCOSStream();
            apsStream.createUnfilteredStream();
            PDAppearanceStream aps = new PDAppearanceStream(apsStream);
            COSDictionary cosObject = (COSDictionary)aps.getCOSObject();
            cosObject.setItem(COSName.SUBTYPE, (COSBase)COSName.FORM);
            cosObject.setItem(COSName.BBOX, (COSObjectable)new PDRectangle());
            ap.setNormalAppearance(aps);
            ap.getDictionary().setDirect(true);
            signatureField.getWidget().setAppearance(ap);
        } else {
            List<COSObject> cosObjects = visualSignature.getObjects();
            boolean annotNotFound = true;
            boolean sigFieldNotFound = true;
            for (COSObject cosObject : cosObjects) {
                COSDictionary cosBaseDict;
                if (!annotNotFound && !sigFieldNotFound) break;
                COSBase base = cosObject.getObject();
                if (base == null || !(base instanceof COSDictionary)) continue;
                COSBase ft = ((COSDictionary)base).getDictionaryObject(COSName.FT);
                COSBase type = ((COSDictionary)base).getDictionaryObject(COSName.TYPE);
                COSBase apDict = ((COSDictionary)base).getDictionaryObject(COSName.AP);
                if (annotNotFound && COSName.ANNOT.equals(type)) {
                    cosBaseDict = (COSDictionary)base;
                    COSArray rectAry = (COSArray)cosBaseDict.getDictionaryObject(COSName.RECT);
                    PDRectangle rect = new PDRectangle(rectAry);
                    signatureField.getWidget().setRectangle(rect);
                    annotNotFound = false;
                }
                if (!sigFieldNotFound || !COSName.SIG.equals(ft) || apDict == null) continue;
                cosBaseDict = (COSDictionary)base;
                PDAppearanceDictionary ap = new PDAppearanceDictionary((COSDictionary)cosBaseDict.getDictionaryObject(COSName.AP));
                ap.getDictionary().setDirect(true);
                signatureField.getWidget().setAppearance(ap);
                COSBase dr = cosBaseDict.getDictionaryObject(COSName.DR);
                if (dr != null) {
                    dr.setDirect(true);
                    dr.setNeedToBeUpdate(true);
                    acroFormDict.setItem(COSName.DR, dr);
                }
                sigFieldNotFound = false;
            }
            if (annotNotFound || sigFieldNotFound) {
                throw new SignatureException(6, "Could not read all needed objects from template");
            }
        }
        if (annotations == null) {
            annotations = new COSArrayList<PDAnnotation>();
        }
        page.setAnnotations(annotations);
        if (!(annotations instanceof COSArrayList && acroFormFields instanceof COSArrayList && ((COSArrayList)annotations).toList().equals(((COSArrayList)acroFormFields).toList()) || checkFields)) {
            annotations.add(signatureField.getWidget());
        }
        page.getCOSObject().setNeedToBeUpdate(true);
    }

    public void addSignatureField(List<PDSignatureField> sigFields, SignatureInterface signatureInterface, SignatureOptions options) throws IOException, SignatureException {
        PDDocumentCatalog catalog = this.getDocumentCatalog();
        catalog.getCOSObject().setNeedToBeUpdate(true);
        PDAcroForm acroForm = catalog.getAcroForm();
        if (acroForm == null) {
            acroForm = new PDAcroForm(this);
            catalog.setAcroForm(acroForm);
        } else {
            acroForm.getCOSObject().setNeedToBeUpdate(true);
        }
        COSDictionary acroFormDict = acroForm.getDictionary();
        acroFormDict.setDirect(true);
        acroFormDict.setNeedToBeUpdate(true);
        if (acroFormDict.getInt(COSName.SIG_FLAGS) < 1) {
            acroFormDict.setInt(COSName.SIG_FLAGS, 1);
        }
        List field = acroForm.getFields();
        for (PDSignatureField sigField : sigFields) {
            PDSignature sigObject = sigField.getSignature();
            sigField.getCOSObject().setNeedToBeUpdate(true);
            boolean checkFields = false;
            for (Object obj : field) {
                if (!(obj instanceof PDSignatureField) || !((PDSignatureField)obj).getCOSObject().equals(sigField.getCOSObject())) continue;
                checkFields = true;
                sigField.getCOSObject().setNeedToBeUpdate(true);
                break;
            }
            if (!checkFields) {
                field.add(sigField);
            }
            if (sigField.getSignature() == null) continue;
            sigField.getCOSObject().setNeedToBeUpdate(true);
            if (options == null) {
                // empty if block
            }
            this.addSignature(sigField.getSignature(), signatureInterface, options);
        }
    }

    public boolean removePage(PDPage page) {
        PDPageNode parent = page.getParent();
        boolean retval = parent.getKids().remove(page);
        if (retval) {
            this.getDocumentCatalog().getPages().updateCount();
        }
        return retval;
    }

    public boolean removePage(int pageNumber) {
        boolean removed = false;
        List allPages = this.getDocumentCatalog().getAllPages();
        if (allPages.size() > pageNumber) {
            PDPage page = (PDPage)allPages.get(pageNumber);
            removed = this.removePage(page);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDPage importPage(PDPage page) throws IOException {
        PDPage importedPage = new PDPage(new COSDictionary(page.getCOSDictionary()));
        InputStream is = null;
        OutputStream os = null;
        try {
            PDStream src = page.getContents();
            if (src != null) {
                int amountRead;
                PDStream dest = new PDStream(this.document.createCOSStream());
                dest.addCompression();
                importedPage.setContents(dest);
                os = dest.createOutputStream();
                byte[] buf = new byte[10240];
                is = src.createInputStream();
                while ((amountRead = is.read(buf, 0, 10240)) > -1) {
                    os.write(buf, 0, amountRead);
                }
            }
            this.addPage(importedPage);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return importedPage;
    }

    public PDDocument(COSDocument doc) {
        this(doc, null);
    }

    public PDDocument(COSDocument doc, BaseParser usedParser) {
        this.document = doc;
        this.parser = usedParser;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
            if (infoDic == null) {
                infoDic = new COSDictionary();
                trailer.setItem(COSName.INFO, (COSBase)infoDic);
            }
            this.documentInformation = new PDDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(COSName.INFO, (COSBase)info.getDictionary());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSBase dictionary = trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = dictionary instanceof COSDictionary ? new PDDocumentCatalog(this, (COSDictionary)dictionary) : new PDDocumentCatalog(this);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryptionDictionary getEncryptionDictionary() throws IOException {
        if (this.encParameters == null && this.isEncrypted()) {
            this.encParameters = new PDEncryptionDictionary(this.document.getEncryptionDictionary());
        }
        return this.encParameters;
    }

    public void setEncryptionDictionary(PDEncryptionDictionary encDictionary) throws IOException {
        this.encParameters = encDictionary;
    }

    @Deprecated
    public PDSignature getSignatureDictionary() throws IOException {
        return this.getLastSignatureDictionary();
    }

    public PDSignature getLastSignatureDictionary() throws IOException {
        List<PDSignature> signatureDictionaries = this.getSignatureDictionaries();
        int size = signatureDictionaries.size();
        if (size > 0) {
            return signatureDictionaries.get(size - 1);
        }
        return null;
    }

    public List<PDSignatureField> getSignatureFields() throws IOException {
        LinkedList<PDSignatureField> fields = new LinkedList<PDSignatureField>();
        PDAcroForm acroForm = this.getDocumentCatalog().getAcroForm();
        if (acroForm != null) {
            List<COSDictionary> signatureDictionary = this.document.getSignatureFields(false);
            for (COSDictionary dict : signatureDictionary) {
                fields.add(new PDSignatureField(acroForm, dict));
            }
        }
        return fields;
    }

    public List<PDSignature> getSignatureDictionaries() throws IOException {
        List<COSDictionary> signatureDictionary = this.document.getSignatureDictionaries();
        LinkedList<PDSignature> signatures = new LinkedList<PDSignature>();
        for (COSDictionary dict : signatureDictionary) {
            signatures.add(new PDSignature(dict));
        }
        return signatures;
    }

    @Deprecated
    public boolean isUserPassword(String password) throws IOException, CryptographyException {
        return false;
    }

    @Deprecated
    public boolean isOwnerPassword(String password) throws IOException, CryptographyException {
        return false;
    }

    public void decrypt(String password) throws CryptographyException, IOException {
        try {
            StandardDecryptionMaterial m = new StandardDecryptionMaterial(password);
            this.openProtection(m);
        }
        catch (BadSecurityHandlerException e) {
            throw new CryptographyException(e);
        }
    }

    @Deprecated
    public boolean wasDecryptedWithOwnerPassword() {
        return false;
    }

    public void encrypt(String ownerPassword, String userPassword) throws CryptographyException, IOException {
        try {
            StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, userPassword, new AccessPermission());
            this.protect(policy);
        }
        catch (BadSecurityHandlerException e) {
            throw new CryptographyException(e);
        }
    }

    @Deprecated
    public String getOwnerPasswordForEncryption() {
        return null;
    }

    @Deprecated
    public String getUserPasswordForEncryption() {
        return null;
    }

    @Deprecated
    public boolean willEncryptWhenSaving() {
        return false;
    }

    @Deprecated
    public void clearWillEncryptWhenSaving() {
    }

    public static PDDocument load(URL url) throws IOException {
        return PDDocument.load(url.openStream());
    }

    public static PDDocument load(URL url, boolean force) throws IOException {
        return PDDocument.load(url.openStream(), force);
    }

    public static PDDocument load(URL url, RandomAccess scratchFile) throws IOException {
        return PDDocument.load(url.openStream(), scratchFile);
    }

    public static PDDocument load(String filename) throws IOException {
        return PDDocument.load(new FileInputStream(filename));
    }

    public static PDDocument load(String filename, boolean force) throws IOException {
        return PDDocument.load((InputStream)new FileInputStream(filename), force);
    }

    public static PDDocument load(String filename, RandomAccess scratchFile) throws IOException {
        return PDDocument.load((InputStream)new FileInputStream(filename), scratchFile);
    }

    public static PDDocument load(File file) throws IOException {
        return PDDocument.load(new FileInputStream(file));
    }

    public static PDDocument load(File file, RandomAccess scratchFile) throws IOException {
        return PDDocument.load((InputStream)new FileInputStream(file), scratchFile);
    }

    public static PDDocument load(InputStream input) throws IOException {
        return PDDocument.load(input, null);
    }

    public static PDDocument load(InputStream input, boolean force) throws IOException {
        return PDDocument.load(input, null, force);
    }

    public static PDDocument load(InputStream input, RandomAccess scratchFile) throws IOException {
        PDFParser parser = new PDFParser(input, scratchFile);
        parser.parse();
        return parser.getPDDocument();
    }

    public static PDDocument load(InputStream input, RandomAccess scratchFile, boolean force) throws IOException {
        PDFParser parser = new PDFParser(input, scratchFile, force);
        parser.parse();
        return parser.getPDDocument();
    }

    public static PDDocument loadNonSeq(File file, RandomAccess scratchFile) throws IOException {
        return PDDocument.loadNonSeq(file, scratchFile, "");
    }

    public static PDDocument loadNonSeq(File file, RandomAccess scratchFile, String password) throws IOException {
        NonSequentialPDFParser parser = new NonSequentialPDFParser(file, scratchFile, password);
        parser.parse();
        return parser.getPDDocument();
    }

    public static PDDocument loadNonSeq(InputStream input, RandomAccess scratchFile) throws IOException {
        return PDDocument.loadNonSeq(input, scratchFile, "");
    }

    public static PDDocument loadNonSeq(InputStream input, RandomAccess scratchFile, String password) throws IOException {
        NonSequentialPDFParser parser = new NonSequentialPDFParser(input, scratchFile, password);
        parser.parse();
        return parser.getPDDocument();
    }

    public void save(String fileName) throws IOException, COSVisitorException {
        this.save(new File(fileName));
    }

    public void save(File file) throws IOException, COSVisitorException {
        this.save(new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) throws IOException, COSVisitorException {
        this.getDocumentCatalog().getPages().updateCount();
        COSWriter writer = null;
        try {
            writer = new COSWriter(output);
            writer.write(this);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void saveIncremental(String fileName) throws IOException, COSVisitorException {
        this.saveIncremental(new BufferedInputStream(new FileInputStream(fileName)), new BufferedOutputStream(new FileOutputStream(fileName, true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIncremental(InputStream input, OutputStream output) throws IOException, COSVisitorException {
        this.getDocumentCatalog().getPages().updateCount();
        COSWriter writer = null;
        try {
            output.write("\r\n".getBytes("ISO-8859-1"));
            writer = new COSWriter(output, input);
            writer.write(this);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Deprecated
    public int getPageCount() {
        return this.getNumberOfPages();
    }

    @Override
    public int getNumberOfPages() {
        PDDocumentCatalog cat = this.getDocumentCatalog();
        return (int)cat.getPages().getCount();
    }

    @Override
    @Deprecated
    public PageFormat getPageFormat(int pageIndex) {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            return new PDPageable(this, printerJob).getPageFormat(pageIndex);
        }
        catch (PrinterException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Printable getPrintable(int pageIndex) {
        return (Printable)this.getDocumentCatalog().getAllPages().get(pageIndex);
    }

    public void print(PrinterJob printJob) throws PrinterException {
        this.print(printJob, false);
    }

    public void print() throws PrinterException {
        this.print(PrinterJob.getPrinterJob());
    }

    public void silentPrint() throws PrinterException {
        this.silentPrint(PrinterJob.getPrinterJob());
    }

    public void silentPrint(PrinterJob printJob) throws PrinterException {
        this.print(printJob, true);
    }

    private void print(PrinterJob job, boolean silent) throws PrinterException {
        if (job == null) {
            throw new PrinterException("The given printer job is null.");
        }
        job.setPageable(new PDPageable(this, job));
        if (silent || job.printDialog()) {
            job.print();
        }
    }

    @Override
    public void close() throws IOException {
        this.documentCatalog = null;
        this.documentInformation = null;
        this.encParameters = null;
        if (this.pageMap != null) {
            this.pageMap.clear();
            this.pageMap = null;
        }
        this.securityHandler = null;
        if (this.document != null) {
            this.document.close();
            this.document = null;
        }
        if (this.parser != null) {
            this.parser.clearResources();
            this.parser = null;
        }
    }

    public void protect(ProtectionPolicy pp) throws BadSecurityHandlerException {
        SecurityHandler handler;
        this.securityHandler = handler = SecurityHandlersManager.getInstance().getSecurityHandler(pp);
    }

    public void openProtection(DecryptionMaterial pm) throws BadSecurityHandlerException, IOException, CryptographyException {
        PDEncryptionDictionary dict = this.getEncryptionDictionary();
        if (dict.getFilter() == null) {
            throw new RuntimeException("This document does not need to be decrypted");
        }
        this.securityHandler = SecurityHandlersManager.getInstance().getSecurityHandler(dict.getFilter());
        this.securityHandler.decryptDocument(this, pm);
        this.document.dereferenceObjectStreams();
        this.document.setEncryptionDictionary(null);
        this.getDocumentCatalog();
    }

    public AccessPermission getCurrentAccessPermission() {
        if (this.securityHandler == null) {
            if (this.isEncrypted()) {
                LOG.info((Object)"the document has not yet been decrypted, returning access permission for a document owner");
            }
            return AccessPermission.getOwnerAccessPermission();
        }
        return this.securityHandler.getCurrentAccessPermission();
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public boolean setSecurityHandler(SecurityHandler secHandler) {
        if (this.securityHandler == null) {
            this.securityHandler = secHandler;
            return true;
        }
        return false;
    }

    public boolean isAllSecurityToBeRemoved() {
        return this.allSecurityToBeRemoved;
    }

    public void setAllSecurityToBeRemoved(boolean removeAllSecurity) {
        this.allSecurityToBeRemoved = removeAllSecurity;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long docId) {
        this.documentId = docId;
    }
}

