/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.forum.common.utils.AbstractListAccess;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/webui/core/UIPageIterator.gtmpl", events={@EventConfig(listeners={ShowPageActionListener.class})})
public class UIPageIterator<E>
extends UIComponent {
    private AbstractListAccess<E> pageList_ = null;
    private Set<String> selectedItems = new HashSet<String>();

    public void setListAccess(AbstractListAccess<E> pageList, int pageSize) throws Exception {
        this.pageList_ = pageList;
        this.setUserPerPage(pageSize);
    }

    public AbstractListAccess<E> getListAccess() {
        return this.pageList_;
    }

    public int getAvailablePage() throws Exception {
        return this.pageList_.getTotalPages();
    }

    public int getCurrentPage() throws Exception {
        return this.pageList_.getCurrentPage();
    }

    public List<E> getCurrentPageData() throws Exception {
        Object[] items = this.pageList_.load(this.getCurrentPage());
        return Arrays.asList(items);
    }

    public int getAvailable() throws Exception {
        return this.pageList_.getSize();
    }

    public int getFrom() {
        return this.pageList_.getFrom();
    }

    public int getTo() {
        return this.pageList_.getTo();
    }

    public E getObjectInPage(int index) throws Exception {
        return this.getCurrentPageData().get(index);
    }

    public void setCurrentPage(int page) throws Exception {
        this.pageList_.setCurrentPage(page);
    }

    public void setUserPerPage(int userPerPage) throws Exception {
        this.pageList_.initialize(userPerPage, this.getCurrentPage());
    }

    public void setSelectedItem(String key, boolean value) {
        if (!value && this.selectedItems.contains(key)) {
            this.selectedItems.remove(key);
        } else if (value) {
            this.selectedItems.add(key);
        }
    }

    public Set<String> getSelectedItems() {
        return this.selectedItems;
    }

    public boolean isSelectedItem(String key) {
        return this.selectedItems.contains(key);
    }

    public static class ShowPageActionListener
    extends EventListener<UIPageIterator<?>> {
        public void execute(Event<UIPageIterator<?>> event) throws Exception {
            UIPageIterator uiPageIterator = (UIPageIterator)((Object)event.getSource());
            int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiPageIterator.setCurrentPage(page);
            UIComponent parent = uiPageIterator.getParent();
            if (parent == null) {
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(parent);
            parent.broadcast(event, event.getExecutionPhase());
        }
    }
}

