/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.deployment.staxnav;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.gatein.common.i18n.LocaleFormat;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.io.IOTools;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.util.ConversionException;
import org.gatein.pc.api.LifeCyclePhase;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.TransportGuarantee;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.portlet.impl.deployment.DeploymentException;
import org.gatein.pc.portlet.impl.deployment.staxnav.Element;
import org.gatein.pc.portlet.impl.deployment.xml.XSD;
import org.gatein.pc.portlet.impl.metadata.CustomPortletModeMetaData;
import org.gatein.pc.portlet.impl.metadata.CustomWindowStateMetaData;
import org.gatein.pc.portlet.impl.metadata.ListenerMetaData;
import org.gatein.pc.portlet.impl.metadata.PortletApplication20MetaData;
import org.gatein.pc.portlet.impl.metadata.PublicRenderParameterMetaData;
import org.gatein.pc.portlet.impl.metadata.UserAttributeMetaData;
import org.gatein.pc.portlet.impl.metadata.common.ContainerRuntimeMetaData;
import org.gatein.pc.portlet.impl.metadata.common.InitParamMetaData;
import org.gatein.pc.portlet.impl.metadata.event.EventDefinitionMetaData;
import org.gatein.pc.portlet.impl.metadata.event.EventDefinitionReferenceMetaData;
import org.gatein.pc.portlet.impl.metadata.filter.FilterMappingMetaData;
import org.gatein.pc.portlet.impl.metadata.filter.FilterMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletCacheScopeEnum;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletInfoMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletModeMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletPreferenceMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.PortletPreferencesMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.SecurityRoleRefMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.SupportedLocaleMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.SupportsMetaData;
import org.gatein.pc.portlet.impl.metadata.portlet.WindowStateMetaData;
import org.gatein.pc.portlet.impl.metadata.security.PortletCollectionMetaData;
import org.gatein.pc.portlet.impl.metadata.security.SecurityConstraintMetaData;
import org.gatein.pc.portlet.impl.metadata.security.UserDataConstraintMetaData;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;
import org.staxnav.StaxNavigatorFactory;
import org.staxnav.ValueType;

public class PortletApplicationMetaDataBuilder {
    private static final Logger log = LoggerFactory.getLogger(PortletApplicationMetaDataBuilder.class);
    private static final QName XML_LANG = new QName("http://www.w3.org/XML/1998/namespace", "lang");
    private static final String PORTLET_1_0 = "http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd";
    private static final String PORTLET_2_0 = "http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd";
    private static final EnumSet<Element> NAME_OR_QNAME = EnumSet.of(Element.name, Element.qname);
    private static final ValueType<PortletCacheScopeEnum> PORTLET_CACHE_SCOPE = ValueType.get(PortletCacheScopeEnum.class);
    private static final ValueType<TransportGuarantee> TRANSPORT_GUARANTEE = ValueType.get(TransportGuarantee.class);
    private static final ValueType<LifeCyclePhase> LIFE_CYCLE = new ValueType<LifeCyclePhase>(){

        protected LifeCyclePhase parse(String s) throws Exception {
            if (s.endsWith("_PHASE")) {
                return LifeCyclePhase.valueOf((String)s.substring(0, s.length() - 6));
            }
            throw new IllegalArgumentException("Value " + s + " is not legal");
        }
    };
    private boolean schemaValidation;
    private XMLInputFactory inputFactory;

    public PortletApplicationMetaDataBuilder() {
        this(XMLInputFactory.newInstance(), false);
    }

    public PortletApplicationMetaDataBuilder(XMLInputFactory inputFactory, boolean schemaValidation) throws NullPointerException {
        if (inputFactory == null) {
            throw new NullPointerException("No null xml input factory allowed");
        }
        this.inputFactory = inputFactory;
        this.schemaValidation = schemaValidation;
    }

    public boolean getSchemaValidation() {
        return this.schemaValidation;
    }

    public void setSchemaValidation(boolean schemaValidation) {
        this.schemaValidation = schemaValidation;
    }

    public PortletApplication20MetaData build(InputStream is) throws DeploymentException {
        QName name;
        int version;
        byte[] bytes = null;
        if (this.schemaValidation) {
            try {
                bytes = IOTools.getBytes((InputStream)is);
                is = new ByteArrayInputStream(bytes);
            }
            catch (IOException e) {
                throw new DeploymentException("Could not read portlet.xml descriptor", e);
            }
        }
        PortletApplication20MetaData md = new PortletApplication20MetaData();
        this.inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        StaxNavigator nav = null;
        try {
            XMLStreamReader stream = this.inputFactory.createXMLStreamReader(is);
            nav = StaxNavigatorFactory.create((Naming)new Naming.Enumerated.Simple(Element.class, null), (XMLStreamReader)stream);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException("Could not create a STAX reader", e);
        }
        nav.setTrimContent(true);
        QName qname = nav.getQName();
        String rootNS = qname.getNamespaceURI();
        if (PORTLET_1_0.equals(rootNS)) {
            md.setVersion("1.0");
            version = 1;
        } else if (PORTLET_2_0.equals(rootNS)) {
            md.setVersion("2.0");
            version = 2;
        } else {
            throw new StaxNavException("Illegal portlet xml namespace " + rootNS);
        }
        if (this.schemaValidation) {
            Iterator xsd = version == 1 ? XSD.PORTLET_1_0 : XSD.PORTLET_2_0;
            try {
                ((XSD)((Object)xsd)).validate(new StreamSource(new ByteArrayInputStream(bytes)));
            }
            catch (Exception e) {
                throw new DeploymentException("The portlet.xml file is not valid XML", e);
            }
        }
        assert (Element.portlet_app == nav.getName());
        if (nav.child() == null) {
            return md;
        }
        for (StaxNavigator portletNav : nav.fork((Object)Element.portlet)) {
            PortletMetaData portletMD = new PortletMetaData();
            portletMD.setId(portletNav.getAttribute("id"));
            portletMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)portletNav, Element.description));
            portletMD.setPortletName(this.getContent((StaxNavigator<Element>)portletNav, Element.portlet_name));
            portletMD.setDisplayName(this.readLocalizedString((StaxNavigator<Element>)portletNav, Element.display_name));
            portletMD.setPortletClass(this.getContent((StaxNavigator<Element>)portletNav, Element.portlet_class));
            for (InitParamMetaData initParamMD : this.readInitParams((StaxNavigator<Element>)portletNav)) {
                portletMD.addInitParam(initParamMD);
            }
            if (portletNav.next((Object)Element.expiration_cache)) {
                portletMD.setExpirationCache(Integer.parseInt(portletNav.getContent()));
            }
            if (portletNav.next((Object)Element.cache_scope)) {
                portletMD.setCacheScope(PortletCacheScopeEnum.valueOf(portletNav.getContent()));
            }
            while (portletNav.next((Object)Element.supports)) {
                SupportsMetaData supportsMD = new SupportsMetaData();
                supportsMD.setId(portletNav.getAttribute("id"));
                supportsMD.setMimeType(this.getContent((StaxNavigator<Element>)portletNav, Element.mime_type));
                while (portletNav.next((Object)Element.portlet_mode)) {
                    PortletModeMetaData portletModeMD = new PortletModeMetaData();
                    portletModeMD.setPortletMode(Mode.create((String)portletNav.getContent()));
                    supportsMD.addPortletMode(portletModeMD);
                }
                while (portletNav.next((Object)Element.window_state)) {
                    WindowStateMetaData windowStateMD = new WindowStateMetaData();
                    windowStateMD.setWindowState(WindowState.create((String)portletNav.getContent()));
                    supportsMD.addWindowState(windowStateMD);
                }
                portletMD.addSupport(supportsMD);
            }
            while (portletNav.next((Object)Element.supported_locale)) {
                SupportedLocaleMetaData supportedLocaleMD = new SupportedLocaleMetaData();
                supportedLocaleMD.setLocale(portletNav.getContent());
                portletMD.addSupportedLocale(supportedLocaleMD);
            }
            if (portletNav.next((Object)Element.resource_bundle)) {
                portletMD.setResourceBundle(portletNav.getContent());
            }
            if (portletNav.next((Object)Element.portlet_info)) {
                PortletInfoMetaData portletInfoMD = new PortletInfoMetaData();
                if (portletNav.next((Object)Element.title)) {
                    portletInfoMD.setTitle(portletNav.getContent());
                }
                if (portletNav.next((Object)Element.short_title)) {
                    portletInfoMD.setShortTitle(portletNav.getContent());
                }
                if (portletNav.next((Object)Element.keywords)) {
                    portletInfoMD.setKeywords(portletNav.getContent());
                }
                portletMD.setPortletInfo(portletInfoMD);
            }
            if (portletNav.next((Object)Element.portlet_preferences)) {
                PortletPreferencesMetaData portletPreferencesMD = new PortletPreferencesMetaData();
                while (portletNav.next((Object)Element.preference)) {
                    PortletPreferenceMetaData portletPreferenceMD = new PortletPreferenceMetaData();
                    portletPreferenceMD.setName(this.getContent((StaxNavigator<Element>)portletNav, Element.name));
                    while (portletNav.next((Object)Element.value)) {
                        portletPreferenceMD.addValue(portletNav.getContent());
                    }
                    if (portletNav.next((Object)Element.read_only)) {
                        portletPreferenceMD.setReadOnly((Boolean)portletNav.parseContent(ValueType.BOOLEAN));
                    }
                    portletPreferencesMD.addPortletPreference(portletPreferenceMD);
                }
                if (portletNav.next((Object)Element.preferences_validator)) {
                    portletPreferencesMD.setPreferenceValidator(portletNav.getContent());
                }
                portletMD.setPortletPreferences(portletPreferencesMD);
            }
            while (portletNav.next((Object)Element.security_role_ref)) {
                SecurityRoleRefMetaData securityRoleRefMD = new SecurityRoleRefMetaData();
                securityRoleRefMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)portletNav, Element.description));
                securityRoleRefMD.setRoleName(this.getContent((StaxNavigator<Element>)portletNav, Element.role_name));
                if (portletNav.next((Object)Element.role_link)) {
                    securityRoleRefMD.setRoleLink(portletNav.getContent());
                }
                portletMD.addSecurityRoleRef(securityRoleRefMD);
            }
            while (portletNav.next((Object)Element.supported_processing_event) || portletNav.next((Object)Element.supported_publishing_event)) {
                boolean processing = portletNav.getName() == Element.supported_processing_event;
                EventDefinitionReferenceMetaData eventDefinitionReferenceMD = new EventDefinitionReferenceMetaData();
                switch ((Element)((Object)portletNav.next(NAME_OR_QNAME))) {
                    case name: {
                        eventDefinitionReferenceMD.setName(portletNav.getContent());
                        break;
                    }
                    case qname: {
                        eventDefinitionReferenceMD.setQname(this.readQName((StaxNavigator<Element>)portletNav));
                    }
                }
                if (processing) {
                    portletMD.addSupportedProcessingEvent(eventDefinitionReferenceMD);
                    continue;
                }
                portletMD.addSupportedPublishingEvent(eventDefinitionReferenceMD);
            }
            while (portletNav.next((Object)Element.supported_public_render_parameter)) {
                portletMD.addSupportedPublicRenderParameter(portletNav.getContent());
            }
            while (portletNav.next((Object)Element.container_runtime_option)) {
                ContainerRuntimeMetaData containerRuntimeOptionMD = new ContainerRuntimeMetaData();
                containerRuntimeOptionMD.setName(this.getContent((StaxNavigator<Element>)portletNav, Element.name));
                while (portletNav.next((Object)Element.value)) {
                    containerRuntimeOptionMD.addValue(portletNav.getContent());
                }
                portletMD.addContainerRuntime(containerRuntimeOptionMD);
            }
            md.addPortlet(portletMD);
        }
        for (StaxNavigator customPortletModeNav : nav.fork((Object)Element.custom_portlet_mode)) {
            CustomPortletModeMetaData customPortletModeMD = new CustomPortletModeMetaData();
            customPortletModeMD.setId(customPortletModeNav.getAttribute("id"));
            customPortletModeMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)customPortletModeNav, Element.description));
            customPortletModeMD.setPortletMode(this.getContent((StaxNavigator<Element>)customPortletModeNav, Element.portlet_mode));
            if (customPortletModeNav.next((Object)Element.portal_managed)) {
                customPortletModeMD.setPortalManaged((Boolean)customPortletModeNav.parseContent(ValueType.BOOLEAN));
            }
            md.addCustomPortletMode(customPortletModeMD);
        }
        for (StaxNavigator customWindowStateNav : nav.fork((Object)Element.custom_window_state)) {
            CustomWindowStateMetaData customWindowStateMD = new CustomWindowStateMetaData();
            customWindowStateMD.setId(customWindowStateNav.getAttribute("id"));
            customWindowStateMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)customWindowStateNav, Element.description));
            customWindowStateMD.setWindowState(this.getContent((StaxNavigator<Element>)customWindowStateNav, Element.window_state));
            md.addCustomWindowState(customWindowStateMD);
        }
        for (StaxNavigator userAttributeNav : nav.fork((Object)Element.user_attribute)) {
            UserAttributeMetaData userAttributeMD = new UserAttributeMetaData();
            userAttributeMD.setId(userAttributeNav.getAttribute("id"));
            userAttributeMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)userAttributeNav, Element.description));
            userAttributeMD.setName(this.getContent((StaxNavigator<Element>)userAttributeNav, Element.name));
            md.addUserAttribute(userAttributeMD);
        }
        for (StaxNavigator securityConstraintNav : nav.fork((Object)Element.security_constraint)) {
            SecurityConstraintMetaData securityConstraintMD = new SecurityConstraintMetaData();
            securityConstraintMD.setId(securityConstraintNav.getAttribute("id"));
            securityConstraintMD.setDisplayName(this.readLocalizedString((StaxNavigator<Element>)securityConstraintNav, Element.display_name));
            if (securityConstraintNav.next() != Element.portlet_collection) {
                throw new StaxNavException(nav.getLocation(), "Was expecting a portlet-collection element instead of " + securityConstraintNav.getName());
            }
            PortletCollectionMetaData portletCollectionMD = new PortletCollectionMetaData();
            while (securityConstraintNav.next((Object)Element.portlet_name)) {
                portletCollectionMD.addPortletname(securityConstraintNav.getContent());
            }
            securityConstraintMD.setPortletList(portletCollectionMD);
            if (securityConstraintNav.next() != Element.user_data_constraint) {
                throw new StaxNavException(nav.getLocation(), "Was expecting a security-constraint element instead of " + securityConstraintNav.getName());
            }
            UserDataConstraintMetaData userDataConstraintMD = new UserDataConstraintMetaData();
            userDataConstraintMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)securityConstraintNav, Element.description));
            if (securityConstraintNav.next() != Element.transport_guarantee) {
                throw new StaxNavException(nav.getLocation(), "Was expecting a transport-guarantee element instead of " + securityConstraintNav.getName());
            }
            userDataConstraintMD.setTransportGuarantee((TransportGuarantee)securityConstraintNav.parseContent(TRANSPORT_GUARANTEE));
            securityConstraintMD.setUserDataConstraint(userDataConstraintMD);
            md.addSecurityConstraint(securityConstraintMD);
        }
        if (nav.sibling((Object)Element.resource_bundle)) {
            md.setResourceBundle(nav.getContent());
            nav.next();
        }
        for (StaxNavigator filterNav : nav.fork((Object)Element.filter)) {
            if (version < 2) {
                throw new DeploymentException("Cannot declare filter with http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd descriptor");
            }
            FilterMetaData filterMD = new FilterMetaData();
            filterMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)filterNav, Element.description));
            filterMD.setDisplayName(this.readLocalizedString((StaxNavigator<Element>)filterNav, Element.display_name));
            filterMD.setFilterName(this.getContent((StaxNavigator<Element>)filterNav, Element.filter_name));
            filterMD.setFilterClass(this.getContent((StaxNavigator<Element>)filterNav, Element.filter_class));
            while (filterNav.next((Object)Element.lifecycle)) {
                filterMD.addLifecycle((LifeCyclePhase)filterNav.parseContent(LIFE_CYCLE));
            }
            for (InitParamMetaData initParamMD : this.readInitParams((StaxNavigator<Element>)filterNav)) {
                filterMD.addInitParam(initParamMD);
            }
            md.addFilter(filterMD);
        }
        for (StaxNavigator filterMappingNav : nav.fork((Object)Element.filter_mapping)) {
            if (version < 2) {
                throw new DeploymentException("Cannot declare filter mapping with http://java.sun.com/xml/ns/portlet/portlet-app_1_0.xsd descriptor");
            }
            FilterMappingMetaData filterMappingMD = new FilterMappingMetaData();
            filterMappingMD.setName(this.getContent((StaxNavigator<Element>)filterMappingNav, Element.filter_name));
            while (filterMappingNav.next((Object)Element.portlet_name)) {
                filterMappingMD.addPortletName(filterMappingNav.getContent());
            }
            md.addFilterMapping(filterMappingMD);
        }
        if (nav.find((Object)Element.default_namespace)) {
            String val = nav.getContent();
            try {
                md.setDefaultNamespace(new URI(val));
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid URI " + val, e);
            }
            nav.next();
        }
        for (StaxNavigator eventDefinitionNav : nav.fork((Object)Element.event_definition)) {
            EventDefinitionMetaData eventDefinitionMD = new EventDefinitionMetaData();
            eventDefinitionMD.setId(eventDefinitionNav.getAttribute("id"));
            eventDefinitionMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)eventDefinitionNav, Element.description));
            switch ((Element)((Object)eventDefinitionNav.next(NAME_OR_QNAME))) {
                case name: {
                    eventDefinitionMD.setName(eventDefinitionNav.getContent());
                    break;
                }
                case qname: {
                    eventDefinitionMD.setQname(this.readQName((StaxNavigator<Element>)eventDefinitionNav));
                }
            }
            while (eventDefinitionNav.next((Object)Element.alias)) {
                name = this.readQName((StaxNavigator<Element>)eventDefinitionNav);
                eventDefinitionMD.addAlias(name);
            }
            if (eventDefinitionNav.next((Object)Element.value_type)) {
                eventDefinitionMD.setValueType(eventDefinitionNav.getContent());
            }
            md.addEventDefinition(eventDefinitionMD);
        }
        for (StaxNavigator publicRenderParameterNav : nav.fork((Object)Element.public_render_parameter)) {
            PublicRenderParameterMetaData publicRenderParameterMD = new PublicRenderParameterMetaData();
            publicRenderParameterMD.setId(publicRenderParameterNav.getAttribute("id"));
            publicRenderParameterMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)publicRenderParameterNav, Element.description));
            publicRenderParameterMD.setIdentifier(this.getContent((StaxNavigator<Element>)publicRenderParameterNav, Element.identifier));
            switch ((Element)((Object)publicRenderParameterNav.next(NAME_OR_QNAME))) {
                case name: {
                    publicRenderParameterMD.setName(publicRenderParameterNav.getContent());
                    break;
                }
                case qname: {
                    publicRenderParameterMD.setQname(this.readQName((StaxNavigator<Element>)publicRenderParameterNav));
                }
            }
            while (publicRenderParameterNav.next((Object)Element.alias)) {
                name = this.readQName((StaxNavigator<Element>)publicRenderParameterNav);
                publicRenderParameterMD.addAlias(name);
            }
            md.addPublicRenderParameter(publicRenderParameterMD);
        }
        for (StaxNavigator listenerNav : nav.fork((Object)Element.listener)) {
            ListenerMetaData listenerMD = new ListenerMetaData();
            listenerMD.setId(listenerNav.getAttribute("id"));
            listenerMD.setDescription(this.readLocalizedString((StaxNavigator<Element>)listenerNav, Element.description));
            listenerMD.setDisplayName(this.readLocalizedString((StaxNavigator<Element>)listenerNav, Element.display_name));
            listenerMD.setListenerClass(this.getContent((StaxNavigator<Element>)listenerNav, Element.listener_class));
            md.addListener(listenerMD);
        }
        for (StaxNavigator containerRuntimeNav : nav.fork((Object)Element.container_runtime_option)) {
            ContainerRuntimeMetaData containerRuntimeOptionMD = new ContainerRuntimeMetaData();
            containerRuntimeOptionMD.setName(this.getContent((StaxNavigator<Element>)containerRuntimeNav, Element.name));
            while (containerRuntimeNav.next((Object)Element.value)) {
                containerRuntimeOptionMD.addValue(containerRuntimeNav.getContent());
            }
            md.addContainerRuntime(containerRuntimeOptionMD);
        }
        return md;
    }

    private LocalizedString readLocalizedString(StaxNavigator<Element> nav, Element element) throws DeploymentException {
        LinkedHashMap<Locale, String> descriptions = new LinkedHashMap<Locale, String>();
        while (nav.next((Object)element)) {
            String lang = nav.getAttribute(XML_LANG);
            String description = nav.getContent();
            try {
                Locale locale = LocaleFormat.DEFAULT.getLocale(lang == null ? "en" : lang);
                descriptions.put(locale, description);
            }
            catch (ConversionException e) {
                throw new DeploymentException("Invalid locale " + lang + "", e);
            }
        }
        if (descriptions.size() > 0) {
            return new LocalizedString(descriptions, new Locale("en"));
        }
        return null;
    }

    private QName readQName(StaxNavigator<Element> nav) {
        String val = nav.getContent();
        int pos = val.indexOf(58);
        if (pos == -1) {
            return new QName(val);
        }
        String prefix = val.substring(0, pos);
        String localPart = val.substring(pos + 1);
        String uri = nav.getNamespaceByPrefix(prefix);
        if (uri == null) {
            throw new UnsupportedOperationException("todo");
        }
        return new QName(uri, localPart, prefix);
    }

    private Iterable<InitParamMetaData> readInitParams(StaxNavigator<Element> nav) throws DeploymentException {
        List<InitParamMetaData> list = Collections.emptyList();
        while (nav.next((Object)Element.init_param)) {
            InitParamMetaData initParamMD = new InitParamMetaData();
            initParamMD.setId(nav.getAttribute("id"));
            initParamMD.setDescription(this.readLocalizedString(nav, Element.description));
            initParamMD.setName(this.getContent(nav, Element.name));
            initParamMD.setValue(this.getContent(nav, Element.value));
            if (list.isEmpty()) {
                list = new ArrayList<InitParamMetaData>();
            }
            list.add(initParamMD);
        }
        return list;
    }

    private String getContent(StaxNavigator<Element> nav, Element element) {
        if (nav.next((Object)element)) {
            return nav.getContent();
        }
        throw new StaxNavException(nav.getLocation(), "Was expecting elemnt " + (Object)((Object)element) + " to be present");
    }
}

