/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import juzu.PropertyType;

public enum RunMode {
    PROD(false, false, true, true),
    DEV(false, true, false, false),
    LIVE(true, true, false, false);

    public static PropertyType<RunMode> PROPERTY;
    private static final RunMode[] ALL;
    final boolean dynamic;
    final boolean prettyFail;
    final boolean minifyAssets;
    final boolean cacheAssets;
    final String value;

    public static RunMode parse(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("No null string argument accepted");
        }
        for (RunMode runMode : ALL) {
            String name = runMode.name();
            if (!name.equalsIgnoreCase(s)) continue;
            return runMode;
        }
        return null;
    }

    private RunMode(boolean dynamic, boolean prettyFail, boolean cacheAssets, boolean minifyAssets) {
        this.dynamic = dynamic;
        this.prettyFail = prettyFail;
        this.value = this.name().toLowerCase();
        this.cacheAssets = cacheAssets;
        this.minifyAssets = minifyAssets;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isStatic() {
        return !this.dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean getPrettyFail() {
        return this.prettyFail;
    }

    public boolean getCacheAssets() {
        return this.cacheAssets;
    }

    public boolean getMinifyAssets() {
        return this.minifyAssets;
    }

    static {
        PROPERTY = new PropertyType<RunMode>(){};
        ALL = RunMode.values();
    }
}

