/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.subscriptions;

import com.google.api.client.googleapis.subscriptions.StoredSubscription;
import com.google.api.client.googleapis.subscriptions.SubscriptionStore;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemorySubscriptionStore
implements SubscriptionStore {
    private final Lock lock = new ReentrantLock();
    private final SortedMap<String, StoredSubscription> storedSubscriptions = new TreeMap<String, StoredSubscription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSubscription(StoredSubscription subscription) {
        this.lock.lock();
        try {
            this.storedSubscriptions.put(subscription.getId(), subscription);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(StoredSubscription subscription) {
        this.lock.lock();
        try {
            this.storedSubscriptions.remove(subscription.getId());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<StoredSubscription> listSubscriptions() {
        this.lock.lock();
        try {
            Collection<StoredSubscription> collection = Collections.unmodifiableCollection(this.storedSubscriptions.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredSubscription getSubscription(String subscriptionId) {
        this.lock.lock();
        try {
            StoredSubscription storedSubscription = (StoredSubscription)this.storedSubscriptions.get(subscriptionId);
            return storedSubscription;
        }
        finally {
            this.lock.unlock();
        }
    }
}

