/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.web.redirect.implementation;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.PortalRedirect;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.web.redirect.Mapper;
import org.gatein.web.redirect.Redirector;
import org.gatein.web.redirect.api.RedirectKey;
import org.gatein.web.redirect.api.SiteRedirectService;
import org.picocontainer.Startable;

public class SiteRedirectServiceImpl
implements SiteRedirectService,
Startable {
    protected static Logger log = LoggerFactory.getLogger(SiteRedirectServiceImpl.class);
    Redirector redirector;
    Mapper mapper;
    DataStorage dataStorage;

    public SiteRedirectServiceImpl(DataStorage dataStorage, NavigationService navService) throws IOException {
        this.dataStorage = dataStorage;
        this.redirector = new Redirector();
        this.mapper = new Mapper(navService);
    }

    @Override
    public RedirectKey getRedirectSite(String origin, String userAgentString, Map<String, String> deviceProperties) {
        try {
            if (this.redirector != null && this.dataStorage != null) {
                PortalConfig pConfig = this.dataStorage.getPortalConfig(origin);
                if (pConfig != null) {
                    return this.redirector.getRedirectSite(pConfig.getPortalRedirects(), userAgentString, deviceProperties);
                }
                log.warn((Object)("No PortalConfig found for site : " + origin + ". Site redirection cannot be peformed."));
                return null;
            }
            log.warn((Object)("Redirector(" + this.redirector + ") and DataStorage(" + this.dataStorage + ") need to be both be set. Site redirection cannot be performed."));
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Error trying to get site redirect.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getRedirectPath(String origin, String redirect, String originRequestPath) {
        try {
            if (this.mapper != null) {
                PortalConfig pConfig;
                if (originRequestPath == null || originRequestPath.isEmpty()) {
                    originRequestPath = "/";
                }
                if ((pConfig = this.dataStorage.getPortalConfig(origin)) == null || pConfig.getPortalRedirects() == null) {
                    log.warn((Object)("No PortalConfig found for site : " + origin + ". Site redirection cannot be peformed."));
                    return null;
                }
                PortalRedirect pRedirect = null;
                for (PortalRedirect portalRedirect : pConfig.getPortalRedirects()) {
                    if (!portalRedirect.getRedirectSite().equals(redirect)) continue;
                    pRedirect = portalRedirect;
                    break;
                }
                if (pRedirect != null) {
                    String redirectPath = this.mapper.getRedirectPath(origin, redirect, originRequestPath, pRedirect.getMappings());
                    if (redirectPath != null) {
                        if (redirectPath.startsWith("/")) {
                            return redirectPath;
                        }
                        return "/" + redirectPath;
                    }
                    return redirectPath;
                }
                log.debug((Object)("Site '" + origin + "' does not have a redirect configured for site '" + redirect + "'. Cannot perform redirect."));
                return null;
            }
            log.debug((Object)"Mapper not set. Cannot determine node to map to. Returning Null.");
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Error trying to get site redirect path.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, String> getAlternativeSites(String site, boolean onlyEnabled) {
        LinkedHashMap<String, String> siteKeys = new LinkedHashMap<String, String>();
        try {
            if (this.dataStorage != null) {
                PortalConfig portalConfig = this.dataStorage.getPortalConfig(site);
                if (portalConfig != null && portalConfig.getPortalRedirects() != null) {
                    for (PortalRedirect portalRedirect : portalConfig.getPortalRedirects()) {
                        if (onlyEnabled && !portalRedirect.isEnabled()) continue;
                        siteKeys.put(portalRedirect.getName(), portalRedirect.getRedirectSite());
                    }
                }
            } else {
                log.debug((Object)"DataStorage is null. Cannot retrieve the PortalConfig object.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error trying to retrieve alternative sites.", (Throwable)e);
        }
        return siteKeys;
    }

    public void start() {
    }

    public void stop() {
    }
}

