/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client.ext;

import java.util.HashMap;
import java.util.Map;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;

public class TimesyncClientExtension
extends ClientSession.Extension.Adapter {
    private volatile int _lag;
    private volatile int _offset;

    public boolean rcvMeta(ClientSession session, Message.Mutable message) {
        Map sync;
        Map ext = message.getExt(false);
        if (ext != null && (sync = (Map)ext.get("timesync")) != null) {
            long now = System.currentTimeMillis();
            long tc = ((Number)sync.get("tc")).longValue();
            long ts = ((Number)sync.get("ts")).longValue();
            int p = ((Number)sync.get("p")).intValue();
            int l2 = (int)((now - tc - (long)p) / 2L);
            int o2 = (int)(ts - tc - (long)l2);
            this._lag = this._lag == 0 ? l2 : (this._lag + l2) / 2;
            this._offset = this._offset == 0 ? o2 : (this._offset + o2) / 2;
        }
        return true;
    }

    public boolean sendMeta(ClientSession session, Message.Mutable message) {
        Map ext = message.getExt(true);
        long now = System.currentTimeMillis();
        HashMap<String, Number> timesync = new HashMap<String, Number>(3);
        timesync.put("tc", now);
        timesync.put("l", this._lag);
        timesync.put("o", this._offset);
        ext.put("timesync", timesync);
        return true;
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLag() {
        return this._lag;
    }

    public long getServerTime() {
        return System.currentTimeMillis() + (long)this._offset;
    }
}

