/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import org.exoplatform.commons.api.notification.service.storage.MailNotificationStorage;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobSchedulerService;

public class ResumeDigestJobUpgradePlugin
extends UpgradeProductPlugin {
    private JobSchedulerService schedulerService;
    private MailNotificationStorage mailNotificationStorage;
    private static final Log LOG = ExoLogger.getLogger(ResumeDigestJobUpgradePlugin.class);

    public ResumeDigestJobUpgradePlugin(JobSchedulerService schedulerService, MailNotificationStorage mailNotificationStorage, InitParams initParams) {
        super(initParams);
        this.mailNotificationStorage = mailNotificationStorage;
        this.schedulerService = schedulerService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            if (VersionComparator.isAfter((String)oldVersion, (String)"5.2.0") || VersionComparator.isSame((String)oldVersion, (String)"5.2.0")) {
                this.mailNotificationStorage.deleteAllDigests();
            }
            this.schedulerService.resumeJob("NotificationDailyJob", "Notification");
            this.schedulerService.resumeJob("NotificationWeeklyJob", "Notification");
        }
        catch (Exception e) {
            LOG.error((Object)"Error when resuming daily and weekly job", (Throwable)e);
            throw new RuntimeException("An error occurred when resuming daily and weekly job");
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

