/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.filters;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.social.common.xmlprocessor.BaseXMLFilterPlugin;
import org.exoplatform.social.common.xmlprocessor.DOMParser;
import org.exoplatform.social.common.xmlprocessor.Tokenizer;
import org.exoplatform.social.common.xmlprocessor.model.Node;

public class OpenLinkNewTabFilterPlugin
extends BaseXMLFilterPlugin {
    @Override
    public Object doFilter(Object input) {
        if (input instanceof String) {
            return this.filterLinkTags((String)input);
        }
        return input;
    }

    private String filterLinkTags(String xmlString) {
        List<String> xmlTokens = Tokenizer.tokenize(xmlString);
        Node rootNode = DOMParser.createDOMTree(xmlTokens);
        this.nodeFilter(rootNode);
        return rootNode.toString();
    }

    private void nodeFilter(Node currentNode) {
        if ("a".equalsIgnoreCase(currentNode.getTitle())) {
            String target = currentNode.getAttributes().get("target");
            if (target == null || !"_blank".equalsIgnoreCase(target)) {
                currentNode.getAttributes().put("target", "_blank");
            }
            return;
        }
        LinkedList<Node> currentChildNode = currentNode.getChildNodes();
        for (int i = 0; i < currentChildNode.size(); ++i) {
            this.nodeFilter(currentChildNode.get(i));
        }
    }
}

