/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class SpaceESListenerImpl
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceESListenerImpl.class);

    @Override
    public void spaceCreated(SpaceLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getSpace().getId();
        LOG.info("Notifying indexing service for space creation id={}", new Object[]{id});
        indexingService.index("space", id);
    }

    @Override
    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space description");
    }

    @Override
    public void spaceRemoved(SpaceLifeCycleEvent event) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getSpace().getId();
        LOG.debug("Notifying indexing service for space removal id={}", new Object[]{id});
        indexingService.unindex("space", id);
    }

    @Override
    public void spaceRenamed(SpaceLifeCycleEvent event) {
        this.reindex(event, "space renaming");
    }

    private void reindex(SpaceLifeCycleEvent event, String cause) {
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        String id = event.getSpace().getId();
        LOG.info("Notifying indexing service for {} id={}", new Object[]{cause, id});
        indexingService.reindex("space", id);
    }

    @Override
    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space access edited");
    }

    @Override
    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {
        this.reindex(event, "space registration edited");
    }

    @Override
    public void spaceBannerEdited(SpaceLifeCycleEvent event) {
    }

    @Override
    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    @Override
    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    @Override
    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    @Override
    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    @Override
    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    @Override
    public void joined(SpaceLifeCycleEvent event) {
        this.reindex(event, "space joined");
    }

    @Override
    public void left(SpaceLifeCycleEvent event) {
        this.reindex(event, "space left");
    }

    @Override
    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    @Override
    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    @Override
    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    @Override
    public void addPendingUser(SpaceLifeCycleEvent event) {
    }
}

