/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm.externalstore;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreImportService;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreService;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.idm.EntityMapperUtils;
import org.exoplatform.services.organization.idm.IDMUserListAccess;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.externalstore.IDMExternalStoreListAccess;
import org.gatein.portal.idm.impl.repository.ExoFallbackIdentityStoreRepository;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.query.QueryBuilder;
import org.picketlink.idm.api.query.UserQueryBuilder;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.spi.repository.IdentityStoreRepository;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picocontainer.Startable;

public class PicketLinkIDMExternalStoreService
implements IDMExternalStoreService,
Startable {
    public static final Log LOG = ExoLogger.getLogger(PicketLinkIDMExternalStoreService.class);
    public static final IDMEntityType<org.picketlink.idm.api.User> IDMUSER = new IDMEntityType("Picket Link IDM User", org.picketlink.idm.api.User.class);
    private IDMExternalStoreImportService externalStoreImportService;
    private PicketLinkIDMOrganizationServiceImpl organizationService;
    private ListenerService listenerService;
    private PicketLinkIDMService picketLinkIDMService;
    private ExoFallbackIdentityStoreRepository fallbackStoreRepository = null;
    private boolean updateInformationOnLogin = true;
    private Set<IDMEntityType<?>> entityTypes = Collections.emptySet();
    private Set<String> externalMappedGroups = null;
    private CheckedFunction<CheckedSupplier<?>, ?> executeOnExternalStoreFuntion = null;

    public PicketLinkIDMExternalStoreService(OrganizationService organizationService, PicketLinkIDMService picketLinkIDMService, ListenerService listenerService, InitParams params) {
        this.picketLinkIDMService = picketLinkIDMService;
        this.listenerService = listenerService;
        if (!(organizationService instanceof PicketLinkIDMOrganizationServiceImpl)) {
            LOG.info((Object)"OrganizationService implementation doesn't extend PicketLinkIDMOrganizationServiceImpl. External Store management is disabled.");
            return;
        }
        this.executeOnExternalStoreFuntion = idmOperation -> {
            boolean disableCache;
            boolean bl = disableCache = !this.fallbackStoreRepository.isUseExternalStore();
            if (disableCache) {
                this.fallbackStoreRepository.setUseExternalStore(true);
                this.organizationService.setEnableCache(false);
            }
            try {
                Object var3_3 = idmOperation == null ? null : idmOperation.get();
                return var3_3;
            }
            catch (Exception e) {
                throw new RuntimeException("Operation error on LDAP store", e);
            }
            finally {
                if (disableCache) {
                    this.organizationService.setEnableCache(true);
                    this.fallbackStoreRepository.setUseExternalStore(null);
                }
            }
        };
        this.organizationService = (PicketLinkIDMOrganizationServiceImpl)organizationService;
        if (params != null && params.containsKey((Object)"update.user.onlogin")) {
            this.updateInformationOnLogin = Boolean.parseBoolean(params.getValueParam("update.user.onlogin").getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.organizationService == null) {
            return;
        }
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            IdentitySession identitySession = this.picketLinkIDMService.getIdentitySession();
            if (!(identitySession instanceof IdentitySessionImpl)) {
                LOG.warn((Object)("Can't configure external store, unrecognized IDM session type = " + identitySession.getClass()));
                return;
            }
            IdentityStoreRepository identityStoreRepository = ((IdentitySessionImpl)identitySession).getSessionContext().getIdentityStoreRepository();
            if (!(identityStoreRepository instanceof ExoFallbackIdentityStoreRepository)) {
                LOG.info((Object)("No IDM external store was configured, store type = " + identityStoreRepository.getClass()));
                return;
            }
            this.fallbackStoreRepository = (ExoFallbackIdentityStoreRepository)identityStoreRepository;
            if (this.fallbackStoreRepository == null || !this.fallbackStoreRepository.hasExternalStore()) {
                this.fallbackStoreRepository = null;
                LOG.info((Object)("No IDM external store was configured with store type = " + identityStoreRepository.getClass()));
                return;
            }
            this.organizationService.getConfiguration().setCountPaginatedUsers(true);
            this.organizationService.getConfiguration().setSkipPaginationInMembershipQuery(false);
            Map<String, String> reversedGroupTypeMappings = this.getReversedGroupTypeMappings();
            this.computeManagedIDMEntityTypes(reversedGroupTypeMappings);
            this.initializeGroupTree(reversedGroupTypeMappings);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while configuring external store", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public boolean authenticate(String username, String password) throws Exception {
        this.checkEnabled();
        this.checkManagedType(IDMEntityType.USER);
        org.picketlink.idm.api.User idmUser = this.getEntity(IDMUSER, username);
        if (idmUser == null) {
            return false;
        }
        boolean authenticated = false;
        authenticated = this.validatePassword(idmUser, password);
        if (authenticated) {
            LOG.trace("User '{}' authenticated successfully on external store", new Object[]{username});
            User user = (User)this.getExternalStoreImportService().importEntityToInternalStore(IDMEntityType.USER, (Object)username, this.isUpdateInformationOnLogin(), false);
            if (user == null) {
                authenticated = false;
            } else {
                if (!this.isUpdateInformationOnLogin() && (StringUtils.isBlank((CharSequence)user.getEmail()) || StringUtils.isBlank((CharSequence)user.getFirstName()) || StringUtils.isBlank((CharSequence)user.getLastName()))) {
                    user = (User)this.getExternalStoreImportService().importEntityToInternalStore(IDMEntityType.USER, (Object)username, true, false);
                }
                if (StringUtils.isBlank((CharSequence)user.getFirstName())) {
                    LOG.warn("User '{}' has empty firstName field coming from external store. This may cause some issues, please review IDM configuration", new Object[]{username});
                }
                if (StringUtils.isBlank((CharSequence)user.getLastName())) {
                    LOG.warn("User '{}' has empty lastName field coming from external store. This may cause some issues, please review IDM configuration", new Object[]{username});
                }
                if (StringUtils.isBlank((CharSequence)user.getEmail())) {
                    LOG.warn("User '{}' has empty email field coming from external store. This may cause some issues, please review IDM configuration", new Object[]{username});
                }
                try {
                    this.getListenerService().broadcast("exo.idm.externalStore.user.authenticated", (Object)this, (Object)user);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error while triggering event on user authentication using external store", (Throwable)e);
                }
                if (this.isUpdateInformationOnLogin()) {
                    try {
                        this.getExternalStoreImportService().importEntityToInternalStore(IDMEntityType.USER_MEMBERSHIPS, (Object)username, true, false);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while importing user memberships '" + username + "' from external store"), (Throwable)e);
                    }
                }
            }
        }
        return authenticated;
    }

    public ListAccess<String> getAllOfType(IDMEntityType<?> entityType, LocalDateTime sinceLastModified) throws Exception {
        if (entityType == null) {
            throw new IllegalArgumentException("Entity type is mandatory");
        }
        this.checkEnabled();
        this.checkManagedType(entityType);
        UserQueryBuilder queryBuilder = null;
        IdentitySearchCriteriaImpl searchCriteria = null;
        if (IDMEntityType.USER.equals(entityType)) {
            queryBuilder = this.picketLinkIDMService.getIdentitySession().createUserQueryBuilder();
            if (sinceLastModified != null) {
                String sinceLastModifiedString = LDAP_MODIFICATION_DATE_FORMAT.format(sinceLastModified);
                queryBuilder.attributeValuesFilter("modificationDateSince", new String[]{sinceLastModifiedString});
            }
        } else if (IDMEntityType.GROUP.equals(entityType)) {
            queryBuilder = null;
            searchCriteria = new IdentitySearchCriteriaImpl();
            if (sinceLastModified != null) {
                String sinceLastModifiedString = LDAP_MODIFICATION_DATE_FORMAT.format(sinceLastModified);
                searchCriteria.attributeValuesFilter("modificationDateSince", new String[]{sinceLastModifiedString});
            }
        } else if (IDMEntityType.ROLE.equals(entityType)) {
            queryBuilder = null;
        }
        return new IDMExternalStoreListAccess(this, (OrganizationService)this.organizationService, this.picketLinkIDMService, entityType.getClassType(), (QueryBuilder)queryBuilder, searchCriteria, this.getExternalMappedGroups());
    }

    public ListAccess<User> getAllInternalUsers() throws Exception {
        ListAccess allUsers = this.organizationService.getUserHandler().findAllUsers();
        if (allUsers instanceof IDMUserListAccess) {
            ((IDMUserListAccess)allUsers).setLoadUserAttributes(false);
        }
        return allUsers;
    }

    public boolean isEntityPresent(IDMEntityType<?> entityType, Object entityId) throws Exception {
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is mandatory");
        }
        if (entityId == null || StringUtils.isBlank((CharSequence)entityId.toString())) {
            throw new IllegalArgumentException("entityId is mandatory");
        }
        this.checkEnabled();
        this.checkManagedType(entityType);
        if (IDMUSER.equals(entityType) || IDMEntityType.USER.equals(entityType) || IDMEntityType.USER_PROFILE.equals(entityType) || IDMEntityType.USER_MEMBERSHIPS.equals(entityType)) {
            return this.getIDMUser(entityId.toString()) != null;
        }
        if (IDMEntityType.GROUP_MEMBERSHIPS.equals(entityType) || IDMEntityType.GROUP.equals(entityType)) {
            return (Boolean)this.executeOnExternalStoreFuntion.apply(() -> {
                try {
                    org.picketlink.idm.api.Group jbidGroup = this.organizationService.getJBIDMGroup(entityId.toString());
                    return jbidGroup != null;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
        if (IDMEntityType.ROLE.equals(entityType)) {
            return (Boolean)this.executeOnExternalStoreFuntion.apply(() -> {
                RoleType rt = this.picketLinkIDMService.getIdentitySession().getRoleManager().getRoleType(entityId.toString());
                return rt != null;
            });
        }
        if (IDMEntityType.MEMBERSHIP.equals(entityType)) {
            return this.getMembership(entityId.toString()) != null;
        }
        LOG.warn("unrecognized entity type {}", new Object[]{entityType});
        return false;
    }

    public boolean isEntityModified(IDMEntityType<?> entityType, String username) throws Exception {
        if (!entityType.equals((Object)IDMEntityType.USER)) {
            throw new UnsupportedOperationException("Entity type " + entityType.getClassType().getName() + " is not supported by this operation");
        }
        this.checkEnabled();
        this.checkManagedType(entityType);
        User user = this.organizationService.getUserHandler().findUserByName(username, UserStatus.ANY);
        org.picketlink.idm.api.User idmUser = this.getEntity(IDMUSER, username);
        if (user == null) {
            return idmUser != null;
        }
        if (idmUser == null) {
            return true;
        }
        Map<String, Attribute> attributes = this.getAttributes((IdentityType)idmUser);
        return EntityMapperUtils.populateUser(user, attributes, true);
    }

    public <T> T getEntity(IDMEntityType<T> entityType, Object entityId) throws Exception {
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is mandatory");
        }
        if (entityId == null || StringUtils.isBlank((CharSequence)entityId.toString())) {
            throw new IllegalArgumentException("entityId is mandatory");
        }
        this.checkEnabled();
        this.checkManagedType(entityType);
        if (!this.isEntityPresent(entityType, entityId)) {
            return null;
        }
        if (IDMUSER.equals(entityType)) {
            return entityType.getClassType().cast(this.getIDMUser(entityId.toString()));
        }
        if (IDMEntityType.USER.equals(entityType)) {
            return entityType.getClassType().cast(this.executeOnExternalStoreFuntion.apply(() -> {
                User user = this.organizationService.getUserHandler().findUserByName(entityId.toString(), UserStatus.ANY);
                user.setOriginatingStore("external");
                return user;
            }));
        }
        if (IDMEntityType.USER_PROFILE.equals(entityType)) {
            return entityType.getClassType().cast(this.executeOnExternalStoreFuntion.apply(() -> this.organizationService.getUserProfileHandler().findUserProfileByName(entityId.toString())));
        }
        if (IDMEntityType.USER_MEMBERSHIPS.equals(entityType)) {
            return entityType.getClassType().cast(this.executeOnExternalStoreFuntion.apply(() -> new HashSet(this.organizationService.getMembershipHandler().findMembershipsByUser(entityId.toString()))));
        }
        if (IDMEntityType.GROUP_MEMBERSHIPS.equals(entityType)) {
            return entityType.getClassType().cast(this.executeOnExternalStoreFuntion.apply(() -> {
                Group group = this.organizationService.getGroupHandler().findGroupById(entityId.toString());
                if (group == null) {
                    LOG.warn((Object)("Can't find group with id : " + entityId));
                    return null;
                }
                ListAccess membershipsByGroup = this.organizationService.getMembershipHandler().findAllMembershipsByGroup(group);
                if (membershipsByGroup == null) {
                    return null;
                }
                int size = membershipsByGroup.getSize();
                if (size == 0) {
                    return Collections.emptyList();
                }
                return Arrays.asList(membershipsByGroup.load(0, size));
            }));
        }
        if (IDMEntityType.GROUP.equals(entityType)) {
            return entityType.getClassType().cast(this.executeOnExternalStoreFuntion.apply(() -> {
                Group group = this.organizationService.getGroupHandler().findGroupById(entityId.toString());
                group.setOriginatingStore("external");
                return group;
            }));
        }
        if (IDMEntityType.ROLE.equals(entityType)) {
            return entityType.getClassType().cast(this.executeOnExternalStoreFuntion.apply(() -> this.organizationService.getMembershipTypeHandler().findMembershipType(entityId.toString())));
        }
        if (IDMEntityType.MEMBERSHIP.equals(entityType)) {
            return entityType.getClassType().cast(this.getMembership(entityId.toString()));
        }
        LOG.warn("unrecognized entity type {}", new Object[]{entityType});
        return null;
    }

    public Set<IDMEntityType<?>> getManagedEntityTypes() {
        return this.entityTypes;
    }

    public Object executeOnExternalStore(CheckedSupplier<Object> funtionToExecute) throws Exception {
        return this.executeOnExternalStoreFuntion.apply(() -> funtionToExecute.get());
    }

    public boolean isEnabled() {
        return this.fallbackStoreRepository != null && this.fallbackStoreRepository.hasExternalStore();
    }

    public boolean isUpdateInformationOnLogin() {
        return this.updateInformationOnLogin;
    }

    public void setUpdateInformationOnLogin(boolean updateInformationOnLogin) {
        this.updateInformationOnLogin = updateInformationOnLogin;
    }

    public OrganizationService getOrganizationService() {
        return this.organizationService;
    }

    public ListenerService getListenerService() {
        return this.listenerService;
    }

    public IDMExternalStoreImportService getExternalStoreImportService() {
        if (this.externalStoreImportService == null) {
            this.externalStoreImportService = (IDMExternalStoreImportService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IDMExternalStoreImportService.class);
        }
        return this.externalStoreImportService;
    }

    public ExoFallbackIdentityStoreRepository getFallbackStoreRepository() {
        return this.fallbackStoreRepository;
    }

    public Map<String, String> getReversedGroupTypeMappings() throws Exception {
        HashMap<String, String> reversedGroupTypeMappings = new HashMap<String, String>();
        Map<String, String> groupTypeMappings = this.organizationService.getConfiguration().getGroupTypeMappings();
        Set<String> externalMappedGroups = this.getExternalMappedGroups();
        if (externalMappedGroups != null && !externalMappedGroups.isEmpty()) {
            for (Map.Entry<String, String> groupTypeMappingEntry : groupTypeMappings.entrySet()) {
                reversedGroupTypeMappings.put(groupTypeMappingEntry.getValue(), groupTypeMappingEntry.getKey());
            }
        }
        return reversedGroupTypeMappings;
    }

    public void initializeGroupTree(Map<String, String> reversedGroupTypeMappings) throws Exception {
        Set<String> externalMappedGroups = this.getExternalMappedGroups();
        if (externalMappedGroups != null && !externalMappedGroups.isEmpty()) {
            for (String externalMappedGroup : externalMappedGroups) {
                String groupId = reversedGroupTypeMappings.get(externalMappedGroup);
                if (StringUtils.isBlank((CharSequence)groupId) || groupId.equals("/")) continue;
                groupId = groupId.replace("/*", "");
                Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
                if (group != null || (group = (Group)this.getEntity(IDMEntityType.GROUP, groupId)) != null) continue;
                group = this.organizationService.getGroupHandler().createGroupInstance();
                String groupName = groupId.substring(groupId.lastIndexOf("/") + 1, groupId.length());
                group.setGroupName(groupName);
                group.setLabel(groupName);
                group.setId(groupId);
                Group parentGroup = null;
                if (groupId.lastIndexOf("/") != 0) {
                    String parentId = groupId.substring(0, groupId.lastIndexOf("/"));
                    parentGroup = this.organizationService.getGroupHandler().findGroupById(parentId);
                    if (parentGroup == null) {
                        throw new IllegalStateException("Can't initialize group '" + groupId + "' becaue parent '" + parentId + "' doesn't exist");
                    }
                    group.setParentId(parentId);
                }
                LOG.info("Adding parent LDAP mapped groups : {}", new Object[]{groupId});
                this.organizationService.getGroupHandler().addChild(parentGroup, group, true);
            }
        }
    }

    private Map<String, Attribute> getAttributes(IdentityType identityType) throws Exception {
        return (Map)this.executeOnExternalStoreFuntion.apply(() -> this.picketLinkIDMService.getIdentitySession().getAttributesManager().getAttributes(identityType));
    }

    private void checkManagedType(IDMEntityType<?> entityType) {
        if (this.getManagedEntityTypes() == null || !this.getManagedEntityTypes().contains(entityType)) {
            throw new IllegalStateException("Entity type " + entityType.getClassType().getName() + " is not managed");
        }
    }

    private void computeManagedIDMEntityTypes(Map<String, String> reversedGroupTypeMappings) throws Exception {
        this.entityTypes = (Set)this.executeOnExternalStoreFuntion.apply(() -> {
            FeaturesMetaData supportedFeatures = this.fallbackStoreRepository.getExternalIdentityStore().getSupportedFeatures();
            Set supportedIdentityTypes = supportedFeatures.getSupportedIdentityObjectTypes();
            Set supportedRelationshipTypes = supportedFeatures.getSupportedRelationshipTypes();
            if (supportedIdentityTypes == null || supportedIdentityTypes.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<Object> entityTypes = new HashSet<Object>();
            for (String supportedRelationshipType : supportedRelationshipTypes) {
                if ("JBOSS_IDENTITY_MEMBERSHIP".equals(supportedRelationshipType)) {
                    entityTypes.add(IDMEntityType.MEMBERSHIP);
                    entityTypes.add(IDMEntityType.USER_MEMBERSHIPS);
                    entityTypes.add(IDMEntityType.GROUP_MEMBERSHIPS);
                    continue;
                }
                if ("JBOSS_IDENTITY_ROLE".equals(supportedRelationshipType)) {
                    entityTypes.add(IDMEntityType.ROLE);
                    continue;
                }
                LOG.warn((Object)("unrecognized relationship type {} " + supportedRelationshipType));
            }
            for (String supportedIdentityType : supportedIdentityTypes) {
                if (supportedIdentityType.equals("USER")) {
                    entityTypes.add(IDMEntityType.USER);
                    entityTypes.add(IDMEntityType.USER_PROFILE);
                    entityTypes.add(IDMUSER);
                    continue;
                }
                if (supportedIdentityTypes.contains("GROUP")) {
                    entityTypes.add(IDMEntityType.GROUP);
                    continue;
                }
                if (reversedGroupTypeMappings.containsKey(supportedIdentityType)) {
                    entityTypes.add(IDMEntityType.GROUP);
                    continue;
                }
                LOG.warn("Unrecognized identity type {}, please verify that you added the groups mappings in PicketLinkIDMOrganizationServiceImpl.groupTypeMappings parameter", new Object[]{supportedIdentityType});
            }
            return entityTypes;
        });
    }

    private Set<String> getExternalMappedGroups() throws Exception {
        if (this.externalMappedGroups != null) {
            return this.externalMappedGroups;
        }
        HashSet supportedIdentityObjectTypes = new HashSet(this.fallbackStoreRepository.getExternalIdentityStore().getSupportedFeatures().getSupportedIdentityObjectTypes());
        supportedIdentityObjectTypes.remove("USER");
        this.externalMappedGroups = new HashSet<String>(supportedIdentityObjectTypes);
        return this.externalMappedGroups;
    }

    private Membership getMembership(String id) throws Exception {
        return (Membership)IDMEntityType.MEMBERSHIP.getClassType().cast(this.executeOnExternalStoreFuntion.apply(() -> this.organizationService.getMembershipHandler().findMembership(id)));
    }

    private org.picketlink.idm.api.User getIDMUser(String username) throws Exception {
        return (org.picketlink.idm.api.User)IDMUSER.getClassType().cast(this.executeOnExternalStoreFuntion.apply(() -> {
            IdentitySession identitySession = this.picketLinkIDMService.getIdentitySession();
            return identitySession.getPersistenceManager().findUser(username);
        }));
    }

    private boolean validatePassword(org.picketlink.idm.api.User idmUser, String password) throws Exception {
        return (Boolean)this.executeOnExternalStoreFuntion.apply(() -> this.picketLinkIDMService.getIdentitySession().getAttributesManager().validatePassword(idmUser, password));
    }

    private void checkEnabled() {
        if (!this.isEnabled()) {
            throw new IllegalStateException("LDAP Store is disabled");
        }
    }

    @FunctionalInterface
    public static interface CheckedSupplier<R> {
        public R get() throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

