/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.subscriptions;

import com.google.api.client.googleapis.subscriptions.Notification;
import com.google.api.client.googleapis.subscriptions.NotificationCallback;
import com.google.api.client.googleapis.subscriptions.StoredSubscription;
import com.google.api.client.googleapis.subscriptions.SubscriptionStore;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.Strings;
import java.io.IOException;
import java.io.InputStream;

public final class UnparsedNotification
extends Notification {
    private final InputStream content;
    private final String contentType;

    public UnparsedNotification(String subscriptionId, String topicId, String topicURI, String clientToken, long messageNumber, String eventType, String changeType, String contentType, InputStream unparsedStream) {
        super(subscriptionId, topicId, topicURI, clientToken, messageNumber, eventType, changeType);
        this.contentType = contentType;
        this.content = (InputStream)Preconditions.checkNotNull((Object)unparsedStream);
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final InputStream getContent() {
        return this.content;
    }

    public boolean deliverNotification(SubscriptionStore subscriptionStore) throws IOException {
        StoredSubscription subscription = subscriptionStore.getSubscription((String)Preconditions.checkNotNull((Object)this.getSubscriptionId()));
        if (subscription == null) {
            return false;
        }
        String expectedToken = subscription.getClientToken();
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)expectedToken) || expectedToken.equals(this.getClientToken()) ? 1 : 0) != 0, (String)"Token mismatch for subscription with id=%s -- got=%s expected=%s", (Object[])new Object[]{this.getSubscriptionId(), this.getClientToken(), expectedToken});
        NotificationCallback h = subscription.getNotificationCallback();
        h.handleNotification(subscription, this);
        return true;
    }
}

