/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.SiteBody;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.BodyData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.ModelData;
import org.exoplatform.portal.pom.data.PageData;

public abstract class ModelObject {
    String storageId;
    String storageName;

    public ModelObject(String storageId) {
        this.storageId = storageId;
    }

    protected ModelObject() {
        this.storageId = null;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public abstract ModelData build();

    public static ModelObject build(ModelData data) {
        ApplicationData applicationData;
        ApplicationType type;
        if (data instanceof ContainerData) {
            return new Container((ContainerData)data);
        }
        if (data instanceof PageData) {
            return new Page((PageData)data);
        }
        if (data instanceof BodyData) {
            BodyData bodyData = (BodyData)data;
            switch (bodyData.getType()) {
                case PAGE: {
                    return new PageBody(data.getStorageId());
                }
                case SITE: {
                    return new SiteBody(data.getStorageId());
                }
            }
            throw new AssertionError();
        }
        if (data instanceof ApplicationData && ApplicationType.PORTLET == (type = (applicationData = (ApplicationData)data).getType())) {
            return Application.createPortletApplication(applicationData);
        }
        return null;
    }
}

