/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceMenu;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UIUploadInput;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/UIBannerUploader.gtmpl", events={@EventConfig(listeners={ConfirmActionListener.class})})})
public class UIBannerUploader
extends UIForm {
    protected static final String MSG_MIMETYPE_NOT_ACCEPTED = "UIBannerUploader.msg.mimetype_not_accepted";
    protected static final String MSG_IMAGE_NOT_LOADED = "UIBannerUploader.msg.img_not_loaded";
    protected static final String FIELD_UPLOADER = "BannerUploader";
    protected static final int uploadLimit = 2;
    protected static final String[] ACCEPTED_MIME_TYPES = new String[]{"image/gif", "image/jpeg", "image/jpg", "image/png", "image/x-png", "image/pjpeg"};
    private UIUploadInput uiBannerUploadInput;

    public UIBannerUploader() {
        this(FIELD_UPLOADER);
    }

    public UIBannerUploader(String uploadFieldId) {
        this.uiBannerUploadInput = new UIUploadInput(uploadFieldId, uploadFieldId, 1, 2);
        this.addUIFormInput((UIFormInput)this.uiBannerUploadInput);
        this.setActions(new String[]{"Confirm"});
    }

    protected boolean isAcceptedMimeType(String mimeType) {
        for (String acceptedMimeType : ACCEPTED_MIME_TYPES) {
            if (!mimeType.equals(acceptedMimeType)) continue;
            return true;
        }
        return false;
    }

    public void saveSpaceBanner(BannerAttachment banner) throws Exception {
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        String spaceUrl = Utils.getSpaceUrlByContext();
        Space space = spaceService.getSpaceByUrl(spaceUrl);
        space.setEditor(Utils.getViewerRemoteId());
        space.setBannerAttachment(banner);
        spaceService.updateSpace(space);
        spaceService.updateSpaceBanner(space);
    }

    public void saveUserBanner(BannerAttachment banner) throws Exception {
        Profile p = Utils.getOwnerIdentity().getProfile();
        p.setProperty("banner", (Object)banner);
        p.setListUpdateTypes(Arrays.asList(Profile.UpdateType.BANNER));
        Map props = p.getProperties();
        for (String key : props.keySet()) {
            if (!key.startsWith("banner_")) continue;
            p.removeProperty(key);
        }
        Utils.getIdentityManager().updateProfile(p);
    }

    public UIUploadInput getUiBannerUploadInput() {
        return this.uiBannerUploadInput;
    }

    public static class ConfirmActionListener
    extends EventListener<UIBannerUploader> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIBannerUploader> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIBannerUploader uiBannerUploader = (UIBannerUploader)((Object)event.getSource());
            UIUploadInput uiBannerUploadInput = (UIUploadInput)uiBannerUploader.getChild(UIUploadInput.class);
            if (uiBannerUploadInput.getUploadResources().length < 1) {
                ctx.getUIApplication().addMessage(new ApplicationMessage(UIBannerUploader.MSG_IMAGE_NOT_LOADED, null, 0));
                ctx.addUIComponentToUpdateByAjax((UIComponent)uiBannerUploader);
                return;
            }
            for (UploadResource uploadResource : uiBannerUploadInput.getUploadResources()) {
                if (uploadResource == null) continue;
                try {
                    String fileName = uploadResource.getFileName();
                    if (fileName == null || fileName.length() == 0) continue;
                    String mimeType = uploadResource.getMimeType();
                    if (!uiBannerUploader.isAcceptedMimeType(mimeType)) {
                        ctx.getUIApplication().addMessage(new ApplicationMessage(UIBannerUploader.MSG_MIMETYPE_NOT_ACCEPTED, null, 0));
                        ctx.addUIComponentToUpdateByAjax((UIComponent)uiBannerUploader);
                    } else {
                        FileInputStream uploadedStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
                        BannerAttachment avatarAttachment = new BannerAttachment(null, fileName, mimeType, (InputStream)uploadedStream, null, System.currentTimeMillis());
                        if (uiBannerUploader.getAncestorOfType(UISpaceMenu.class) != null) {
                            uiBannerUploader.saveSpaceBanner(avatarAttachment);
                        } else {
                            uiBannerUploader.saveUserBanner(avatarAttachment);
                        }
                        ctx.addUIComponentToUpdateByAjax(uiBannerUploader.getParent());
                    }
                    return;
                }
                finally {
                    UploadService uploadService = (UploadService)CommonsUtils.getService(UploadService.class);
                    uploadService.removeUploadResource(uploadResource.getUploadId());
                    uiBannerUploadInput.addNewUploadId();
                }
            }
        }
    }
}

