/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.binding;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.GroupSpaceBindingRestResources;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingEntity;

@Path(value="v1/social/groupspacebindings")
@Api(tags={"v1/social/groupspacebindings"}, value="v1/social/groupspacebinding", description="API  to manage the binding between a space and an organization group")
public class GroupSpaceBindingRestResourcesV1
implements GroupSpaceBindingRestResources {
    private SpaceService spaceService;
    private GroupSpaceBindingService groupSpaceBindingService;

    public GroupSpaceBindingRestResourcesV1(SpaceService spaceService, GroupSpaceBindingService groupSpaceBindingService) {
        this.spaceService = spaceService;
        this.groupSpaceBindingService = groupSpaceBindingService;
    }

    @Override
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets list of binding for a space context (space + role in space)", httpMethod="GET", response=Response.class, notes="Returns a list of bindings in the following cases if the authenticated user is a member of space administrator group")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getBindingsBySpaceContext(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @QueryParam(value="spaceId") String spaceId, @ApiParam(value="Role in space (member/manager", required=true) @QueryParam(value="spaceRole") String spaceRole, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of spaces found or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List list = null;
        list = this.groupSpaceBindingService.findGroupSpaceBindingsBySpace(spaceId);
        ArrayList<DataEntity> bindings = new ArrayList<DataEntity>();
        for (GroupSpaceBinding binding : list) {
            GroupSpaceBindingEntity bindingEntity = EntityBuilder.buildEntityFromGroupSpaceBinding(binding);
            bindings.add(bindingEntity.getDataEntity());
        }
        CollectionEntity collectionBinding = new CollectionEntity(bindings, "groupSpaceBinding", offset, limit);
        if (returnSize) {
            collectionBinding.setSize(bindings.size());
        }
        return EntityBuilder.getResponse(collectionBinding, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Save space group bindings", httpMethod="POST", response=Response.class, notes="This method update bindings for a specific space if the authenticated user is a spaces super manager")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error due to data encoding")})
    public Response saveGroupBindings(@Context UriInfo uriInfo, @ApiParam(value="SpaceId of the space", required=true) @QueryParam(value="spaceId") String spaceId, @ApiParam(value="List of space bindings to be updated", required=true) List<GroupSpaceBindingEntity> groupSpaceBindingEntityList) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (spaceId == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        List groupSpaceBindings = groupSpaceBindingEntityList.stream().map(binding -> new GroupSpaceBinding(binding.getId(), binding.getSpaceId(), binding.getGroup())).collect(Collectors.toList());
        this.groupSpaceBindingService.saveGroupSpaceBindings(groupSpaceBindings);
        return EntityBuilder.getResponse("", uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @DELETE
    @Path(value="{spaceId}/{spaceRole}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes all the  binding by space/space role", httpMethod="DELETE", response=Response.class, notes="This method delete all the bindings in the following cases the authenticated user is a spaces super manager")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteSpaceBindings(@Context UriInfo uriInfo, @ApiParam(value="spaceId", required=true) @PathParam(value="spaceId") String spaceId) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.spaceService.isSuperManager(authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.groupSpaceBindingService.deleteAllSpaceBindingsBySpace(spaceId);
        return Response.ok().build();
    }
}

