/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.binding.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingQueue;
import org.exoplatform.social.core.binding.model.UserSpaceBinding;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.GroupSpaceBindingStorage;

public class GroupSpaceBindingServiceImpl
implements GroupSpaceBindingService {
    private static final Log LOG = ExoLogger.getLogger(GroupSpaceBindingServiceImpl.class);
    private static final int USERS_TO_BIND_PAGE_SIZE = 100;
    private GroupSpaceBindingStorage groupSpaceBindingStorage;
    private OrganizationService organizationService;
    private SpaceService spaceService;

    public GroupSpaceBindingServiceImpl(InitParams params, GroupSpaceBindingStorage groupSpaceBindingStorage, OrganizationService organizationService, SpaceService spaceService) throws Exception {
        this.groupSpaceBindingStorage = groupSpaceBindingStorage;
        this.organizationService = organizationService;
        this.spaceService = spaceService;
    }

    @Override
    public GroupSpaceBindingQueue findFirstGroupSpaceBindingQueue() {
        LOG.debug((Object)"Retrieving First GroupSpaceBindingQueue to treat");
        return this.groupSpaceBindingStorage.findFirstGroupSpaceBindingQueue();
    }

    @Override
    public List<GroupSpaceBinding> findGroupSpaceBindingsBySpace(String spaceId) {
        LOG.debug((Object)("Retrieving group/space bindings for space:" + spaceId));
        return this.groupSpaceBindingStorage.findGroupSpaceBindingsBySpace(spaceId);
    }

    @Override
    public List<GroupSpaceBinding> findGroupSpaceBindingsByGroup(String group) {
        LOG.debug((Object)("Retrieving group/space bindings for group:" + group));
        return this.groupSpaceBindingStorage.findGroupSpaceBindingsByGroup(group);
    }

    @Override
    public List<UserSpaceBinding> findUserBindingsBySpace(String spaceId, String userName) {
        LOG.debug((Object)("Retrieving user bindings for member:" + userName + "/" + spaceId));
        return this.groupSpaceBindingStorage.findUserSpaceBindingsBySpace(spaceId, userName);
    }

    @Override
    public List<UserSpaceBinding> findUserBindingsByUser(String userName) {
        LOG.debug((Object)("Retrieving user bindings for member:" + userName));
        return this.groupSpaceBindingStorage.findUserSpaceBindingsByUser(userName);
    }

    @Override
    public List<UserSpaceBinding> findUserBindingsByGroup(String group, String userName) {
        LOG.debug((Object)("Retrieving user bindings for user : " + userName + " with group : " + group));
        return this.groupSpaceBindingStorage.findUserSpaceBindingsByGroup(group, userName);
    }

    @Override
    public void saveUserBindings(List<UserSpaceBinding> userSpaceBindings) {
        LOG.debug("Saving user bindings, ({}) to save", new Object[]{userSpaceBindings.size()});
        try {
            for (UserSpaceBinding userSpaceBinding : userSpaceBindings) {
                this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error Binding" + e));
            throw new RuntimeException("Failed saving user bindings", e);
        }
    }

    @Override
    public void createGroupSpaceBindingQueue(GroupSpaceBindingQueue groupSpaceBindingsQueue) {
        this.groupSpaceBindingStorage.createGroupSpaceBindingQueue(groupSpaceBindingsQueue);
    }

    @Override
    public void deleteGroupSpaceBinding(GroupSpaceBinding groupSpaceBinding) {
        LOG.debug((Object)("Delete binding group :" + groupSpaceBinding.getGroup() + " for space :" + groupSpaceBinding.getSpaceId()));
        for (UserSpaceBinding userSpaceBinding : this.groupSpaceBindingStorage.findUserAllBindingsbyGroup(groupSpaceBinding.getGroup())) {
            this.deleteUserBinding(userSpaceBinding);
        }
        this.groupSpaceBindingStorage.deleteGroupBinding(groupSpaceBinding.getId());
    }

    @Override
    public void deleteUserBinding(UserSpaceBinding userSpaceBinding) {
        boolean hasOtherBindings;
        LOG.debug("Delete user binding for member : {} from ", new Object[]{userSpaceBinding.getUser(), userSpaceBinding.getGroupBinding().getSpaceId()});
        this.groupSpaceBindingStorage.deleteUserBinding(userSpaceBinding.getId());
        boolean bl = hasOtherBindings = this.groupSpaceBindingStorage.getUserBindings(userSpaceBinding.getGroupBinding().getSpaceId(), userSpaceBinding.getUser()).size() > 0;
        if (!hasOtherBindings && !userSpaceBinding.isMemberBefore().booleanValue()) {
            this.spaceService.removeMember(this.spaceService.getSpaceById(userSpaceBinding.getGroupBinding().getSpaceId()), userSpaceBinding.getUser());
        }
    }

    @Override
    public void deleteAllSpaceBindingsBySpace(String spaceId) {
        LOG.debug((Object)("Delete all bindings for space :" + spaceId));
        for (GroupSpaceBinding groupSpaceBinding : this.findGroupSpaceBindingsBySpace(spaceId)) {
            this.deleteGroupSpaceBinding(groupSpaceBinding);
        }
    }

    @Override
    public void deleteAllSpaceBindingsByGroup(String groupId) {
        LOG.debug((Object)("Delete all bindings for group :" + groupId));
        for (GroupSpaceBinding groupSpaceBinding : this.findGroupSpaceBindingsByGroup(groupId)) {
            this.deleteGroupSpaceBinding(groupSpaceBinding);
        }
    }

    @Override
    public List<UserSpaceBinding> getUserBindings(String spaceId, String userName) {
        LOG.debug((Object)("List member binding :" + userName + " space:" + spaceId));
        return this.groupSpaceBindingStorage.getUserBindings(spaceId, userName);
    }

    @Override
    public long countUserBindings(String spaceId, String userName) {
        LOG.debug((Object)("Count member binding :" + userName + " space:" + spaceId));
        return this.groupSpaceBindingStorage.countUserBindings(spaceId, userName);
    }

    @Override
    public void saveGroupSpaceBindings(List<GroupSpaceBinding> groupSpaceBindings) {
        LOG.debug("Saving group space binding between spaceId: {} and groups: {}.", new Object[]{groupSpaceBindings.get(0).getSpaceId(), groupSpaceBindings.toString()});
        try {
            ArrayList boundGroupsAndSpacesList = new ArrayList();
            ArrayList bindingQueueList = new ArrayList();
            groupSpaceBindings.stream().forEach(groupSpaceBinding -> boundGroupsAndSpacesList.add(this.groupSpaceBindingStorage.saveGroupSpaceBinding((GroupSpaceBinding)groupSpaceBinding)));
            boundGroupsAndSpacesList.stream().forEach(groupSpaceBinding -> bindingQueueList.add(new GroupSpaceBindingQueue((GroupSpaceBinding)groupSpaceBinding, GroupSpaceBindingQueue.ACTION_CREATE)));
            bindingQueueList.stream().forEach(groupSpaceBindingQueue -> this.createGroupSpaceBindingQueue((GroupSpaceBindingQueue)groupSpaceBindingQueue));
        }
        catch (Exception e) {
            LOG.error((Object)("Error Binding" + e));
            throw new RuntimeException("Failed saving groupSpaceBindings: " + groupSpaceBindings.toString(), e);
        }
    }

    @Override
    public void bindUsersFromGroupSpaceBinding(GroupSpaceBinding groupSpaceBinding) {
        Space space = this.spaceService.getSpaceById(groupSpaceBinding.getSpaceId());
        Object[] members = space.getMembers();
        int offset = 0;
        try {
            LinkedList<UserSpaceBinding> userSpaceBindings = new LinkedList<UserSpaceBinding>();
            ListAccess groupMembersAccess = this.organizationService.getUserHandler().findUsersByGroupId(groupSpaceBinding.getGroup());
            int totalGroupMembersSize = groupMembersAccess.getSize();
            do {
                long toBind;
                int limit = (toBind = (long)(totalGroupMembersSize - offset)) < 100L ? (int)toBind : 100;
                List<Object> users = Arrays.asList(groupMembersAccess.load(offset, limit));
                long count = users.size();
                for (User user : users) {
                    boolean isUserAlreadyBound;
                    String userId = user.getUserName();
                    UserSpaceBinding userSpaceBinding = new UserSpaceBinding();
                    userSpaceBinding.setUser(userId);
                    boolean bl = isUserAlreadyBound = this.countUserBindings(groupSpaceBinding.getSpaceId(), userId) > 0L;
                    if (!isUserAlreadyBound) {
                        userSpaceBinding.setIsMemberBefore(ArrayUtils.contains((Object[])members, (Object)userId));
                    } else {
                        userSpaceBinding.setIsMemberBefore(this.isUserBoundAndMemberBefore(groupSpaceBinding.getSpaceId(), userId));
                    }
                    userSpaceBinding.setGroupBinding(groupSpaceBinding);
                    userSpaceBindings.add(userSpaceBinding);
                    this.spaceService.addMember(space, userId);
                    this.groupSpaceBindingStorage.saveUserBinding(userSpaceBinding);
                }
                offset = (int)((long)offset + count);
                LOG.info("Binding process: Bound Users({})", new Object[]{offset});
            } while (offset < totalGroupMembersSize);
        }
        catch (Exception e) {
            LOG.error((Object)("Error Binding" + e));
            throw new RuntimeException("Failed saving groupSpaceBinding", e);
        }
    }

    @Override
    public boolean isUserBoundAndMemberBefore(String spaceId, String userId) {
        return this.groupSpaceBindingStorage.isUserBoundAndMemberBefore(spaceId, userId);
    }

    @Override
    public void deleteFromBindingQueue(GroupSpaceBindingQueue bindingQueue) {
        this.groupSpaceBindingStorage.deleteGroupBindingQueue(bindingQueue.getId());
    }
}

