/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.Date;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.GateInTokenStore;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.hash.JCASaltedHashService;
import org.exoplatform.web.security.hash.SaltedHashException;
import org.exoplatform.web.security.hash.SaltedHashService;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieToken;
import org.exoplatform.web.security.security.TokenExistsException;
import org.exoplatform.web.security.security.TokenParseException;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.security.Credentials;

public class CookieTokenService
extends AbstractTokenService<GateInToken, String> {
    public static final String LIFECYCLE_NAME = "lifecycle-name";
    public static final String HASH_SERVICE_INIT_PARAM = "hash.service";
    private GateInTokenStore tokenStore;
    private AbstractCodec codec;
    private SaltedHashService saltedHashService;
    private final Logger log = LoggerFactory.getLogger(CookieTokenService.class);

    public CookieTokenService(InitParams initParams, GateInTokenStore tokenStore, CodecInitializer codecInitializer) throws TokenServiceInitializationException {
        super(initParams);
        this.tokenStore = tokenStore;
        ObjectParameter hashServiceParam = initParams.getObjectParam(HASH_SERVICE_INIT_PARAM);
        this.saltedHashService = hashServiceParam == null || hashServiceParam.getObject() == null ? new JCASaltedHashService() : (SaltedHashService)hashServiceParam.getObject();
        this.codec = codecInitializer.getCodec();
    }

    @Override
    public void start() {
        this.tokenStore.cleanLegacy();
        super.start();
    }

    @Override
    public String createToken(Credentials credentials) {
        if (this.validityMillis < 0L) {
            throw new IllegalArgumentException();
        }
        if (credentials == null) {
            throw new NullPointerException();
        }
        String cookieTokenString = null;
        while (cookieTokenString == null) {
            String randomString = this.nextTokenId();
            String id = this.nextRandom();
            cookieTokenString = new CookieToken(id, randomString).toString();
            String hashedRandomString = this.hashToken(randomString);
            long expirationTimeMillis = System.currentTimeMillis() + this.validityMillis;
            String encryptedPassword = this.codec.encode(credentials.getPassword());
            Credentials encodedCredentials = new Credentials(credentials.getUsername(), encryptedPassword);
            try {
                this.tokenStore.saveToken(new GateInTokenStore.TokenData(id, hashedRandomString, encodedCredentials, new Date(expirationTimeMillis)));
            }
            catch (TokenExistsException e) {
                cookieTokenString = null;
            }
        }
        return cookieTokenString;
    }

    @Override
    protected String nextTokenId() {
        return this.nextRandom();
    }

    @Override
    public GateInToken getToken(String cookieTokenString) {
        block5: {
            try {
                CookieToken token = new CookieToken(cookieTokenString);
                GateInTokenStore.TokenData encryptedToken = this.tokenStore.getToken(token.getId());
                if (encryptedToken == null) break block5;
                try {
                    if (this.saltedHashService.validate(token.getRandomString(), encryptedToken.hash)) {
                        Credentials encryptedCredentials = encryptedToken.payload;
                        Credentials decryptedCredentials = new Credentials(encryptedCredentials.getUsername(), this.codec.decode(encryptedCredentials.getPassword()));
                        return new GateInToken(encryptedToken.expirationTime.getTime(), decryptedCredentials);
                    }
                }
                catch (SaltedHashException e) {
                    this.log.warn((Object)"Could not validate cookie token against its salted hash.", (Throwable)e);
                }
            }
            catch (TokenParseException e) {
                this.log.warn((Object)("Could not parse cookie token:" + e.getMessage()));
            }
        }
        return null;
    }

    @Override
    public GateInToken deleteToken(String cookieTokenString) {
        try {
            GateInToken result = this.getToken(cookieTokenString);
            if (result != null) {
                CookieToken token = new CookieToken(cookieTokenString);
                this.tokenStore.deleteToken(token.getId());
                return result;
            }
        }
        catch (TokenParseException e) {
            this.log.warn((Object)("Could not parse cookie token:" + e.getMessage()));
        }
        return null;
    }

    public void deleteTokensOfUser(String user) {
        this.tokenStore.deleteTokenOfUser(user);
    }

    public void deleteAll() {
        this.tokenStore.deleteAll();
    }

    @Override
    public void cleanExpiredTokens() {
        this.tokenStore.cleanExpired();
    }

    @Override
    public long size() {
        return this.tokenStore.size();
    }

    @Override
    protected String decodeKey(String stringKey) {
        return stringKey;
    }

    private String hashToken(String tokenId) {
        if (this.saltedHashService != null) {
            try {
                return this.saltedHashService.getSaltedHash(tokenId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return tokenId;
    }
}

