/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class DefaultRequestHandler
extends WebRequestHandler {
    private final UserPortalConfigService configService;
    private final URLFactoryService urlFactory;

    public DefaultRequestHandler(UserPortalConfigService configService, URLFactoryService urlFactory) {
        this.configService = configService;
        this.urlFactory = urlFactory;
    }

    public String getHandlerName() {
        return "default";
    }

    public boolean execute(ControllerContext context) throws Exception {
        boolean canAccessDefaultPortal;
        String defaultPortal = this.configService.getDefaultPortal();
        List allPortalNames = this.configService.getAllPortalNames();
        boolean emptyPortalList = allPortalNames == null || allPortalNames.isEmpty();
        boolean bl = canAccessDefaultPortal = allPortalNames != null && allPortalNames.contains(defaultPortal);
        if (!emptyPortalList && !canAccessDefaultPortal) {
            defaultPortal = (String)allPortalNames.get(0);
        } else if (emptyPortalList) {
            HttpServletResponse resp = context.getResponse();
            String currentPortalContainerName = PortalContainer.getCurrentPortalContainerName();
            resp.sendRedirect("/" + currentPortalContainerName + "/login");
            return true;
        }
        PortalURLContext urlContext = new PortalURLContext(context, SiteKey.portal((String)defaultPortal));
        NodeURL url = (NodeURL)this.urlFactory.newURL(NodeURL.TYPE, (URLContext)urlContext);
        String s = url.setResource(new NavigationResource(SiteType.PORTAL, defaultPortal, "")).toString();
        HttpServletResponse resp = context.getResponse();
        resp.sendRedirect(resp.encodeRedirectURL(s));
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }
}

