/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.portlet.PortletMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.exoplatform.commons.utils.Text;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.state.ContextualPropertyManager;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.module.ModuleRegistry;
import org.exoplatform.portal.portlet.PortletExceptionHandleService;
import org.exoplatform.portal.webui.application.ExoPortletInstanceContext;
import org.exoplatform.portal.webui.application.ExoPortletInvocationContext;
import org.exoplatform.portal.webui.application.ExoServerContext;
import org.exoplatform.portal.webui.application.ExoUserContext;
import org.exoplatform.portal.webui.application.ModelAdapter;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIApplication;
import org.exoplatform.portal.webui.application.UIPortletActionListener;
import org.exoplatform.portal.webui.application.UIPortletLifecycle;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.StatefulPortletContext;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.ParameterInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.ClientContext;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.RequestContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.ServerContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.api.state.PropertyChange;
import org.gatein.pc.portlet.impl.spi.AbstractClientContext;
import org.gatein.pc.portlet.impl.spi.AbstractPortalContext;
import org.gatein.pc.portlet.impl.spi.AbstractRequestContext;
import org.gatein.pc.portlet.impl.spi.AbstractSecurityContext;
import org.gatein.pc.portlet.impl.spi.AbstractWindowContext;
import org.gatein.portal.controller.resource.ResourceScope;
import org.w3c.dom.Element;

@ComponentConfig(lifecycle=UIPortletLifecycle.class, template="system:/groovy/portal/webui/application/UIPortlet.gtmpl", events={@EventConfig(listeners={UIPortletActionListener.RenderActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortletActionListener.ChangePortletModeActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortletActionListener.ChangeWindowStateActionListener.class}, csrfCheck=false), @EventConfig(listeners={UIPortalComponentActionListener.DeleteComponentActionListener.class}, confirm="UIPortlet.deletePortlet"), @EventConfig(listeners={UIPortletActionListener.EditPortletActionListener.class}), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ProcessActionActionListener.class}, csrfCheck=false), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ServeResourceActionListener.class}, csrfCheck=false), @EventConfig(phase=Event.Phase.PROCESS, listeners={UIPortletActionListener.ProcessEventsActionListener.class}, csrfCheck=false)})
public class UIPortlet<S, C extends Serializable>
extends UIApplication {
    protected static final Log log = ExoLogger.getLogger((String)"portal:UIPortlet");
    public static final String DEFAULT_THEME = "Default:DefaultTheme::Vista:VistaTheme::Mac:MacTheme";
    public static final String JAVASCRIPT_DEPENDENCY = "org.gatein.javascript.dependency";
    private static final String WSRP_URL = "wsrp-url";
    private static final String WSRP_PREFER_OPERATION = "wsrp-preferOperation";
    private static final String WSRP_REQUIRES_REWRITE = "wsrp-requiresRewrite";
    private static final String WSRP_NAVIGATIONAL_VALUES = "wsrp-navigationalValues";
    private static final AbstractPortalContext PORTAL_CONTEXT = new AbstractPortalContext(Collections.singletonMap("javax.portlet.markup.head.element.support", "true"));
    private String storageId;
    private String storageName;
    private ModelAdapter<S, C> adapter;
    private Portlet producedOfferedPortlet;
    private PortletContext producerOfferedPortletContext;
    private LocalizedString displayName;
    private PortletState<S> state;
    private String applicationId;
    private String theme_;
    private String portletStyle;
    private boolean showPortletMode = true;
    private PortletMode currentPortletMode_ = PortletMode.VIEW;
    private javax.portlet.WindowState currentWindowState_ = javax.portlet.WindowState.NORMAL;
    private List<String> supportModes_;
    private List<QName> supportedProcessingEvents_;
    private List<QName> supportedPublishingEvents_;
    private Map<QName, String> supportedPublicParams_;
    private boolean portletInPortal_ = true;
    private StateString navigationalState;
    private String configuredTitle;
    private static final ThreadLocal<UIPortlet> currentPortlet = new ThreadLocal();

    public UIPortlet() {
        this.storageName = UUID.randomUUID().toString();
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public String getWindowId() {
        return this.storageName;
    }

    public String getSkinId() {
        ApplicationType<S> type = this.state.getApplicationType();
        if (type == ApplicationType.PORTLET) {
            return this.applicationId;
        }
        return null;
    }

    public String getId() {
        return this.storageName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getPortletStyle() {
        return this.portletStyle;
    }

    public void setPortletStyle(String s) {
        this.portletStyle = s;
    }

    public boolean getShowPortletMode() {
        return this.showPortletMode;
    }

    public void setShowPortletMode(Boolean b) {
        this.showPortletMode = b;
    }

    public void setPortletInPortal(boolean b) {
        this.portletInPortal_ = b;
    }

    public boolean isPortletInPortal() {
        return this.portletInPortal_;
    }

    public String getTheme() {
        if (this.theme_ == null || this.theme_.trim().length() < 1) {
            return DEFAULT_THEME;
        }
        return this.theme_;
    }

    public void setTheme(String theme) {
        this.theme_ = theme;
    }

    public String getSuitedTheme(String skin) {
        Map<String, String> themeMap;
        if (skin == null) {
            skin = Util.getUIPortalApplication().getSkin();
        }
        if ((themeMap = this.stringToThemeMap(this.getTheme())).containsKey(skin)) {
            return themeMap.get(skin);
        }
        return DEFAULT_THEME.split(":")[1];
    }

    public void putSuitedTheme(String skin, String theme) {
        if (skin == null) {
            skin = Util.getUIPortalApplication().getSkin();
        }
        Map<String, String> themeMap = this.stringToThemeMap(this.getTheme());
        themeMap.put(skin, theme);
        this.setTheme(this.themeMapToString(themeMap));
    }

    private String themeMapToString(Map<String, String> themeMap) {
        StringBuffer builder = new StringBuffer();
        Iterator<Map.Entry<String, String>> itr = themeMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, String> entry = itr.next();
            builder.append(entry.getKey()).append(":").append(entry.getValue());
            if (!itr.hasNext()) continue;
            builder.append("::");
        }
        return builder.toString();
    }

    private Map<String, String> stringToThemeMap(String themesString) {
        String[] themeIds;
        HashMap<String, String> themeMap = new HashMap<String, String>();
        for (String ele : themeIds = themesString.split("::")) {
            String[] strs = ele.split(":");
            themeMap.put(strs[0], strs[1]);
        }
        return themeMap;
    }

    public PortletMode getCurrentPortletMode() {
        return this.currentPortletMode_;
    }

    public void setCurrentPortletMode(PortletMode mode) {
        this.currentPortletMode_ = mode;
    }

    public javax.portlet.WindowState getCurrentWindowState() {
        return this.currentWindowState_;
    }

    public void setCurrentWindowState(javax.portlet.WindowState state) {
        this.currentWindowState_ = state;
    }

    public List<QName> getSupportedProcessingEvents() {
        return this.supportedProcessingEvents_;
    }

    public void setSupportedProcessingEvents(List<QName> supportedProcessingEvents) {
        this.supportedProcessingEvents_ = supportedProcessingEvents;
    }

    public Map<QName, String> getSupportedPublicRenderParameters() {
        return this.supportedPublicParams_;
    }

    public void setSupportedPublicRenderParameters(Map<QName, String> supportedPublicRenderParameters) {
        this.supportedPublicParams_ = supportedPublicRenderParameters;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            Portlet portlet = this.getProducedOfferedPortlet();
            if (portlet != null) {
                PortletInfo info = portlet.getInfo();
                MetaInfo meta = info.getMeta();
                this.displayName = meta.getMetaValue("display-name");
                String value = null;
                if (this.displayName != null) {
                    org.exoplatform.web.application.RequestContext i = PortalRequestContext.getCurrentInstance();
                    Locale locale = i.getLocale();
                    value = this.displayName.getString(locale, true);
                }
                if (value == null || value.length() == 0) {
                    value = info.getName();
                }
                return value;
            }
            return "";
        }
        org.exoplatform.web.application.RequestContext i = PortalRequestContext.getCurrentInstance();
        Locale locale = i.getLocale();
        String value = this.displayName.getString(locale, true);
        if (ParameterValidation.isNullOrEmpty((String)value)) {
            Portlet portlet = this.getProducedOfferedPortlet();
            PortletInfo info = portlet.getInfo();
            value = info.getName();
        }
        return value;
    }

    public Portlet getProducedOfferedPortlet() {
        return this.producedOfferedPortlet;
    }

    public List<String> getSupportModes() {
        if (this.supportModes_ != null) {
            return this.supportModes_;
        }
        ArrayList<String> supportModes = new ArrayList<String>();
        Portlet portlet = this.getProducedOfferedPortlet();
        if (portlet == null) {
            return supportModes;
        }
        Set modes = portlet.getInfo().getCapabilities().getModes(MediaType.create((String)"text/html"));
        for (ModeInfo mode : modes) {
            supportModes.add(mode.getModeName());
        }
        if (supportModes.size() > 0) {
            supportModes.remove("view");
        }
        this.setSupportModes(supportModes);
        return supportModes;
    }

    public void setSupportModes(List<String> supportModes) {
        this.supportModes_ = supportModes;
    }

    public boolean supportsProcessingEvent(QName name) {
        if (this.supportedProcessingEvents_ == null) {
            Portlet portlet = this.getProducedOfferedPortlet();
            if (portlet == null) {
                if (this.producerOfferedPortletContext != null) {
                    log.debug((Object)("Could not find portlet with ID : " + this.producerOfferedPortletContext.getId()));
                } else {
                    log.debug((Object)"Could not find portlet. The producerOfferedPortletContext is null");
                }
                return false;
            }
            Map consumedEvents = portlet.getInfo().getEventing().getConsumedEvents();
            if (consumedEvents == null) {
                return false;
            }
            this.supportedProcessingEvents_ = new ArrayList(consumedEvents.keySet());
        }
        for (QName eventName : this.supportedProcessingEvents_) {
            if (!eventName.equals(name)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Portlet " + this.producerOfferedPortletContext + " supports comsuming the event : " + name));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The portlet " + this.producerOfferedPortletContext + " doesn't support consuming the event : " + name));
        }
        return false;
    }

    public boolean supportsPublishingEvent(QName name) {
        if (this.supportedPublishingEvents_ == null) {
            Portlet portlet = this.getProducedOfferedPortlet();
            if (portlet == null) {
                log.info((Object)("Could not find portlet with ID : " + this.producerOfferedPortletContext.getId()));
                return false;
            }
            Map producedEvents = portlet.getInfo().getEventing().getProducedEvents();
            if (producedEvents == null) {
                return false;
            }
            this.supportedPublishingEvents_ = new ArrayList(producedEvents.keySet());
        }
        for (QName eventName : this.supportedPublishingEvents_) {
            if (!eventName.equals(name)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Portlet " + this.producerOfferedPortletContext + " supports producing the event : " + name));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The portlet " + this.producerOfferedPortletContext + " doesn't support producing the event : " + name));
        }
        return false;
    }

    public String supportsPublicParam(QName supportedPublicParam) {
        String id;
        if (this.supportedPublicParams_ == null) {
            if (this.producedOfferedPortlet == null) {
                if (this.producerOfferedPortletContext != null) {
                    log.debug((Object)("Could not find portlet with ID : " + this.producerOfferedPortletContext.getId()));
                }
                return null;
            }
            Collection parameters = this.producedOfferedPortlet.getInfo().getNavigation().getPublicParameters();
            this.supportedPublicParams_ = new HashMap<QName, String>();
            for (ParameterInfo parameter : parameters) {
                this.supportedPublicParams_.put(parameter.getName(), parameter.getId());
            }
        }
        if ((id = this.supportedPublicParams_.get(supportedPublicParam)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Portlet " + this.producerOfferedPortletContext.getId() + " supports the public render parameter : " + supportedPublicParam));
            }
            return id;
        }
        return null;
    }

    public boolean supportsPublicParam(String supportedPublicParam) {
        if (this.supportedPublicParams_ == null) {
            if (this.producedOfferedPortlet == null) {
                log.info((Object)("Could not find portlet with ID : " + this.producerOfferedPortletContext.getId()));
                return false;
            }
            Collection parameters = this.producedOfferedPortlet.getInfo().getNavigation().getPublicParameters();
            this.supportedPublicParams_ = new HashMap<QName, String>();
            for (ParameterInfo parameter : parameters) {
                this.supportedPublicParams_.put(parameter.getName(), parameter.getId());
            }
        }
        for (String publicParam : this.supportedPublicParams_.values()) {
            if (!publicParam.equals(supportedPublicParam)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Portlet " + this.producerOfferedPortletContext.getId() + " supports the public render parameter : " + supportedPublicParam));
            }
            return true;
        }
        return false;
    }

    public List<String> getPublicRenderParamNames() {
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        ArrayList<String> publicParamsSupportedByPortlet = new ArrayList<String>();
        if (publicParams != null) {
            Set<String> keys = publicParams.keySet();
            for (String key : keys) {
                if (!this.supportsPublicParam(key)) continue;
                publicParamsSupportedByPortlet.add(key);
            }
            return publicParamsSupportedByPortlet;
        }
        return new ArrayList<String>();
    }

    public Map<String, String[]> getPublicParameters(Map<String, String[]> portletParameters) {
        HashMap<String, String[]> publicParamsMap = new HashMap<String, String[]>();
        UIPortal uiPortal = Util.getUIPortal();
        Map<String, String[]> publicParams = uiPortal.getPublicParameters();
        Set<String> allPublicParamsNames = publicParams.keySet();
        List<String> supportedPublicParamNames = this.getPublicRenderParamNames();
        for (String oneOfAllParams : allPublicParamsNames) {
            if (!supportedPublicParamNames.contains(oneOfAllParams)) continue;
            publicParamsMap.put(oneOfAllParams, publicParams.get(oneOfAllParams));
            if (portletParameters == null || !portletParameters.containsKey(oneOfAllParams)) continue;
            publicParamsMap.put(oneOfAllParams, portletParameters.get(oneOfAllParams));
            publicParams.put(oneOfAllParams, portletParameters.get(oneOfAllParams));
        }
        if (this.supportedPublicParams_ != null && portletParameters != null && portletParameters.size() > 0 && allPublicParamsNames.size() == 0) {
            for (QName qName : this.supportedPublicParams_.keySet()) {
                String prpId = this.supportsPublicParam(qName);
                if (prpId == null || !portletParameters.containsKey(prpId)) continue;
                publicParamsMap.put(prpId, portletParameters.get(prpId));
                publicParams.put(prpId, portletParameters.get(prpId));
            }
        }
        ContextualPropertyManager propertyManager = (ContextualPropertyManager)this.getApplicationComponent(ContextualPropertyManager.class);
        Map<QName, String[]> exposedPortalState = propertyManager.getProperties(this);
        for (QName prpQName : exposedPortalState.keySet()) {
            String prpId = this.supportsPublicParam(prpQName);
            if (prpId == null) continue;
            publicParamsMap.put(prpId, exposedPortalState.get(prpQName));
        }
        return publicParamsMap;
    }

    public Map<String, String[]> getPublicParameters() {
        return this.getPublicParameters(null);
    }

    public <I extends PortletInvocation> I create(Class<I> type, PortalRequestContext prc) throws Exception {
        PortletInvocation invocation;
        ExoPortletInvocationContext pic = new ExoPortletInvocationContext(prc, this);
        HttpServletRequest servletRequest = prc.getRequest();
        HashMap<String, String[]> allParams = new HashMap<String, String[]>();
        allParams.putAll(prc.getPortletParameters());
        allParams.putAll(this.getPublicParameters());
        allParams.remove("navigationalstate");
        if (type.equals(ActionInvocation.class)) {
            ActionInvocation actionInvocation = new ActionInvocation((PortletInvocationContext)pic);
            actionInvocation.setRequestContext((RequestContext)new AbstractRequestContext(servletRequest));
            String interactionState = servletRequest.getParameter("interactionstate");
            if (interactionState != null) {
                actionInvocation.setInteractionState(StateString.create((String)interactionState));
                allParams.remove("interactionstate");
            }
            actionInvocation.setForm(allParams);
            invocation = (PortletInvocation)type.cast(actionInvocation);
        } else if (type.equals(ResourceInvocation.class)) {
            String resourceState;
            ResourceInvocation resourceInvocation = new ResourceInvocation((PortletInvocationContext)pic);
            resourceInvocation.setRequestContext((RequestContext)new AbstractRequestContext(servletRequest));
            String resourceId = servletRequest.getParameter("portal:resourceID");
            if (!ParameterValidation.isNullOrEmpty((String)resourceId)) {
                resourceInvocation.setResourceId(resourceId);
            } else if (!ParameterValidation.isNullOrEmpty((String)prc.getRequestParameter("portal:resourceID"))) {
                resourceInvocation.setResourceId(prc.getRequestParameter("portal:resourceID"));
            }
            String cachability = servletRequest.getParameter("portal:cacheLevel");
            if (!ParameterValidation.isNullOrEmpty((String)cachability)) {
                resourceInvocation.setCacheLevel(CacheLevel.create((String)cachability.toUpperCase(Locale.ENGLISH)));
            }
            if (!ParameterValidation.isNullOrEmpty((String)(resourceState = servletRequest.getParameter("resourcestate")))) {
                resourceInvocation.setResourceState(StateString.create((String)resourceState));
            }
            allParams.remove("resourcestate");
            String url = servletRequest.getParameter(WSRP_URL);
            if (!ParameterValidation.isNullOrEmpty((String)url)) {
                resourceInvocation.setAttribute(WSRP_URL, (Object)url);
            }
            allParams.remove(WSRP_URL);
            String preferOperation = servletRequest.getParameter(WSRP_PREFER_OPERATION);
            if (!ParameterValidation.isNullOrEmpty((String)preferOperation)) {
                resourceInvocation.setAttribute(WSRP_PREFER_OPERATION, (Object)preferOperation);
            }
            allParams.remove(WSRP_PREFER_OPERATION);
            String requiresRewrite = servletRequest.getParameter(WSRP_REQUIRES_REWRITE);
            if (!ParameterValidation.isNullOrEmpty((String)requiresRewrite)) {
                resourceInvocation.setAttribute(WSRP_REQUIRES_REWRITE, (Object)requiresRewrite);
            }
            allParams.remove(WSRP_REQUIRES_REWRITE);
            resourceInvocation.setForm(allParams);
            invocation = (PortletInvocation)type.cast(resourceInvocation);
        } else if (type.equals(EventInvocation.class)) {
            invocation = (PortletInvocation)type.cast(new EventInvocation((PortletInvocationContext)pic));
        } else if (type.equals(RenderInvocation.class)) {
            invocation = (PortletInvocation)type.cast(new RenderInvocation((PortletInvocationContext)pic));
        } else {
            throw new AssertionError();
        }
        invocation.setRequest(servletRequest);
        invocation.setResponse(prc.getResponse());
        invocation.setNavigationalState(this.navigationalState);
        invocation.setPublicNavigationalState(this.getPublicParameters(prc.getPortletParameters()));
        String navigationalValues = servletRequest.getParameter(WSRP_NAVIGATIONAL_VALUES);
        if (!ParameterValidation.isNullOrEmpty((String)navigationalValues)) {
            invocation.setAttribute(WSRP_NAVIGATIONAL_VALUES, (Object)navigationalValues);
        }
        allParams.remove(WSRP_NAVIGATIONAL_VALUES);
        invocation.setMode(Mode.create((String)this.getCurrentPortletMode().toString()));
        invocation.setWindowState(WindowState.create((String)this.getCurrentWindowState().toString()));
        StatefulPortletContext<C> preferencesPortletContext = this.getPortletContext();
        if (preferencesPortletContext == null) {
            return null;
        }
        UserProfile userProfile = (UserProfile)prc.getAttribute("PortalUserProfile");
        Cookie[] cookies = servletRequest.getCookies();
        AbstractClientContext clientContext = cookies != null ? new AbstractClientContext(servletRequest, Arrays.asList(cookies)) : new AbstractClientContext(servletRequest);
        invocation.setClientContext((ClientContext)clientContext);
        ExoPortletInstanceContext instanceContext = new ExoPortletInstanceContext(preferencesPortletContext.getId());
        invocation.setTarget(preferencesPortletContext);
        invocation.setInstanceContext((InstanceContext)instanceContext);
        invocation.setServerContext((ServerContext)new ExoServerContext(servletRequest, prc.getResponse()));
        invocation.setUserContext((UserContext)new ExoUserContext(servletRequest, userProfile));
        invocation.setWindowContext((WindowContext)new AbstractWindowContext(this.storageName));
        invocation.setPortalContext((PortalContext)PORTAL_CONTEXT);
        invocation.setSecurityContext((SecurityContext)new AbstractSecurityContext(servletRequest));
        return (I)invocation;
    }

    public void update(PropertyChange ... changes) throws Exception {
        StatefulPortletContext<C> portletContext = this.getPortletContext();
        PortletInvoker portletInvoker = (PortletInvoker)this.getApplicationComponent(PortletInvoker.class);
        StatefulPortletContext updatedCtx = (StatefulPortletContext)portletInvoker.setProperties(portletContext, changes);
        Serializable updateState = updatedCtx.getState();
        this.update(updateState);
    }

    public PortletState<S> getState() {
        return this.state;
    }

    public void setState(PortletState<S> state) {
        if (state != null) {
            try {
                PortletInvoker portletInvoker = (PortletInvoker)this.getApplicationComponent(PortletInvoker.class);
                DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
                String applicationId = dataStorage.getId(state.getApplicationState());
                ModelAdapter adapter = ModelAdapter.getAdapter(state.getApplicationType());
                PortletContext producerOfferedPortletContext = adapter.getProducerOfferedPortletContext(applicationId);
                ModuleRegistry moduleRegistry = (ModuleRegistry)this.getApplicationComponent(ModuleRegistry.class);
                if (moduleRegistry.isPortletActive(applicationId)) {
                    try {
                        this.producedOfferedPortlet = portletInvoker.getPortlet(producerOfferedPortletContext);
                    }
                    catch (Exception e) {
                        this.producedOfferedPortlet = null;
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                this.adapter = adapter;
                this.producerOfferedPortletContext = producerOfferedPortletContext;
                this.applicationId = applicationId;
            }
            catch (NoSuchDataException e) {
                log.error((Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            this.adapter = null;
            this.producedOfferedPortlet = null;
            this.producerOfferedPortletContext = null;
            this.applicationId = null;
        }
        this.state = state;
    }

    public org.exoplatform.portal.pom.spi.portlet.Portlet getPreferences() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        return this.adapter.getState(container, this.state.getApplicationState());
    }

    public StatefulPortletContext<C> getPortletContext() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        return this.adapter.getPortletContext(container, this.applicationId, this.state.getApplicationState());
    }

    public void update(C updateState) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        this.state.setApplicationState(this.adapter.update(container, updateState, this.state.getApplicationState()));
        this.setState(this.state);
    }

    public C getModifiedState(PortletContext modifiedContext) throws Exception {
        return this.adapter.getStateFromModifiedContext((PortletContext)this.getPortletContext(), modifiedContext);
    }

    public C getClonedState(PortletContext clonedContext) throws Exception {
        return this.adapter.getstateFromClonedContext((PortletContext)this.getPortletContext(), clonedContext);
    }

    public static UIPortlet getCurrentUIPortlet() {
        return currentPortlet.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws PortletInvokerException {
        PortletInvoker portletInvoker = (PortletInvoker)this.getApplicationComponent(PortletInvoker.class);
        currentPortlet.set(this);
        try {
            PortletInvocationResponse portletInvocationResponse = portletInvoker.invoke(invocation);
            return portletInvocationResponse;
        }
        finally {
            currentPortlet.set(null);
        }
    }

    void setNavigationalState(StateString navigationalState) {
        this.navigationalState = navigationalState;
    }

    protected void setConfiguredTitle(String _configuredTitle) {
        this.configuredTitle = _configuredTitle;
    }

    public String getDisplayTitle() {
        String displayedTitle = this.getTitle();
        if (displayedTitle != null && displayedTitle.trim().length() > 0) {
            return displayedTitle;
        }
        if (this.configuredTitle != null) {
            return this.configuredTitle;
        }
        return this.getDisplayName();
    }

    public Text generateRenderMarkup(PortletInvocationResponse pir, WebuiRequestContext context) {
        PortalRequestContext prcontext = (PortalRequestContext)context;
        Text markup = null;
        if (pir instanceof FragmentResponse) {
            JavascriptManager jsMan = context.getJavascriptManager();
            jsMan.loadScriptResource(ResourceScope.PORTLET, this.getApplicationId());
            FragmentResponse fragmentResponse = (FragmentResponse)pir;
            switch (fragmentResponse.getType()) {
                case 1: {
                    markup = Text.create((String)fragmentResponse.getContent());
                    break;
                }
                case 2: {
                    markup = Text.create((byte[])fragmentResponse.getBytes(), (Charset)Charset.forName("UTF-8"));
                    break;
                }
                case 0: {
                    markup = Text.create((String)"");
                }
            }
            this.setConfiguredTitle(fragmentResponse.getTitle());
            if (fragmentResponse.getProperties() != null) {
                MultiValuedPropertyMap markupHeaders;
                List markupElements;
                if (fragmentResponse.getProperties().getTransportHeaders() != null) {
                    MultiValuedPropertyMap transportHeaders = fragmentResponse.getProperties().getTransportHeaders();
                    for (String key : transportHeaders.keySet()) {
                        if (JAVASCRIPT_DEPENDENCY.equals(key)) {
                            for (String value : transportHeaders.getValues(key)) {
                                jsMan.require(value);
                            }
                            continue;
                        }
                        for (String value : transportHeaders.getValues(key)) {
                            prcontext.getResponse().setHeader(key, value);
                        }
                    }
                }
                if (fragmentResponse.getProperties().getCookies() != null) {
                    List cookies = fragmentResponse.getProperties().getCookies();
                    for (Cookie cookie : cookies) {
                        prcontext.getResponse().addCookie(cookie);
                    }
                }
                if (fragmentResponse.getProperties().getMarkupHeaders() != null && (markupElements = (markupHeaders = fragmentResponse.getProperties().getMarkupHeaders()).getValues("javax.portlet.markup.head.element")) != null) {
                    for (Element element : markupElements) {
                        if (!context.useAjax() && "title".equals(element.getNodeName().toLowerCase()) && element.getFirstChild() != null) {
                            String title = element.getFirstChild().getNodeValue();
                            prcontext.getRequest().setAttribute(PortalRequestContext.REQUEST_TITLE, (Object)title);
                            continue;
                        }
                        prcontext.addExtraMarkupHeader(element, this.getId());
                    }
                }
            }
        } else {
            PortletContainerException pcException;
            if (pir instanceof ErrorResponse) {
                ErrorResponse errorResponse = (ErrorResponse)pir;
                pcException = new PortletContainerException(errorResponse.getMessage(), errorResponse.getCause());
            } else {
                pcException = new PortletContainerException("Unknown invocation response type [" + pir.getClass() + "]. Expected a FragmentResponse or an ErrorResponse");
            }
            PortletExceptionHandleService portletExceptionService = (PortletExceptionHandleService)this.getApplicationComponent(PortletExceptionHandleService.class);
            if (portletExceptionService != null) {
                portletExceptionService.handle(pcException);
            }
            log.error((Object)"Portlet render threw an exception", (Throwable)pcException);
            markup = Text.create((String)context.getApplicationResourceBundle().getString("UIPortlet.message.RuntimeError"));
        }
        return markup;
    }
}

