/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ParentJarClassLoader
extends ClassLoader {
    private final ClassLoader parent;
    static final Method findResource;
    static final Method findResources;

    public ParentJarClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> found = super.loadClass(name, resolve);
        if (found.getClassLoader() == super.getParent()) {
            URL url = super.getResource(name.replace('.', '/') + ".class");
            if (this.shouldLoad(url)) {
                return found;
            }
            throw new ClassNotFoundException();
        }
        return found;
    }

    @Override
    public URL getResource(String name) {
        URL url;
        try {
            url = (URL)findResource.invoke((Object)this.parent, name);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Not yet handled", e);
        }
        if (url != null) {
            if (this.shouldLoad(url)) {
                return url;
            }
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration parentResources;
        try {
            parentResources = (Enumeration)findResources.invoke((Object)this.parent, name);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Not yet handled", e);
        }
        Enumeration<URL> ancestorResources = this.parent.getParent().getResources(name);
        final Enumeration[] resources = new Enumeration[]{parentResources, ancestorResources};
        return new Enumeration<URL>(){
            URL next = null;
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                while (this.next == null && this.index < resources.length) {
                    if (resources[this.index].hasMoreElements()) {
                        URL url = (URL)resources[this.index].nextElement();
                        if (this.index <= 0 && !ParentJarClassLoader.this.shouldLoad(url)) continue;
                        this.next = url;
                        continue;
                    }
                    ++this.index;
                }
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public URL nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException("No more elements");
                }
                try {
                    URL uRL = this.next;
                    return uRL;
                }
                finally {
                    this.next = null;
                }
            }
        };
    }

    private boolean shouldLoad(URL url) {
        String s = url.toString();
        return s.contains(".jar!/") || s.contains(".zip!/");
    }

    static {
        try {
            findResource = ClassLoader.class.getDeclaredMethod("findResource", String.class);
            findResource.setAccessible(true);
            findResources = ClassLoader.class.getDeclaredMethod("findResources", String.class);
            findResources.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Impossible to get findResource from ClassLoader class", e);
        }
    }
}

