/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletContractService;
import org.exoplatform.wallet.service.WalletTransactionService;

@Asynchronous
public class TransactionMinedListener
extends Listener<Object, Map<String, Object>> {
    private WalletAccountService accountService;
    private WalletContractService contractService;
    private WalletTransactionService walletTransactionService;
    private EthereumClientConnector web3jConnector;
    private ListenerService listenerService;

    public TransactionMinedListener(EthereumClientConnector web3jConnector) {
        this.web3jConnector = web3jConnector;
    }

    public void onEvent(Event<Object, Map<String, Object>> event) throws Exception {
        Map transactionDetailObject = (Map)event.getData();
        String hash = (String)transactionDetailObject.get("hash");
        TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(hash);
        if (transactionDetail == null) {
            return;
        }
        HashSet<String> contractMethodsInvoked = new HashSet<String>();
        HashMap<String, Set<String>> walletsModifications = new HashMap<String, Set<String>>();
        String contractMethodName = transactionDetail.getContractMethodName();
        if (StringUtils.isNotBlank((CharSequence)contractMethodName)) {
            contractMethodsInvoked.add(contractMethodName);
        }
        if (transactionDetail.isSucceeded()) {
            this.addWalletsModification(transactionDetail, walletsModifications);
        }
        if (!contractMethodsInvoked.isEmpty()) {
            this.getContractService().refreshContractDetail(contractMethodsInvoked);
        }
        if (!walletsModifications.isEmpty()) {
            this.getAccountService().refreshWalletsFromBlockchain(walletsModifications);
        }
        if (transactionDetail.isSucceeded() || this.web3jConnector.getTransaction(transactionDetail.getHash()) != null) {
            this.walletTransactionService.cancelTransactionsWithSameNonce(transactionDetail);
        }
        this.getListenerService().broadcast("exo.wallet.transaction.modified", null, (Object)transactionDetail);
    }

    private void addWalletsModification(TransactionDetail transactionDetail, Map<String, Set<String>> walletsModifications) {
        if (transactionDetail == null) {
            return;
        }
        this.addWalletModificationState(transactionDetail.getFromWallet(), "ether_transfer", walletsModifications);
        String contractMethodName = transactionDetail.getContractMethodName();
        if (StringUtils.isBlank((CharSequence)contractMethodName)) {
            this.addWalletModificationState(transactionDetail.getToWallet(), "ether_transfer", walletsModifications);
        } else if (StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"transfer") || StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"transferFrom")) {
            this.addWalletModificationState(transactionDetail.getFromWallet(), contractMethodName, walletsModifications);
            this.addWalletModificationState(transactionDetail.getToWallet(), contractMethodName, walletsModifications);
            this.addWalletModificationState(transactionDetail.getByWallet(), contractMethodName, walletsModifications);
        } else if (StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"approve")) {
            this.addWalletModificationState(transactionDetail.getFromWallet(), contractMethodName, walletsModifications);
        } else if (StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"transferOwnership")) {
            this.addWalletModificationState(transactionDetail.getFromWallet(), contractMethodName, walletsModifications);
            this.addWalletModificationState(transactionDetail.getToWallet(), contractMethodName, walletsModifications);
        }
    }

    private void addWalletModificationState(Wallet wallet, String contractMethodName, Map<String, Set<String>> walletsModifications) {
        if (wallet == null) {
            return;
        }
        String address = wallet.getAddress();
        if (!walletsModifications.containsKey(address)) {
            walletsModifications.put(address, new HashSet());
        }
        walletsModifications.get(address).add(contractMethodName);
    }

    private WalletTransactionService getTransactionService() {
        if (this.walletTransactionService == null) {
            this.walletTransactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.walletTransactionService;
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    private WalletContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.contractService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

