/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.listener;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.component.ThreadContextHandler;
import org.exoplatform.container.spi.DefinitionByType;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerThreadFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

@DefinitionByType
public class ListenerService
implements Startable {
    private final ExecutorService executor;
    private final Map<String, List<Listener>> listeners_;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.ListenerService");
    private final ExoContainer container;

    public ListenerService(ExoContainerContext ctx) {
        this(ctx, null, null);
    }

    public ListenerService(ExoContainerContext ctx, InitialContextInitializer initializer) {
        this(ctx, initializer, null);
    }

    public ListenerService(ExoContainerContext ctx, InitParams params) {
        this(ctx, null, params);
    }

    public ListenerService(ExoContainerContext ctx, InitialContextInitializer initializer, InitParams params) {
        this.container = ctx.getContainer();
        this.listeners_ = new HashMap<String, List<Listener>>();
        int poolSize = 1;
        if (params != null && params.getValueParam("asynchPoolSize") != null) {
            poolSize = Integer.parseInt(params.getValueParam("asynchPoolSize").getValue());
        }
        this.executor = Executors.newFixedThreadPool(poolSize, new ListenerThreadFactory());
    }

    public void addListener(Listener listener) {
        this.addListener(listener.getName(), listener);
    }

    public void addListener(String eventName, Listener listener) {
        Class<?> listenerClass = ((Object)((Object)listener)).getClass();
        do {
            if (!listenerClass.isAnnotationPresent(Asynchronous.class)) continue;
            listener = new AsynchronousListener(listener);
            break;
        } while ((listenerClass = listenerClass.getSuperclass()) != null);
        List<Listener> list = this.listeners_.get(eventName);
        if (list == null) {
            list = new ArrayList<Listener>();
            this.listeners_.put(eventName, list);
        }
        list.add(listener);
    }

    public final <S, D> void broadcast(String name, S source, D data) throws Exception {
        List<Listener> list = this.listeners_.get(name);
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("broadcasting event " + name + " on " + listener.getName()));
            }
            try {
                listener.onEvent(new Event<S, D>(name, source, data));
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on broadcasting events occurs: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public final <T extends Event> void broadcast(T event) throws Exception {
        List<Listener> list = this.listeners_.get(event.getEventName());
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on broadcasting events occurs: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void start() {
    }

    public void stop() {
        this.executor.shutdown();
    }

    protected class RunListener<S, D>
    implements Runnable {
        private Listener<S, D> listener;
        private Event<S, D> event;
        private final ThreadContextHandler handler;

        public RunListener(Listener<S, D> listener, Event<S, D> event) {
            this.listener = listener;
            this.event = event;
            this.handler = new ThreadContextHandler(ListenerService.this.container);
            this.handler.store();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block10: {
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ExoContainerContext.setCurrentContainer((ExoContainer)ListenerService.this.container);
                        return null;
                    }
                });
                RequestLifeCycle.begin((ExoContainer)ListenerService.this.container);
                this.handler.push();
                this.listener.onEvent(this.event);
                try {
                    this.handler.restore();
                    RequestLifeCycle.end();
                }
                catch (Throwable throwable) {
                    SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            ExoContainerContext.setCurrentContainer(null);
                            return null;
                        }
                    });
                    throw throwable;
                }
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
                break block10;
                catch (Exception e) {
                    try {
                        LOG.error((Object)("Exception on broadcasting events occurs: " + e.getMessage()), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.handler.restore();
                            RequestLifeCycle.end();
                        }
                        catch (Throwable throwable2) {
                            SecurityHelper.doPrivilegedAction((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
                            throw throwable2;
                        }
                        SecurityHelper.doPrivilegedAction((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    try {
                        this.handler.restore();
                        RequestLifeCycle.end();
                    }
                    catch (Throwable throwable) {
                        SecurityHelper.doPrivilegedAction((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SecurityHelper.doPrivilegedAction((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
                }
            }
        }
    }

    protected class AsynchronousListener<S, D>
    extends Listener<S, D> {
        private Listener<S, D> listener;

        public AsynchronousListener(Listener<S, D> listener) {
            this.listener = listener;
        }

        public String getName() {
            return this.listener.getName();
        }

        public void setName(String s) {
            this.listener.setName(s);
        }

        public String getDescription() {
            return this.listener.getDescription();
        }

        public void setDescription(String s) {
            this.listener.setDescription(s);
        }

        @Override
        public void onEvent(Event<S, D> event) throws Exception {
            ListenerService.this.executor.execute(new RunListener<S, D>(this.listener, event));
        }
    }
}

