/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.HistoryStatus;
import org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard;
import org.exoplatform.addons.gamification.service.effective.ProfileReputation;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class GamificationHistoryDAO
extends GenericDAOJPAImpl<GamificationActionsHistory, Long> {
    public static final String STATUS = "status";

    public List<StandardLeaderboard> findAllActionsHistoryAgnostic(IdentityType earnerType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistory", StandardLeaderboard.class);
        query.setParameter("earnerType", (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDateByDomain(IdentityType earnerType, Date date, String domain) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDateByDomain", StandardLeaderboard.class);
        query.setParameter("date", (Object)date).setParameter("domain", (Object)domain).setParameter("earnerType", (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDomain(IdentityType earnerType, String domain) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDomain", StandardLeaderboard.class);
        query.setParameter("domain", (Object)domain);
        query.setParameter("earnerType", (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDomain(String domain, IdentityType earnerType, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDomain", StandardLeaderboard.class);
        query.setParameter("domain", (Object)domain);
        query.setParameter("earnerType", (Object)earnerType);
        query.setMaxResults(limit);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDate(IdentityType earnerType, Date date) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDate", StandardLeaderboard.class);
        query.setParameter("date", (Object)date);
        query.setParameter("earnerType", (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDate(Date date, IdentityType earnerType, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDate", StandardLeaderboard.class);
        query.setParameter("date", (Object)date);
        query.setParameter("earnerType", (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        query.setMaxResults(limit);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<GamificationActionsHistory> findActionsHistoryByEarnerId(String earnerId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByEarnerId", GamificationActionsHistory.class);
        query.setParameter("earnerId", (Object)earnerId);
        query.setMaxResults(limit);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<StandardLeaderboard> findAllActionsHistory(IdentityType earnerType, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistory", StandardLeaderboard.class);
        query.setParameter("earnerType", (Object)earnerType);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        query.setMaxResults(limit);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<GamificationActionsHistory> findActionHistoryByDateByEarnerId(Date date, String earnerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionHistoryByDateByEarnerId", GamificationActionsHistory.class).setParameter("date", (Object)date).setParameter("earnerId", (Object)earnerId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<StandardLeaderboard> findActionsHistoryByDateByDomain(Date date, IdentityType earnerType, String domain, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDateByDomain", StandardLeaderboard.class);
        query.setParameter("date", (Object)date).setParameter("earnerType", (Object)earnerType).setParameter("domain", (Object)domain);
        query.setMaxResults(limit);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<PiechartLeaderboard> findStatsByUserId(String earnerId, Date fromDate, Date toDate) {
        TypedQuery query = null;
        if (fromDate != null && toDate != null) {
            query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findStatsByUserByDates", PiechartLeaderboard.class);
            query.setParameter("earnerId", (Object)earnerId).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate);
        } else {
            query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findStatsByUser", PiechartLeaderboard.class);
            query.setParameter("earnerId", (Object)earnerId);
        }
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<ProfileReputation> findDomainScoreByIdentityId(String earnerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findDomainScoreByUserId", ProfileReputation.class);
        query.setParameter("earnerId", (Object)earnerId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public long findUserReputationScoreBetweenDate(String earnerId, Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreBetweenDate", Long.class);
        query.setParameter("earnerId", (Object)earnerId).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public long findUserReputationScoreByMonth(String earnerId, Date currentMonth) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreByMonth", Long.class);
        query.setParameter("earnerId", (Object)earnerId).setParameter("currentMonth", (Object)currentMonth);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public long findUserReputationScoreByDomainBetweenDate(String earnerId, String domain, Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreByDomainBetweenDate", Long.class);
        query.setParameter("earnerId", (Object)earnerId).setParameter("domain", (Object)domain).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public List<StandardLeaderboard> findAllLeaderboardBetweenDate(IdentityType earnerType, Date fromDate, Date toDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllLeaderboardBetweenDate", StandardLeaderboard.class);
        query.setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).setParameter("earnerType", (Object)earnerType);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<GamificationActionsHistory> findActionsHistoryByEarnerIdSortedByDate(String earnerId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByEarnerIdSortedByDate", GamificationActionsHistory.class);
        query.setParameter("earnerId", (Object)earnerId);
        query.setMaxResults(limit);
        query.setParameter(STATUS, (Object)HistoryStatus.REJECTED);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public long getTotalScore(String earnerId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.computeTotalScore", Long.class);
        query.setParameter("earnerId", (Object)earnerId);
        Long count = (Long)query.getSingleResult();
        return count == null ? 0L : count;
    }

    public List<GamificationActionsHistory> getAllPointsByDomain(String domain) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.getAllPointsByDomain", GamificationActionsHistory.class);
        query.setParameter("domain", (Object)domain);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<GamificationActionsHistory> getAllPointsWithNullDomain() {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.getAllPointsWithNullDomain", GamificationActionsHistory.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<String> getDomainList() {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.getDomainList", String.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public Long countAnnouncementsByChallenge(Long challengeId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.countAnnouncementsByChallenge", Long.class);
        query.setParameter("challengeId", (Object)challengeId);
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0L : count;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public List<GamificationActionsHistory> findAllAnnouncementByChallenge(Long challengeId, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllAnnouncementByChallenge", GamificationActionsHistory.class);
        query.setParameter("challengeId", (Object)challengeId);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }

    public List<GamificationActionsHistory> getAllRealizationsByDate(Date fromDate, Date toDate, int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findRealizationsByDate", GamificationActionsHistory.class);
        query.setParameter("fromDate", (Object)fromDate);
        query.setParameter("toDate", (Object)toDate);
        query.setParameter("type", (Object)IdentityType.USER);
        if (limit != 0) {
            query.setFirstResult(offset);
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }
}

