/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

public class StatisticsFormat
extends TabularFormat<Statistics> {
    private static final long serialVersionUID = 6914760410359494163L;
    private final Locale headerLocale;
    private byte borderWidth;
    private boolean allPopulation;
    private static final short[] KEYS = new short[]{76, 75, 70, 67, 68, 91, 94};

    public static StatisticsFormat getInstance() {
        return new StatisticsFormat(Locale.getDefault(Locale.Category.FORMAT), Locale.getDefault(Locale.Category.DISPLAY), null);
    }

    public static StatisticsFormat getInstance(Locale locale) {
        return new StatisticsFormat(locale, locale, null);
    }

    public StatisticsFormat(Locale locale, Locale locale2, TimeZone timeZone) {
        super(locale, timeZone);
        this.headerLocale = locale2 != null ? locale2 : Locale.ROOT;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        if (category == Locale.Category.DISPLAY) {
            return this.headerLocale;
        }
        return super.getLocale(category);
    }

    @Override
    public final Class<Statistics> getValueType() {
        return Statistics.class;
    }

    public boolean isForAllPopulation() {
        return this.allPopulation;
    }

    public void setForAllPopulation(boolean bl) {
        this.allPopulation = bl;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        ArgumentChecks.ensureBetween("borderWidth", 0, 2, n);
        this.borderWidth = (byte)n;
    }

    @Override
    public Statistics parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        throw new ParseException(Errors.getResources(this.getLocale()).getString((short)162, "parse"), parsePosition.getIndex());
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Statistics[]) {
            try {
                this.format((Statistics[])object, (Appendable)stringBuffer);
                return stringBuffer;
            }
            catch (IOException iOException) {
                throw new BackingStoreException(iOException);
            }
        }
        return super.format(object, stringBuffer, fieldPosition);
    }

    @Override
    public void format(Statistics statistics, Appendable appendable) throws IOException {
        ArrayList<Statistics> arrayList = new ArrayList<Statistics>(3);
        while (statistics != null) {
            arrayList.add(statistics);
            statistics = statistics.differences();
        }
        this.format(arrayList.toArray(new Statistics[arrayList.size()]), appendable);
    }

    @Override
    public void format(Statistics[] statisticsArray, Appendable appendable) throws IOException {
        int n;
        Object object;
        Object object2;
        char c;
        String[] stringArray = new String[statisticsArray.length];
        boolean bl = false;
        boolean bl2 = false;
        for (c = '\u0000'; c < statisticsArray.length; ++c) {
            object2 = statisticsArray[c];
            bl2 |= ((Statistics)object2).countNaN() != 0;
            object = ((Statistics)object2).name();
            if (object == null) continue;
            stringArray[c] = object.toString(this.headerLocale);
            bl |= stringArray[c] != null;
        }
        c = '\u0000';
        object2 = this.columnSeparator;
        switch (this.borderWidth) {
            case 1: {
                c = '\u2500';
                object2 = (String)object2 + "\u2502 ";
                break;
            }
            case 2: {
                c = '\u2550';
                object2 = (String)object2 + "\u2551 ";
            }
        }
        object = new TableAppender(appendable, (String)object2);
        Vocabulary vocabulary = Vocabulary.getResources(this.headerLocale);
        if (c != '\u0000') {
            ((TableAppender)object).nextLine(c);
        }
        if (bl) {
            ((TableAppender)object).nextColumn();
            for (String n2 : stringArray) {
                if (n2 != null) {
                    ((TableAppender)object).append(n2);
                    ((TableAppender)object).setCellAlignment((byte)0);
                }
                ((TableAppender)object).nextColumn();
            }
            ((TableAppender)object).append(this.lineSeparator);
            if (c != '\u0000') {
                ((TableAppender)object).nextLine(c);
            }
        }
        Format format = this.getFormat(Integer.class);
        Format format2 = this.getFormat(Double.class);
        Format[] formatArray = new Format[statisticsArray.length];
        for (n = 0; n < formatArray.length; ++n) {
            formatArray[n] = StatisticsFormat.configure(format2, statisticsArray[n], n != 0);
        }
        for (n = 0; n < KEYS.length; ++n) {
            if (n == 1 & !bl2) continue;
            ((TableAppender)object).setCellAlignment((byte)-1);
            ((TableAppender)object).append(vocabulary.getString(KEYS[n])).append(':');
            for (int i = 0; i < statisticsArray.length; ++i) {
                Number number;
                Statistics statistics = statisticsArray[i];
                switch (n) {
                    case 0: {
                        number = statistics.count();
                        break;
                    }
                    case 1: {
                        number = statistics.countNaN();
                        break;
                    }
                    case 2: {
                        number = statistics.minimum();
                        break;
                    }
                    case 3: {
                        number = statistics.maximum();
                        break;
                    }
                    case 4: {
                        number = statistics.mean();
                        break;
                    }
                    case 5: {
                        number = statistics.rms();
                        break;
                    }
                    case 6: {
                        number = statistics.standardDeviation(this.allPopulation);
                        break;
                    }
                    default: {
                        throw new AssertionError(n);
                    }
                }
                ((TableAppender)object).append(this.beforeFill);
                ((TableAppender)object).nextColumn(this.fillCharacter);
                ((TableAppender)object).append((n >= 2 ? formatArray[i] : format).format(number));
                ((TableAppender)object).setCellAlignment((byte)1);
            }
            ((TableAppender)object).append(this.lineSeparator);
        }
        if (c != '\u0000') {
            ((TableAppender)object).nextLine(c);
        }
        ((TableAppender)object).flush();
    }

    private static Format configure(Format format, Statistics statistics, boolean bl) {
        int n = 1;
        if (format instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)format;
            n = decimalFormat.getMultiplier();
            double d = Math.max(Math.abs(statistics.minimum()), Math.abs(statistics.maximum()));
            if (n == 1 && (d >= 1.0E10 || d <= 1.0E-4)) {
                String string = decimalFormat.toPattern();
                int n2 = string.length();
                while (--n2 >= 0) {
                    switch (string.charAt(n2)) {
                        case '\'': 
                        case 'E': 
                        case '\u00a4': {
                            return format;
                        }
                    }
                }
                decimalFormat = (DecimalFormat)decimalFormat.clone();
                decimalFormat.applyPattern("0.00000E00");
                return decimalFormat;
            }
        }
        if (format instanceof NumberFormat) {
            NumberFormat numberFormat;
            int n3 = Numerics.suggestFractionDigits(statistics);
            n3 -= DecimalFunctions.floorLog10(n);
            if ((n3 = Math.max(0, n3)) != (numberFormat = (NumberFormat)format).getMinimumFractionDigits() || n3 != numberFormat.getMaximumFractionDigits()) {
                if (bl) {
                    numberFormat = (NumberFormat)numberFormat.clone();
                }
                numberFormat.setMinimumFractionDigits(n3);
                numberFormat.setMaximumFractionDigits(n3);
            }
            return numberFormat;
        }
        return format;
    }

    @Override
    public StatisticsFormat clone() {
        return (StatisticsFormat)super.clone();
    }
}

