/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.branding;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.branding.Branding;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.Logo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/v1/platform/branding")
@Api(tags={"/v1/platform/branding"}, value="/v1/platform/branding", description="Managing branding information")
public class BrandingRestResourcesV1
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(BrandingRestResourcesV1.class);
    private static final int CACHE_IN_MILLI_SECONDS = 1471228928;
    private BrandingService brandingService;

    public BrandingRestResourcesV1(BrandingService brandingService) {
        this.brandingService = brandingService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Branding information", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Server error when retrieving branding information")})
    public Response getBrandingInformation() {
        try {
            return Response.ok((Object)this.brandingService.getBrandingInformation()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when retrieving branding information", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update Branding information", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Branding information updated"), @ApiResponse(code=500, message="Server error when updating branding information")})
    public Response updateBrandingInformation(Branding branding) {
        try {
            this.brandingService.updateBrandingInformation(branding);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating branding information", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/logo")
    @Produces(value={"image/png"})
    @ApiOperation(value="Get Branding logo", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Branding logo retrieved"), @ApiResponse(code=404, message="Branding logo not found"), @ApiResponse(code=500, message="Server error when retrieving branding logo")})
    public Response getBrandingLogo(@Context Request request, @ApiParam(value="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified) {
        Logo logo = this.brandingService.getLogo();
        if (logo == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        long lastUpdated = logo.getUpdatedDate();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(logo.getData());
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.type("image/png");
        builder.tag(eTag);
        builder.lastModified(new Date(lastUpdated));
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
        }
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }

    @GET
    @Path(value="/css")
    @ApiOperation(value="Get Branding CSS content", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Branding css retrieved"), @ApiResponse(code=304, message="Branding css not modified"), @ApiResponse(code=500, message="Server error when retrieving branding css")})
    public Response getBrandingCSS(@Context Request request, @ApiParam(value="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="v") String lastModified) {
        long lastUpdated = this.brandingService.getLastUpdatedTime();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            String themeCSS = this.brandingService.getThemeCSSContent();
            builder = Response.ok((Object)themeCSS, (String)"text/css");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.type("text/css");
        builder.tag(eTag);
        builder.lastModified(new Date(lastUpdated));
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
        }
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }

    @GET
    @Path(value="/defaultLogo")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Branding default logo", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Branding default logo retrieved"), @ApiResponse(code=404, message="Branding default logo not found"), @ApiResponse(code=500, message="Server error when retrieving branding default logo")})
    public Response getBrandingDefaultLogo(@Context Request request) {
        Logo logo = this.brandingService.getDefaultLogo();
        if (logo == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        long lastUpdated = logo.getUpdatedDate();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(logo.getData());
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }
}

