/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import opennlp.tools.ml.naivebayes.Probability;

public class LogProbability<T>
extends Probability<T> {
    public LogProbability(T label) {
        super(label);
        this.set(1.0);
    }

    @Override
    public void set(double probability) {
        this.probability = StrictMath.log(probability);
    }

    @Override
    public void set(Probability probability) {
        this.probability = probability.getLog();
    }

    @Override
    public void setIfLarger(double probability) {
        double logP = StrictMath.log(probability);
        if (this.probability < logP) {
            this.probability = logP;
        }
    }

    @Override
    public void setIfLarger(Probability probability) {
        if (this.probability < probability.getLog()) {
            this.probability = probability.getLog();
        }
    }

    @Override
    public boolean isLarger(Probability probability) {
        return this.probability < probability.getLog();
    }

    @Override
    public void setLog(double probability) {
        this.probability = probability;
    }

    @Override
    public void addIn(double probability) {
        this.setLog(this.probability + StrictMath.log(probability));
    }

    @Override
    public Double get() {
        return StrictMath.exp(this.probability);
    }

    @Override
    public Double getLog() {
        return this.probability;
    }

    @Override
    public T getLabel() {
        return (T)this.label;
    }

    @Override
    public String toString() {
        return this.label.toString() + ":" + this.probability;
    }
}

