/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.model;

import java.time.ZonedDateTime;
import java.util.List;
import org.exoplatform.agenda.constant.EventAttendeeResponse;

public class EventFilter
implements Cloneable {
    private long attendeeId;
    private List<Long> attendeeWithSpacesIds;
    private List<Long> ownerIds;
    private List<EventAttendeeResponse> responseTypes;
    private ZonedDateTime start;
    private ZonedDateTime end;
    private int offset;
    private int limit;

    public EventFilter(long attendeeId, List<Long> ownerIds, List<EventAttendeeResponse> responseTypes, ZonedDateTime start, ZonedDateTime end, int limit) {
        this.attendeeId = attendeeId;
        this.ownerIds = ownerIds;
        this.responseTypes = responseTypes;
        this.start = start;
        this.end = end;
        this.limit = limit;
    }

    public EventFilter(List<Long> ownerIds, ZonedDateTime start, ZonedDateTime end) {
        this.ownerIds = ownerIds;
        this.start = start;
        this.end = end;
    }

    public EventFilter(List<Long> ownerIds, int offset, int limit) {
        this.ownerIds = ownerIds;
        this.offset = offset;
        this.limit = limit;
    }

    public boolean isUseDates() {
        return this.start != null && this.end != null;
    }

    public EventFilter clone() {
        return new EventFilter(this.attendeeId, this.attendeeWithSpacesIds, this.ownerIds, this.responseTypes, this.start, this.end, this.offset, this.limit);
    }

    public long getAttendeeId() {
        return this.attendeeId;
    }

    public List<Long> getAttendeeWithSpacesIds() {
        return this.attendeeWithSpacesIds;
    }

    public List<Long> getOwnerIds() {
        return this.ownerIds;
    }

    public List<EventAttendeeResponse> getResponseTypes() {
        return this.responseTypes;
    }

    public ZonedDateTime getStart() {
        return this.start;
    }

    public ZonedDateTime getEnd() {
        return this.end;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setAttendeeId(long attendeeId) {
        this.attendeeId = attendeeId;
    }

    public void setAttendeeWithSpacesIds(List<Long> attendeeWithSpacesIds) {
        this.attendeeWithSpacesIds = attendeeWithSpacesIds;
    }

    public void setOwnerIds(List<Long> ownerIds) {
        this.ownerIds = ownerIds;
    }

    public void setResponseTypes(List<EventAttendeeResponse> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public void setStart(ZonedDateTime start) {
        this.start = start;
    }

    public void setEnd(ZonedDateTime end) {
        this.end = end;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAttendeeId() != other.getAttendeeId()) {
            return false;
        }
        List<Long> this$attendeeWithSpacesIds = this.getAttendeeWithSpacesIds();
        List<Long> other$attendeeWithSpacesIds = other.getAttendeeWithSpacesIds();
        if (this$attendeeWithSpacesIds == null ? other$attendeeWithSpacesIds != null : !((Object)this$attendeeWithSpacesIds).equals(other$attendeeWithSpacesIds)) {
            return false;
        }
        List<Long> this$ownerIds = this.getOwnerIds();
        List<Long> other$ownerIds = other.getOwnerIds();
        if (this$ownerIds == null ? other$ownerIds != null : !((Object)this$ownerIds).equals(other$ownerIds)) {
            return false;
        }
        List<EventAttendeeResponse> this$responseTypes = this.getResponseTypes();
        List<EventAttendeeResponse> other$responseTypes = other.getResponseTypes();
        if (this$responseTypes == null ? other$responseTypes != null : !((Object)this$responseTypes).equals(other$responseTypes)) {
            return false;
        }
        ZonedDateTime this$start = this.getStart();
        ZonedDateTime other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        ZonedDateTime this$end = this.getEnd();
        ZonedDateTime other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return this.getLimit() == other.getLimit();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $attendeeId = this.getAttendeeId();
        result = result * 59 + (int)($attendeeId >>> 32 ^ $attendeeId);
        List<Long> $attendeeWithSpacesIds = this.getAttendeeWithSpacesIds();
        result = result * 59 + ($attendeeWithSpacesIds == null ? 43 : ((Object)$attendeeWithSpacesIds).hashCode());
        List<Long> $ownerIds = this.getOwnerIds();
        result = result * 59 + ($ownerIds == null ? 43 : ((Object)$ownerIds).hashCode());
        List<EventAttendeeResponse> $responseTypes = this.getResponseTypes();
        result = result * 59 + ($responseTypes == null ? 43 : ((Object)$responseTypes).hashCode());
        ZonedDateTime $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        ZonedDateTime $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLimit();
        return result;
    }

    public String toString() {
        return "EventFilter(attendeeId=" + this.getAttendeeId() + ", attendeeWithSpacesIds=" + this.getAttendeeWithSpacesIds() + ", ownerIds=" + this.getOwnerIds() + ", responseTypes=" + this.getResponseTypes() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    public EventFilter(long attendeeId, List<Long> attendeeWithSpacesIds, List<Long> ownerIds, List<EventAttendeeResponse> responseTypes, ZonedDateTime start, ZonedDateTime end, int offset, int limit) {
        this.attendeeId = attendeeId;
        this.attendeeWithSpacesIds = attendeeWithSpacesIds;
        this.ownerIds = ownerIds;
        this.responseTypes = responseTypes;
        this.start = start;
        this.end = end;
        this.offset = offset;
        this.limit = limit;
    }

    public EventFilter() {
    }
}

